/*
 * Decompiled with CFR 0.152.
 */
package com.alone;

import com.alone.AloneConfig;
import com.alone.AlonePlugin;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class NotAloneOverlay
extends Overlay {
    private final Client client;
    private final AlonePlugin plugin;
    private final AloneConfig config;

    @Inject
    private NotAloneOverlay(Client client, AlonePlugin plugin, AloneConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.shouldRenderOverlay()) {
            Color color = graphics.getColor();
            graphics.setColor(this.config.overlayColor());
            graphics.fill(new Rectangle(this.client.getCanvas().getSize()));
            graphics.setColor(color);
        }
        return null;
    }
}

