/*
 * Decompiled with CFR 0.152.
 */
package com.alone;

import com.alone.AloneConfig;
import com.alone.NotAloneOverlay;
import com.google.inject.Provides;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Alone Man Mode")
public class AlonePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AlonePlugin.class);
    @Inject
    private Client client;
    @Inject
    private AloneConfig config;
    @Inject
    OverlayManager overlayManager;
    @Inject
    NotAloneOverlay overlay;
    ThreadPoolExecutor executor;
    private AtomicInteger players;
    private AtomicBoolean alone;

    protected void startUp() throws Exception {
        this.executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.players = new AtomicInteger(0);
        this.alone = new AtomicBoolean(true);
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.executor.shutdown();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.players.set(0);
            this.alone.set(true);
        }
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned event) {
        if (event.getPlayer().getId() == this.client.getLocalPlayer().getId()) {
            return;
        }
        this.executor.execute(() -> {
            if (this.players.incrementAndGet() > this.config.numPlayers()) {
                this.alone.set(false);
            } else {
                this.alone.set(true);
            }
        });
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned event) {
        if (event.getPlayer().getId() == this.client.getLocalPlayer().getId()) {
            return;
        }
        this.executor.execute(() -> {
            if (this.players.get() != 0 && this.players.decrementAndGet() > this.config.numPlayers()) {
                this.alone.set(false);
            } else {
                this.alone.set(true);
            }
        });
    }

    @Provides
    AloneConfig provideConfig(ConfigManager configManager) {
        return (AloneConfig)configManager.getConfig(AloneConfig.class);
    }

    boolean shouldRenderOverlay() {
        return !this.alone.get();
    }
}

