/*
 * Decompiled with CFR 0.152.
 */
package com.tayaramisu;

import com.tayaramisu.Sound;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.runelite.client.RuneLite;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SoundFileManager {
    private static final Logger log = LoggerFactory.getLogger(SoundFileManager.class);
    private static final File DOWNLOAD_DIR = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "jingle-jingle");
    private static final String DELETE_WARNING_FILENAME = "EXTRA_FILES_WILL_BE_DELETED_BUT_FOLDERS_WILL_REMAIN";
    private static final File DELETE_WARNING_FILE = new File(DOWNLOAD_DIR, "EXTRA_FILES_WILL_BE_DELETED_BUT_FOLDERS_WILL_REMAIN");
    private static final HttpUrl RAW_GITHUB = HttpUrl.parse((String)"https://raw.githubusercontent.com/Tayaramisu/JingleJingle/sounds");

    public static void ensureDownloadDirectoryExists() {
        if (!DOWNLOAD_DIR.exists()) {
            DOWNLOAD_DIR.mkdirs();
        }
        try {
            DELETE_WARNING_FILE.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void downloadAllMissingSounds(OkHttpClient okHttpClient) {
        Set<String> filesPresent = SoundFileManager.getFilesPresent();
        for (Sound sound : Sound.values()) {
            String fileNameToDownload = sound.getResourceName();
            if (filesPresent.contains(fileNameToDownload)) {
                filesPresent.remove(fileNameToDownload);
                continue;
            }
            if (RAW_GITHUB == null) {
                log.error("Jingle Jingle could not download jingles due to an unexpected null RAW_GITHUB value");
                return;
            }
            HttpUrl soundUrl = RAW_GITHUB.newBuilder().addPathSegment(fileNameToDownload).build();
            Path outputPath = Paths.get(DOWNLOAD_DIR.getPath(), fileNameToDownload);
            try (Response res = okHttpClient.newCall(new Request.Builder().url(soundUrl).build()).execute();){
                if (res.body() == null) continue;
                Files.copy(new BufferedInputStream(res.body().byteStream()), outputPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                log.error("Jingle Jingle could not download jingles", (Throwable)e);
                return;
            }
        }
        for (String filename : filesPresent) {
            File toDelete = new File(DOWNLOAD_DIR, filename);
            toDelete.delete();
        }
    }

    private static Set<String> getFilesPresent() {
        File[] downloadDirFiles = DOWNLOAD_DIR.listFiles();
        if (downloadDirFiles == null || downloadDirFiles.length == 0) {
            return new HashSet<String>();
        }
        return Arrays.stream(downloadDirFiles).filter(file -> !file.isDirectory()).map(File::getName).filter(filename -> !DELETE_WARNING_FILENAME.equals(filename)).collect(Collectors.toSet());
    }

    public static InputStream getSoundStream(Sound sound) throws FileNotFoundException {
        return new FileInputStream(new File(DOWNLOAD_DIR, sound.getResourceName()));
    }
}

