/*
 * Decompiled with CFR 0.152.
 */
package com.tayaramisu;

import com.tayaramisu.JingleJingleConfig;
import com.tayaramisu.Sound;
import com.tayaramisu.SoundFileManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SoundEngine {
    private static final Logger log = LoggerFactory.getLogger(SoundEngine.class);
    @Inject
    private JingleJingleConfig config;
    @Inject
    private Client client;
    private static final long CLIP_MTIME_UNLOADED = -2L;
    private long lastClipMTime = -2L;
    private Clip clip = null;

    private boolean loadClip(Sound sound) {
        boolean bl;
        BufferedInputStream stream = new BufferedInputStream(SoundFileManager.getSoundStream(sound));
        try {
            try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(stream);){
                this.clip.open(audioInputStream);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                log.warn("Failed to load jingle " + sound, (Throwable)e);
                return false;
            }
        }
        ((InputStream)stream).close();
        return bl;
    }

    public void playClip(Sound sound) {
        long currentMTime = System.currentTimeMillis();
        if (this.clip == null || currentMTime != this.lastClipMTime || !this.clip.isOpen()) {
            if (this.clip != null && this.clip.isOpen()) {
                this.clip.close();
            }
            try {
                this.clip = AudioSystem.getClip();
            }
            catch (LineUnavailableException e2) {
                this.lastClipMTime = -2L;
                log.warn("Failed to get clip for jingle " + sound, (Throwable)e2);
                return;
            }
            this.lastClipMTime = currentMTime;
            if (!this.loadClip(sound)) {
                return;
            }
        }
        int lastMusicVolume = this.client.getMusicVolume();
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float gain = 20.0f * (float)Math.log10((float)lastMusicVolume / 100.0f) - 0.07f;
        gain = Math.min(gain, volume.getMaximum());
        gain = Math.max(gain, volume.getMinimum());
        volume.setValue(gain);
        this.client.setMusicVolume(0);
        this.clip.addLineListener(e -> {
            if (e.getType() == LineEvent.Type.STOP) {
                this.client.setMusicVolume(lastMusicVolume);
            }
        });
        final Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                SoundEngine.this.clip.loop(0);
                t.cancel();
            }
        }, 600L);
    }

    public void close() {
        if (this.clip != null && this.clip.isOpen()) {
            this.clip.close();
        }
    }
}

