/*
 * Decompiled with CFR 0.152.
 */
package com.tayaramisu;

import com.google.inject.Provides;
import com.tayaramisu.JingleJingleConfig;
import com.tayaramisu.SoundEngine;
import com.tayaramisu.SoundFileManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Jingle Jingle", description="Adds customizable jingles for achievement diary tasks, mahogany homes, and more!")
public class JingleJinglePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(JingleJinglePlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private SoundEngine soundEngine;
    @Inject
    private JingleJingleConfig config;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private OkHttpClient okHttpClient;
    private final int[] varbitsAchievementDiaries = new int[]{4458, 4459, 4460, 4461, 4483, 4484, 4485, 4486, 4462, 4463, 4464, 4465, 4475, 4476, 4477, 4478, 3578, 3599, 3611, 4566, 7925, 7926, 7927, 7928, 4495, 4496, 4497, 4498, 4487, 4488, 4489, 4490, 4479, 4480, 4481, 4482, 4471, 4472, 4473, 4474, 4466, 4467, 4468, 4469};
    private static final Pattern COLLECTION_LOG_ITEM_REGEX = Pattern.compile("New item added to your collection log:.*");
    private static final Pattern COMBAT_TASK_REGEX = Pattern.compile("Congratulations, you've completed an? .* combat task:.*");
    private static final Pattern MAHOMES_PATTERN = Pattern.compile("You have completed .* contracts with a total of .* points\\.");
    private static final Pattern FARMING_CONTRACT_PATTERN = Pattern.compile("You've completed a Farming Guild Contract. You should return to Guildmaster Jane\\.");
    private static final Pattern ACHIEVEMENT_DIARY_TASK_PATTERN = Pattern.compile("<col=dc143c>Well done! You have completed an? (\\w+) task in the (\\w+) area\\. Your Achievement Diary has been updated\\.</col>");
    private static final Set<Integer> badCollectionLogNotificationSettingValues = new HashSet<Integer>(){
        {
            this.add(0);
            this.add(2);
        }
    };
    private final Map<Integer, Integer> oldAchievementDiaries = new HashMap<Integer, Integer>();
    private int lastLoginTick = -1;
    private int lastColLogSettingWarning = -1;
    private boolean gameStateLoggedIn = false;

    protected void startUp() throws Exception {
        this.clientThread.invoke(this::setupOldMaps);
        this.lastLoginTick = -1;
        this.executor.submit(() -> {
            SoundFileManager.ensureDownloadDirectoryExists();
            SoundFileManager.downloadAllMissingSounds(this.okHttpClient);
        });
    }

    protected void shutDown() throws Exception {
        this.oldAchievementDiaries.clear();
        this.soundEngine.close();
    }

    private void setupOldMaps() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            this.oldAchievementDiaries.clear();
        } else {
            for (int diary : this.varbitsAchievementDiaries) {
                int value = this.client.getVarbitValue(diary);
                this.oldAchievementDiaries.put(diary, value);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.gameStateLoggedIn = event.getGameState() == GameState.LOGGED_IN;
        switch (event.getGameState()) {
            case LOGIN_SCREEN: 
            case HOPPING: 
            case LOGGING_IN: 
            case LOGIN_SCREEN_AUTHENTICATOR: {
                this.oldAchievementDiaries.clear();
            }
            case CONNECTION_LOST: {
                this.lastLoginTick = -1;
                this.lastColLogSettingWarning = this.client.getTickCount();
                break;
            }
            case LOGGED_IN: {
                this.lastLoginTick = this.client.getTickCount();
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE && chatMessage.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (COLLECTION_LOG_ITEM_REGEX.matcher(chatMessage.getMessage()).matches()) {
            this.soundEngine.playClip(this.config.collectionLogJingle());
        } else if (COMBAT_TASK_REGEX.matcher(chatMessage.getMessage()).matches()) {
            this.soundEngine.playClip(this.config.combatTaskJingle());
        } else if (MAHOMES_PATTERN.matcher(chatMessage.getMessage()).matches()) {
            this.soundEngine.playClip(this.config.mahomesJingle());
        } else if (FARMING_CONTRACT_PATTERN.matcher(chatMessage.getMessage()).matches()) {
            this.soundEngine.playClip(this.config.farmingContractJingle());
        } else {
            Matcher m = ACHIEVEMENT_DIARY_TASK_PATTERN.matcher(chatMessage.getMessage());
            if (m.matches()) {
                if (m.group(2).equals("Ardougne") && this.config.playArdougneDiary()) {
                    this.soundEngine.playClip(this.config.ardougneTaskJingle());
                } else if (m.group(2).equals("Desert") && this.config.playDesertDiary()) {
                    this.soundEngine.playClip(this.config.desertTaskJingle());
                } else if (m.group(2).equals("Falador") && this.config.playFaladorDiary()) {
                    this.soundEngine.playClip(this.config.desertTaskJingle());
                } else if (m.group(2).equals("Fremennik") && this.config.playFremennikDiary()) {
                    this.soundEngine.playClip(this.config.fremennikTaskJingle());
                } else if (m.group(2).equals("Kandarin") && this.config.playKandarinDiary()) {
                    this.soundEngine.playClip(this.config.kandarinTaskJingle());
                } else if (m.group(2).equals("Karamja") && this.config.playKaramjaDiary()) {
                    this.soundEngine.playClip(this.config.karamjaTaskJingle());
                } else if (m.group(2).equals("Kourend & Kebos") && this.config.playKourendDiary()) {
                    this.soundEngine.playClip(this.config.kourendTaskJingle());
                } else if (m.group(2).equals("Lumbridge & Draynor") && this.config.playLumbridgeDiary()) {
                    this.soundEngine.playClip(this.config.lumbridgeTaskJingle());
                } else if (m.group(2).equals("Morytania") && this.config.playMorytaniaDiary()) {
                    this.soundEngine.playClip(this.config.morytaniaTaskJingle());
                } else if (m.group(2).equals("Varrock") && this.config.playVarrockDiary()) {
                    this.soundEngine.playClip(this.config.varrockTaskJingle());
                } else if (m.group(2).equals("Western Provinces") && this.config.playWesternProvincesDiary()) {
                    this.soundEngine.playClip(this.config.westernProvincesTaskJingle());
                } else if (m.group(2).equals("Wilderness") && this.config.playWildernessDiary()) {
                    this.soundEngine.playClip(this.config.wildernessTaskJingle());
                }
            }
        }
    }

    private void checkAndWarnForCollectionLogNotificationSetting(int newVarbitValue) {
        if (!this.config.playCollectionLog()) {
            return;
        }
        if (!this.gameStateLoggedIn) {
            return;
        }
        if (badCollectionLogNotificationSettingValues.contains(newVarbitValue) && (this.lastColLogSettingWarning == -1 || this.client.getTickCount() - this.lastColLogSettingWarning > 16)) {
            this.lastColLogSettingWarning = this.client.getTickCount();
            this.sendHighlightedMessage("Please enable \"Collection log - New addition notification\" in your game settings for the Collection Log jingle to play! (The chat message one, pop-up doesn't matter)");
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (varbitChanged.getVarbitId() == 11959) {
            this.checkAndWarnForCollectionLogNotificationSetting(varbitChanged.getValue());
        }
        if (this.lastLoginTick == -1 || this.client.getTickCount() - this.lastLoginTick < 8) {
            return;
        }
        block14: for (int diary : this.varbitsAchievementDiaries) {
            int newValue = this.client.getVarbitValue(diary);
            int previousValue = this.oldAchievementDiaries.getOrDefault(diary, -1);
            this.oldAchievementDiaries.put(diary, newValue);
            if (previousValue == -1 || previousValue == newValue || !this.isAchievementDiaryCompleted(diary, newValue)) continue;
            switch (diary) {
                case 4458: 
                case 4459: 
                case 4460: 
                case 4461: {
                    if (!this.config.playArdougneDiary()) continue block14;
                    this.soundEngine.playClip(this.config.ardougneCompletionJingle());
                    continue block14;
                }
                case 4483: 
                case 4484: 
                case 4485: 
                case 4486: {
                    if (!this.config.playDesertDiary()) continue block14;
                    this.soundEngine.playClip(this.config.desertCompletionJingle());
                    continue block14;
                }
                case 4462: 
                case 4463: 
                case 4464: 
                case 4465: {
                    if (!this.config.playFaladorDiary()) continue block14;
                    this.soundEngine.playClip(this.config.faladorCompletionJingle());
                    continue block14;
                }
                case 4491: 
                case 4492: 
                case 4493: 
                case 4494: {
                    if (!this.config.playFremennikDiary()) continue block14;
                    this.soundEngine.playClip(this.config.fremennikCompletionJingle());
                    continue block14;
                }
                case 4475: 
                case 4476: 
                case 4477: 
                case 4478: {
                    if (!this.config.playKandarinDiary()) continue block14;
                    this.soundEngine.playClip(this.config.kandarinCompletionJingle());
                    continue block14;
                }
                case 3578: 
                case 3599: 
                case 3611: 
                case 4566: {
                    if (!this.config.playKaramjaDiary()) continue block14;
                    this.soundEngine.playClip(this.config.karamjaCompletionJingle());
                    continue block14;
                }
                case 7925: 
                case 7926: 
                case 7927: 
                case 7928: {
                    if (!this.config.playKourendDiary()) continue block14;
                    this.soundEngine.playClip(this.config.kourendCompletionJingle());
                    continue block14;
                }
                case 4495: 
                case 4496: 
                case 4497: 
                case 4498: {
                    if (!this.config.playLumbridgeDiary()) continue block14;
                    this.soundEngine.playClip(this.config.lumbridgeCompletionJingle());
                    continue block14;
                }
                case 4487: 
                case 4488: 
                case 4489: 
                case 4490: {
                    if (!this.config.playMorytaniaDiary()) continue block14;
                    this.soundEngine.playClip(this.config.morytaniaCompletionJingle());
                    continue block14;
                }
                case 4479: 
                case 4480: 
                case 4481: 
                case 4482: {
                    if (!this.config.playVarrockDiary()) continue block14;
                    this.soundEngine.playClip(this.config.varrockCompletionJingle());
                    continue block14;
                }
                case 4471: 
                case 4472: 
                case 4473: 
                case 4474: {
                    if (!this.config.playWesternProvincesDiary()) continue block14;
                    this.soundEngine.playClip(this.config.westernProvincesCompletionJingle());
                    continue block14;
                }
                case 4466: 
                case 4467: 
                case 4468: 
                case 4469: {
                    if (!this.config.playWildernessDiary()) continue block14;
                    this.soundEngine.playClip(this.config.wildernessCompletionJingle());
                }
            }
        }
    }

    private boolean isAchievementDiaryCompleted(int diary, int value) {
        switch (diary) {
            case 3578: 
            case 3599: 
            case 3611: {
                return value == 2;
            }
        }
        return value == 1;
    }

    @Provides
    JingleJingleConfig provideConfig(ConfigManager configManager) {
        return (JingleJingleConfig)configManager.getConfig(JingleJingleConfig.class);
    }

    private void sendHighlightedMessage(String message) {
        String highlightedMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(highlightedMessage).build());
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("jingles".equals(event.getGroup())) {
            if ("collectionLogJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.collectionLogJingle());
            } else if ("combatTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.combatTaskJingle());
            } else if ("mahomesJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.mahomesJingle());
            } else if ("farmingContractJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.farmingContractJingle());
            } else if ("ardougneTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.ardougneTaskJingle());
            } else if ("ardougneCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.ardougneCompletionJingle());
            } else if ("desertTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.desertTaskJingle());
            } else if ("desertCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.desertCompletionJingle());
            } else if ("faladorTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.faladorTaskJingle());
            } else if ("faladorCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.faladorCompletionJingle());
            } else if ("fremennikTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.fremennikTaskJingle());
            } else if ("fremennikCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.fremennikCompletionJingle());
            } else if ("kandarinTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.kandarinTaskJingle());
            } else if ("kandarinCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.kandarinCompletionJingle());
            } else if ("karamjaTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.karamjaTaskJingle());
            } else if ("karamjaCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.karamjaCompletionJingle());
            } else if ("kourendTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.kourendTaskJingle());
            } else if ("kourendCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.kourendCompletionJingle());
            } else if ("lumbridgeTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.lumbridgeTaskJingle());
            } else if ("lumbridgeCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.lumbridgeCompletionJingle());
            } else if ("morytaniaTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.morytaniaTaskJingle());
            } else if ("morytaniaCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.morytaniaCompletionJingle());
            } else if ("varrockTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.varrockTaskJingle());
            } else if ("varrockCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.varrockCompletionJingle());
            } else if ("westernProvincesTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.westernProvincesTaskJingle());
            } else if ("westernProvincesCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.westernProvincesCompletionJingle());
            } else if ("wildernessTaskJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.wildernessTaskJingle());
            } else if ("wildernessCompletionJingle".equals(event.getKey())) {
                this.soundEngine.playClip(this.config.wildernessCompletionJingle());
            }
        }
    }

    ClientThread getClientThread() {
        return this.clientThread;
    }
}

