/*
 * Decompiled with CFR 0.152.
 */
package com.bram91.specregen;

import com.bram91.specregen.SpecRegenTimerOverlay;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Spec Regen Timer", description="Shows remaining time till next special attack availability and the amount available")
public class SpecRegenTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpecRegenTimerPlugin.class);
    private double specialPercentage;
    private int ticksSinceSpecRegen;
    private static final int SPEC_REGEN_TICKS = 50;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SpecRegenTimerOverlay overlay;

    protected void startUp() throws Exception {
        log.info("Spec Regen Timer started!");
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        log.info("Spec Regen Timer stopped!");
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.ticksSinceSpecRegen = this.client.getVar(300) == 1000 ? 0 : (this.ticksSinceSpecRegen + 1) % 50;
        this.specialPercentage = (double)this.ticksSinceSpecRegen / 50.0;
        this.overlay.updateSpec();
    }

    public double getSpecialPercentage() {
        return this.specialPercentage;
    }
}

