/*
 * Decompiled with CFR 0.152.
 */
package com.bram91.specregen;

import com.bram91.specregen.SpecRegenTimerPlugin;
import com.bram91.specregen.Weapons;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

public class SpecRegenTimerOverlay
extends Overlay {
    private final Client client;
    private SpecRegenTimerPlugin plugin;
    private final TooltipManager tooltipManager;
    private final HashMap<String, Integer> weapons;
    @Inject
    private ItemManager itemManager;
    private double currentSpec;
    private int specCount;
    private int maxSpecs;
    private int remainingMinutes;
    private String remainingSecondsString;

    @Inject
    public SpecRegenTimerOverlay(Client client, SpecRegenTimerPlugin plugin, TooltipManager tooltipManager) {
        this.tooltipManager = tooltipManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.plugin = plugin;
        this.weapons = Weapons.getWeapons();
    }

    public Dimension render(Graphics2D graphics2D) {
        Point mousePosition;
        Widget widget = this.client.getWidget(WidgetInfo.MINIMAP_SPEC_ORB);
        if (widget == null) {
            return null;
        }
        Rectangle bounds = widget.getBounds();
        if (bounds.contains((mousePosition = this.client.getMouseCanvasPosition()).getX(), mousePosition.getY())) {
            String tooltip = this.currentSpec == 100.0 || this.specCount == this.maxSpecs ? "Available special attacks: " + this.specCount : "Time Remaining till next spec: " + this.remainingMinutes + ":" + this.remainingSecondsString + "</br>Available special attacks: " + this.specCount;
            this.tooltipManager.add(new Tooltip(tooltip));
        }
        return null;
    }

    public void updateSpec() {
        if (this.client.getItemContainer(InventoryID.EQUIPMENT) == null) {
            return;
        }
        this.currentSpec = Math.floor((double)(this.client.getVar(300) / 10) + this.plugin.getSpecialPercentage() * 10.0);
        int specTarget = 100;
        Item[] items = this.client.getItemContainer(InventoryID.EQUIPMENT).getItems();
        if (items.length <= EquipmentInventorySlot.WEAPON.getSlotIdx()) {
            return;
        }
        Item weapon = items[EquipmentInventorySlot.WEAPON.getSlotIdx()];
        ItemComposition weaponComp = this.itemManager.getItemComposition(weapon.getId());
        String weaponName = weaponComp.getName().toLowerCase().equals("magic shortbow (i)") ? "magic shortbow (i)" : weaponComp.getName().replaceAll("\\([^()]*\\)", "").toLowerCase();
        if (this.weapons.containsKey(weaponName)) {
            specTarget = weaponName.equals("granite maul") && Arrays.asList(24225, 24226, 24227, 24228).contains(weaponComp.getId()) ? 50 : this.weapons.get(weaponName);
        }
        this.specCount = (int)(this.currentSpec / (double)specTarget);
        double remainingSpec = (double)specTarget - this.currentSpec % (double)specTarget;
        int remainingTicks = (int)(remainingSpec / 0.2);
        int remainingTime = (int)((double)remainingTicks * 0.6);
        int remainingSeconds = remainingTime % 60;
        this.remainingMinutes = (int)Math.floor(remainingTime / 60);
        this.remainingSecondsString = "" + remainingSeconds;
        if (remainingSeconds < 10) {
            this.remainingSecondsString = "0" + remainingSeconds;
        }
        this.maxSpecs = (int)Math.floor(100 / specTarget);
    }
}

