/*
 * Decompiled with CFR 0.152.
 */
package com.lowdetailchambers;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.lowmemory.LowMemoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Low Detail Chambers", description="Turn off ground decorations and certain textures only inside of Chambers of Xeric", tags={"memory", "usage", "ground", "decorations", "chambers", "cox"})
public class LowDetailChambersPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LowDetailChambersPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ConfigManager configManager;

    protected void startUp() throws Exception {
        this.clientThread.invoke(() -> {
            if (this.client.getGameState().getState() >= GameState.LOGIN_SCREEN.getState()) {
                if (this.client.getVarbitValue(5432) == 1 && this.lowDetailDisabled()) {
                    this.client.changeMemoryMode(true);
                }
                return true;
            }
            return false;
        });
    }

    protected void shutDown() throws Exception {
        this.clientThread.invoke(() -> {
            if (this.lowDetailDisabled()) {
                this.client.changeMemoryMode(false);
            }
        });
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarbitId() == 5432 && this.lowDetailDisabled()) {
            if (event.getValue() == 1) {
                this.client.changeMemoryMode(true);
            } else {
                this.client.changeMemoryMode(false);
            }
        }
    }

    private boolean lowDetailDisabled() {
        String value = this.configManager.getConfiguration("runelite", "lowmemoryplugin");
        boolean lowMemoryPluginEnabled = value != null ? Boolean.parseBoolean(value) : false;
        boolean lowMemoryConfigEnabled = ((LowMemoryConfig)this.configManager.getConfig(LowMemoryConfig.class)).lowDetail();
        return !lowMemoryPluginEnabled | !lowMemoryConfigEnabled;
    }
}

