/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.mahoganyhomes;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.UsernameChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.mahoganyhomes.Home;
import thestonedturtle.mahoganyhomes.Hotspot;
import thestonedturtle.mahoganyhomes.MahoganyHomesConfig;
import thestonedturtle.mahoganyhomes.MahoganyHomesHighlightOverlay;
import thestonedturtle.mahoganyhomes.MahoganyHomesOverlay;
import thestonedturtle.mahoganyhomes.MahoganyHomesWorldPoint;

@PluginDescriptor(name="Mahogany Homes")
public class MahoganyHomesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MahoganyHomesPlugin.class);
    @VisibleForTesting
    static final Pattern CONTRACT_PATTERN = Pattern.compile("(Please could you g|G)o see (\\w*)[ ,][\\w\\s,-]*[?.] You can get another job once you have furnished \\w* home\\.");
    private static final Pattern CONTRACT_FINISHED = Pattern.compile("You have completed [\\d,]* contracts with a total of [\\d,]* points?\\.");
    private static final Pattern REQUEST_CONTACT_TIER = Pattern.compile("Could I have an? (\\w*) contract please\\?");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private MahoganyHomesConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MahoganyHomesOverlay textOverlay;
    @Inject
    private MahoganyHomesHighlightOverlay highlightOverlay;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    private final List<GameObject> objectsToMark = new ArrayList<GameObject>();
    private final HashMap<Integer, Integer> varbMap = new HashMap();
    private BufferedImage mapIcon;
    private BufferedImage mapArrow;
    private Home currentHome;
    private boolean varbChange;
    private boolean wasTimedOut;
    private int contractTier = 0;
    private Instant lastChanged;
    private int lastCompletedCount = -1;
    private int sessionContracts = 0;
    private int sessionPoints = 0;
    private Duration pluginTimeoutDuration = Duration.ofMinutes(5L);

    @Provides
    MahoganyHomesConfig provideConfig(ConfigManager configManager) {
        return (MahoganyHomesConfig)configManager.getConfig(MahoganyHomesConfig.class);
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.textOverlay);
        this.overlayManager.add((Overlay)this.highlightOverlay);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.loadFromConfig();
            this.clientThread.invoke(this::updateVarbMap);
        }
        this.lastChanged = Instant.now();
        this.lastCompletedCount = 0;
        this.pluginTimeoutDuration = Duration.ofMinutes(this.config.sessionTimeout());
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.textOverlay);
        this.overlayManager.remove((Overlay)this.highlightOverlay);
        this.worldMapPointManager.removeIf(MahoganyHomesWorldPoint.class::isInstance);
        this.client.clearHintArrow();
        this.varbMap.clear();
        this.objectsToMark.clear();
        this.currentHome = null;
        this.mapIcon = null;
        this.mapArrow = null;
        this.lastChanged = null;
        this.lastCompletedCount = -1;
        this.contractTier = 0;
        this.wasTimedOut = false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged c) {
        if (!c.getGroup().equals("MahoganyHomes")) {
            return;
        }
        if (c.getKey().equals("worldMapIcon")) {
            this.worldMapPointManager.removeIf(MahoganyHomesWorldPoint.class::isInstance);
            if (this.config.worldMapIcon() && this.currentHome != null) {
                this.worldMapPointManager.add((WorldMapPoint)new MahoganyHomesWorldPoint(this.currentHome.getLocation(), this));
            }
        } else if (c.getKey().equals("displayHintArrows")) {
            this.client.clearHintArrow();
            if (this.client.getLocalPlayer() != null) {
                this.refreshHintArrow(this.client.getLocalPlayer().getWorldLocation());
            }
        } else if (c.getKey().equals("sessionTimeout")) {
            this.pluginTimeoutDuration = Duration.ofMinutes(this.config.sessionTimeout());
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.varbChange = true;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged e) {
        if (e.getGameState() == GameState.LOADING) {
            this.objectsToMark.clear();
        }
    }

    @Subscribe
    public void onUsernameChanged(UsernameChanged e) {
        this.loadFromConfig();
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.processGameObjects(event.getGameObject(), null);
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.processGameObjects(null, event.getGameObject());
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked e) {
        if (!e.getOverlay().equals((Object)this.textOverlay)) {
            return;
        }
        if (e.getEntry().getOption().equals("Clear")) {
            this.setCurrentHome(null);
            this.updateConfig();
            this.lastChanged = null;
        }
        if (e.getEntry().getOption().equals("Timeout")) {
            this.lastChanged = Instant.now().minus(this.pluginTimeoutDuration);
            this.worldMapPointManager.removeIf(MahoganyHomesWorldPoint.class::isInstance);
            this.client.clearHintArrow();
            this.wasTimedOut = true;
        }
        if (e.getEntry().getOption().equals("Reset")) {
            this.sessionContracts = 0;
            this.sessionPoints = 0;
        }
    }

    @Subscribe
    public void onGameTick(GameTick t) {
        if (this.contractTier == 0 || this.currentHome == null) {
            this.checkForContractTierDialog();
        }
        this.checkForAssignmentDialog();
        if (this.currentHome == null) {
            return;
        }
        if (this.varbChange) {
            int completed;
            this.varbChange = false;
            this.updateVarbMap();
            if (this.contractTier == 0) {
                this.calculateContractTier();
            }
            if ((completed = this.getCompletedCount()) != this.lastCompletedCount) {
                if (this.wasTimedOut) {
                    this.setCurrentHome(this.currentHome);
                    this.updateVarbMap();
                    this.wasTimedOut = false;
                }
                this.lastCompletedCount = completed;
                this.lastChanged = Instant.now();
            }
        }
        if (this.isPluginTimedOut()) {
            if (!this.wasTimedOut) {
                this.worldMapPointManager.removeIf(MahoganyHomesWorldPoint.class::isInstance);
                this.client.clearHintArrow();
            }
            this.wasTimedOut = true;
            return;
        }
        this.refreshHintArrow(this.client.getLocalPlayer().getWorldLocation());
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (!e.getType().equals((Object)ChatMessageType.GAMEMESSAGE)) {
            return;
        }
        if (CONTRACT_FINISHED.matcher(Text.removeTags((String)e.getMessage())).matches()) {
            ++this.sessionContracts;
            this.sessionPoints += this.getPointsForCompletingTask();
            this.setCurrentHome(null);
            this.updateConfig();
        }
    }

    private void checkForContractTierDialog() {
        Widget dialog = this.client.getWidget(WidgetInfo.DIALOG_PLAYER_TEXT);
        if (dialog == null) {
            return;
        }
        String text = Text.sanitizeMultilineText((String)dialog.getText());
        Matcher matcher = REQUEST_CONTACT_TIER.matcher(text);
        if (matcher.matches()) {
            String type;
            switch (type = matcher.group(1).toLowerCase()) {
                case "beginner": {
                    this.contractTier = 1;
                    break;
                }
                case "novice": {
                    this.contractTier = 2;
                    break;
                }
                case "adept": {
                    this.contractTier = 3;
                    break;
                }
                case "expert": {
                    this.contractTier = 4;
                }
            }
        }
    }

    private void checkForAssignmentDialog() {
        Widget dialog = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
        if (dialog == null) {
            return;
        }
        String npcText = Text.sanitizeMultilineText((String)dialog.getText());
        Matcher startContractMatcher = CONTRACT_PATTERN.matcher(npcText);
        if (startContractMatcher.matches()) {
            String name = startContractMatcher.group(2);
            if (this.contractTier == 0) {
                this.loadFromConfig();
                if (this.currentHome != null && this.currentHome.getName().equalsIgnoreCase(name)) {
                    return;
                }
            }
            for (Home h : Home.values()) {
                if (!h.getName().equalsIgnoreCase(name) || this.currentHome == h && !this.isPluginTimedOut()) continue;
                this.setCurrentHome(h);
                this.updateConfig();
                break;
            }
        }
    }

    private void setCurrentHome(Home h) {
        this.currentHome = h;
        this.client.clearHintArrow();
        this.lastChanged = Instant.now();
        this.lastCompletedCount = 0;
        this.varbMap.clear();
        if (this.currentHome == null) {
            this.worldMapPointManager.removeIf(MahoganyHomesWorldPoint.class::isInstance);
            this.contractTier = 0;
            return;
        }
        if (this.config.worldMapIcon()) {
            this.worldMapPointManager.removeIf(MahoganyHomesWorldPoint.class::isInstance);
            this.worldMapPointManager.add((WorldMapPoint)new MahoganyHomesWorldPoint(h.getLocation(), this));
        }
        if (this.config.displayHintArrows() && this.client.getLocalPlayer() != null) {
            this.refreshHintArrow(this.client.getLocalPlayer().getWorldLocation());
        }
    }

    private void processGameObjects(GameObject cur, GameObject prev) {
        this.objectsToMark.remove(prev);
        if (cur == null || !Hotspot.isHotspotObject(cur.getId()) && !Home.isLadder(cur.getId())) {
            return;
        }
        this.objectsToMark.add(cur);
    }

    private void updateVarbMap() {
        this.varbMap.clear();
        for (Hotspot spot : Hotspot.values()) {
            this.varbMap.put(spot.getVarb(), this.client.getVarbitValue(spot.getVarb()));
        }
    }

    private void loadFromConfig() {
        String group = "MahoganyHomes." + this.client.getAccountHash();
        String name = this.configManager.getConfiguration(group, "currentHome");
        if (name == null) {
            return;
        }
        try {
            Home h = Home.valueOf(name.trim().toUpperCase());
            this.setCurrentHome(h);
        }
        catch (IllegalArgumentException e) {
            log.warn("Stored unrecognized home: {}", (Object)name);
            this.currentHome = null;
            this.configManager.setConfiguration(group, "currentHome", null);
        }
        if (this.currentHome == null) {
            return;
        }
        String tier = this.configManager.getConfiguration(group, "currentTier");
        if (tier == null) {
            return;
        }
        try {
            this.contractTier = Integer.parseInt(tier);
        }
        catch (IllegalArgumentException e) {
            log.warn("Stored unrecognized contract tier: {}", (Object)tier);
            this.contractTier = 0;
            this.configManager.unsetConfiguration(group, "currentTier");
        }
    }

    private void updateConfig() {
        String group = "MahoganyHomes." + this.client.getAccountHash();
        if (this.currentHome == null) {
            this.configManager.unsetConfiguration(group, "currentHome");
            this.configManager.unsetConfiguration(group, "currentTier");
        } else {
            this.configManager.setConfiguration(group, "currentHome", this.currentHome.getName());
            this.configManager.setConfiguration(group, "currentTier", (Object)this.contractTier);
        }
    }

    private void refreshHintArrow(WorldPoint playerPos) {
        this.client.clearHintArrow();
        if (this.currentHome == null || !this.config.displayHintArrows()) {
            return;
        }
        if (this.distanceBetween(this.currentHome.getArea(), playerPos) > 0) {
            this.client.setHintArrow(this.currentHome.getLocation());
        } else {
            if (this.getCompletedCount() != 0) {
                return;
            }
            Optional<NPC> npc = this.client.getNpcs().stream().filter(n -> n.getId() == this.currentHome.getNpcId()).findFirst();
            if (npc.isPresent()) {
                this.client.setHintArrow(npc.get());
                return;
            }
            WorldPoint location = null;
            int distance = Integer.MAX_VALUE;
            for (GameObject obj : this.objectsToMark) {
                int diff;
                if (!Home.isLadder(obj.getId()) || this.distanceBetween(this.currentHome.getArea(), obj.getWorldLocation()) > 0 || (diff = obj.getWorldLocation().distanceTo(this.client.getLocalPlayer().getWorldLocation())) >= distance) continue;
                distance = diff;
                location = obj.getWorldLocation();
            }
            if (location != null) {
                this.client.setHintArrow(location);
            }
        }
    }

    int getCompletedCount() {
        if (this.currentHome == null) {
            return -1;
        }
        int count = 0;
        for (Hotspot hotspot : Hotspot.values()) {
            boolean requiresAttention = this.doesHotspotRequireAttention(hotspot.getVarb());
            if (!requiresAttention) continue;
            ++count;
        }
        return count;
    }

    boolean doesHotspotRequireAttention(int varb) {
        Integer val = this.varbMap.get(varb);
        if (val == null) {
            return false;
        }
        return val == 1 || val == 3 || val == 4;
    }

    int distanceBetween(WorldArea area, WorldPoint point) {
        return area.distanceTo(new WorldPoint(point.getX(), point.getY(), area.getPlane()));
    }

    BufferedImage getMapIcon() {
        if (this.mapIcon != null) {
            return this.mapIcon;
        }
        this.mapIcon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"map-icon.png");
        return this.mapIcon;
    }

    BufferedImage getMapArrow() {
        if (this.mapArrow != null) {
            return this.mapArrow;
        }
        this.mapArrow = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"map-arrow-icon.png");
        return this.mapArrow;
    }

    boolean isPluginTimedOut() {
        return this.lastChanged != null && Duration.between(this.lastChanged, Instant.now()).compareTo(this.pluginTimeoutDuration) >= 0;
    }

    int getPointsForCompletingTask() {
        return this.getContractTier() + 1;
    }

    private void calculateContractTier() {
        int tier = 0;
        for (int val : this.varbMap.values()) {
            tier = Math.max(tier, val);
        }
        this.contractTier = Math.max(tier -= 4, 0);
    }

    public Set<Integer> getRepairableVarbs() {
        return this.varbMap.keySet().stream().filter(this::doesHotspotRequireAttention).collect(Collectors.toSet());
    }

    public Client getClient() {
        return this.client;
    }

    public List<GameObject> getObjectsToMark() {
        return this.objectsToMark;
    }

    public Home getCurrentHome() {
        return this.currentHome;
    }

    public int getContractTier() {
        return this.contractTier;
    }

    public int getSessionContracts() {
        return this.sessionContracts;
    }

    public int getSessionPoints() {
        return this.sessionPoints;
    }
}

