/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.mahoganyhomes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import thestonedturtle.mahoganyhomes.Home;
import thestonedturtle.mahoganyhomes.MahoganyHomesConfig;
import thestonedturtle.mahoganyhomes.MahoganyHomesPlugin;
import thestonedturtle.mahoganyhomes.RequiredMaterials;

class MahoganyHomesOverlay
extends OverlayPanel {
    static final String RESET_SESSION_OPTION = "Reset";
    static final String CLEAR_OPTION = "Clear";
    static final String TIMEOUT_OPTION = "Timeout";
    private final MahoganyHomesPlugin plugin;
    private final MahoganyHomesConfig config;

    @Inject
    MahoganyHomesOverlay(MahoganyHomesPlugin plugin, MahoganyHomesConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.plugin = plugin;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Mahogany Homes Overlay"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, TIMEOUT_OPTION, "Mahogany Homes Plugin"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, RESET_SESSION_OPTION, "Session Data"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, CLEAR_OPTION, "Contract"));
    }

    public Dimension render(Graphics2D graphics) {
        Home home = this.plugin.getCurrentHome();
        Player player = this.plugin.getClient().getLocalPlayer();
        if (this.plugin.isPluginTimedOut() || !this.config.textOverlay() || player == null) {
            return null;
        }
        if (home != null) {
            this.addLine(home.getName());
            this.addLine(home.getHint());
            if (this.plugin.distanceBetween(home.getArea(), player.getWorldLocation()) > 0) {
                if (this.config.showRequiredMaterials() && this.plugin.getContractTier() > 0) {
                    this.addLine("");
                    this.addLine(home.getRequiredPlanks(this.plugin.getContractTier()));
                    String bars = home.getRequiredSteelBars(this.plugin.getContractTier());
                    if (bars != null) {
                        this.addLine(bars);
                    }
                }
                if (this.config.worldMapIcon()) {
                    this.addLine("");
                    this.addLine("Click the house icon on your world map to see where to go");
                }
            } else {
                if (this.config.showRequiredMaterials() && this.plugin.getContractTier() > 0) {
                    String plural;
                    RequiredMaterials requiredMaterials = home.getHotspotObjects().getRequiredMaterialsForVarbs(this.plugin.getRepairableVarbs());
                    if (requiredMaterials.MinPlanks > 0 || requiredMaterials.MinSteelBars > 0) {
                        this.addLine("");
                    }
                    if (requiredMaterials.MinPlanks > 0) {
                        plural = requiredMaterials.MinPlanks > 1 ? "s" : "";
                        this.addLine(String.format("%d plank" + plural, requiredMaterials.MinPlanks));
                    }
                    if (requiredMaterials.MinSteelBars > 0) {
                        plural = requiredMaterials.MinSteelBars > 1 ? "s" : "";
                        this.addLine(String.format("%d steel bar" + plural, requiredMaterials.MinSteelBars));
                    }
                }
                this.addLine("");
                int count = this.plugin.getCompletedCount();
                if (count > 0) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left(count + " task(s) remaining").leftColor(Color.RED).build());
                } else {
                    this.panelComponent.getChildren().add(LineComponent.builder().left("All tasks completed, speak to " + home.getName()).leftColor(Color.GREEN).build());
                }
            }
        }
        if (this.config.showSessionStats() && this.plugin.getSessionContracts() > 0) {
            if (home != null) {
                this.addLine("");
            }
            this.addLine("Contracts Done: " + this.plugin.getSessionContracts());
            this.addLine("Points Earned: " + this.plugin.getSessionPoints());
        }
        return super.render(graphics);
    }

    private void addLine(String left) {
        this.panelComponent.getChildren().add(LineComponent.builder().left(left).build());
    }
}

