/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.mahoganyhomes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.TileObject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import thestonedturtle.mahoganyhomes.Home;
import thestonedturtle.mahoganyhomes.Hotspot;
import thestonedturtle.mahoganyhomes.MahoganyHomesConfig;
import thestonedturtle.mahoganyhomes.MahoganyHomesPlugin;

class MahoganyHomesHighlightOverlay
extends Overlay {
    public static final Color CLICKBOX_BORDER_COLOR = Color.ORANGE;
    public static final Color CLICKBOX_HOVER_BORDER_COLOR = CLICKBOX_BORDER_COLOR.darker();
    private final MahoganyHomesPlugin plugin;
    private final MahoganyHomesConfig config;

    @Inject
    MahoganyHomesHighlightOverlay(MahoganyHomesPlugin plugin, MahoganyHomesConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        Home home = this.plugin.getCurrentHome();
        Player player = this.plugin.getClient().getLocalPlayer();
        if (this.plugin.isPluginTimedOut() || home == null || player == null) {
            return null;
        }
        for (TileObject tileObject : this.plugin.getObjectsToMark()) {
            if (tileObject.getPlane() != this.plugin.getClient().getPlane() || this.plugin.distanceBetween(home.getArea(), tileObject.getWorldLocation()) > 0) continue;
            Color fillColor = this.config.highlightHotspotColor();
            Hotspot spot = Hotspot.getByObjectId(tileObject.getId());
            if (spot == null) {
                if (!Home.isLadder(tileObject.getId()) || !this.config.highlightStairs()) continue;
                fillColor = this.config.highlightStairsColor();
            } else if (!this.config.highlightHotspots() || !this.plugin.doesHotspotRequireAttention(spot.getVarb())) continue;
            Point mousePosition = this.plugin.getClient().getMouseCanvasPosition();
            OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)tileObject.getClickbox(), (Point)mousePosition, (Color)fillColor, (Color)CLICKBOX_BORDER_COLOR, (Color)CLICKBOX_HOVER_BORDER_COLOR);
        }
        return null;
    }
}

