/*
 * Decompiled with CFR 0.152.
 */
package com.micro.petinfo.dataretrieval;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.micro.petinfo.dataretrieval.Pet;
import com.micro.petinfo.dataretrieval.PetInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PetDataFetcher {
    private static final Logger log = LoggerFactory.getLogger(PetDataFetcher.class);
    private final OkHttpClient okHttpClient;
    private final Gson gson;
    private static final String URL = "https://raw.githubusercontent.com/microtavor5/PetInfoPlugin/master/pets.json";

    public PetDataFetcher(OkHttpClient ok, Gson gs) {
        this.okHttpClient = ok;
        this.gson = gs;
    }

    public Map<Integer, Pet> getMap(boolean useRemote) throws IOException {
        Reader reader;
        if (useRemote) {
            try {
                reader = this.getRemoteJson();
            }
            catch (Exception e) {
                log.error("Error with remote Json fetch: ", (Throwable)e);
                log.error("Attempting local Json retrieval");
                reader = new FileReader(PetInfo.localJson);
            }
        } else {
            reader = new FileReader(PetInfo.localJson);
        }
        Map map = (Map)this.gson.fromJson(reader, new TypeToken<Map<Integer, Pet>>(){}.getType());
        return map;
    }

    private Reader getRemoteJson() throws IOException {
        Request request = new Request.Builder().url(URL).build();
        Response response = this.okHttpClient.newCall(request).execute();
        String body = response.body().string();
        if (!response.isSuccessful() || body == null) {
            String errText = "An error occurred fetching remote json from https://raw.githubusercontent.com/microtavor5/PetInfoPlugin/master/pets.json HTTP response: " + response.code();
            response.close();
            throw new IOException(errText);
        }
        int responseCode = this.getRelevantResponseCode(response);
        try {
            this.makeLocalBackup(body, responseCode == 304);
        }
        catch (IOException e) {
            log.error("[PetInfo]\tA local backup was needed but could not be created.");
        }
        response.close();
        return new StringReader(body);
    }

    private int getRelevantResponseCode(Response response) {
        if (response.networkResponse() == null) {
            return response.code();
        }
        return response.networkResponse().code();
    }

    private void makeLocalBackup(String body, boolean wasCashed) throws IOException {
        boolean isFirstLocalSave = this.makeLocalDir();
        boolean fileExists = new File(PetInfo.localJson).exists();
        if (isFirstLocalSave || !fileExists || !wasCashed) {
            FileWriter fr = new FileWriter(PetInfo.localJson);
            fr.write(body);
            fr.close();
        }
    }

    private boolean makeLocalDir() {
        File dir = new File(PetInfo.localDir);
        if (!dir.exists()) {
            return dir.mkdir();
        }
        return false;
    }
}

