/*
 * Decompiled with CFR 0.152.
 */
package com.micro.petinfo;

import com.micro.petinfo.PetInfoPlugin;
import com.micro.petinfo.PetsConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class PetsOverlay
extends Overlay {
    private final Client client;
    private final PetsConfig config;
    private final PetInfoPlugin plugin;

    @Inject
    private PetsOverlay(Client client, PetsConfig config, PetInfoPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.config = config;
        this.client = client;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        List<NPC> pets = this.plugin.getPets();
        if (this.config.highlight() == PetsConfig.HighlightMode.OFF || pets.isEmpty()) {
            return null;
        }
        if (this.config.highlight() == PetsConfig.HighlightMode.ALL) {
            pets.forEach(pet -> this.drawPet(graphics, (NPC)pet));
        }
        if (this.config.highlight() == PetsConfig.HighlightMode.OWN) {
            Player localPlayer = this.client.getLocalPlayer();
            pets.forEach(pet -> {
                if (pet.getInteracting() == localPlayer) {
                    this.drawPet(graphics, (NPC)pet);
                }
            });
        }
        return null;
    }

    private void drawPet(Graphics2D graphics, NPC pet) {
        Object petName = pet.getName();
        if (this.config.getShowNpcId()) {
            petName = (String)petName + " - (id: " + pet.getId() + ")";
        }
        Color color = this.plugin.npcToColor(pet);
        if (this.plugin.showNpc(pet) == PetsConfig.PetMode.HIGHLIGHT && color != null) {
            this.drawHighlightedPet(graphics, (Actor)pet, (String)petName, color);
        } else if (this.plugin.showNpc(pet) == PetsConfig.PetMode.NAME_ONLY && color != null) {
            this.drawOnlyNamePet(graphics, (Actor)pet, (String)petName, color);
        }
    }

    private void drawHighlightedPet(Graphics2D graphics, Actor actor, String text, Color color) {
        Point textLocation;
        Polygon poly = actor.getCanvasTilePoly();
        if (poly != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
        }
        if ((textLocation = actor.getCanvasTextLocation(graphics, text, actor.getLogicalHeight())) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)text, (Color)color);
        }
    }

    private void drawOnlyNamePet(Graphics2D graphics, Actor actor, String text, Color color) {
        Point textLocation = actor.getCanvasTextLocation(graphics, text, actor.getLogicalHeight());
        if (textLocation != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)text, (Color)color);
        }
    }
}

