/*
 * Decompiled with CFR 0.152.
 */
package com.micro.petinfo;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="pets")
public interface PetsConfig
extends Config {
    @ConfigSection(name="Pet group highlight settings", description="Choose how and what color pet groups (i.e. bossing, skilling) should be highlighted.", position=99)
    public static final String highlightSection = "section";

    @ConfigItem(position=1, keyName="menu", name="Right click menu", description="Show option on right click")
    default public MenuMode menu() {
        return MenuMode.BOTH;
    }

    @ConfigItem(position=2, keyName="showPetOwner", name="Show pet's owner name", description="Show pet's owner name on right click")
    default public boolean showPetOwner() {
        return true;
    }

    @ConfigItem(position=3, keyName="togglePetInfoColor", name="Pet name color", description="Choose between the RuneScape default yellow and the custom highlight colors for the pets name")
    default public PetInfoColor petInfoColor() {
        return PetInfoColor.YELLOW;
    }

    @ConfigItem(position=4, keyName="togglePetOwnerColor", name="Pet's owner name color", description="Choose between the RuneScape default yellow, white, or the combat level differential")
    default public PetOwnerColor petOwnerColor() {
        return PetOwnerColor.WHITE;
    }

    @ConfigItem(position=5, keyName="getRemoteData", name="Get up-to-date list of pets", description="Use the updated list of pets from the github. If off, and no local backup found, the plugin will not work. A local backup will be created on first download of an updated version.")
    default public boolean getRemoteData() {
        return true;
    }

    @ConfigItem(position=6, keyName="maxPets", name="Max Pets (for better FPS)", description="Limits the number of pets to add menus to. Fewer pets = more fps, but fewer menus.")
    default public int getMaxPets() {
        return 45;
    }

    @ConfigItem(position=7, keyName="toggleHighlight", name="Highlight toggle", description="Select if no, all, or only your own pets are highlighted", section="section")
    default public HighlightMode highlight() {
        return HighlightMode.OFF;
    }

    @ConfigItem(position=8, keyName="showBoss", name="Highlight Bossing Pets", description="Toggles highlighting for bossing pets", section="section")
    default public PetMode showBoss() {
        return PetMode.HIGHLIGHT;
    }

    @ConfigItem(position=9, keyName="bossColor", name="Boss Pet color", description="Highlight color for boss pets", section="section")
    default public Color getBossColor() {
        return new Color(193, 18, 18);
    }

    @ConfigItem(position=10, keyName="showSkilling", name="Highlight Skilling Pets", description="Toggles highlighting for skilling pets", section="section")
    default public PetMode showSkilling() {
        return PetMode.HIGHLIGHT;
    }

    @ConfigItem(position=11, keyName="skillingColor", name="Skilling Pet color", description="Highlight color for skilling pets", section="section")
    default public Color getSkillingColor() {
        return new Color(106, 232, 38);
    }

    @ConfigItem(position=12, keyName="showToy", name="Highlight Toys", description="Toggles highlighting for clockwork toys", section="section")
    default public PetMode showToy() {
        return PetMode.OFF;
    }

    @ConfigItem(position=13, keyName="toyColor", name="Toy color", description="Highlight color for clockwork toys", section="section")
    default public Color getToyColor() {
        return new Color(139, 120, 69);
    }

    @ConfigItem(position=14, keyName="showOther", name="Show Other Pets", description="Toggles highlighting for other pets (like cats)", section="section")
    default public PetMode showOther() {
        return PetMode.NAME_ONLY;
    }

    @ConfigItem(position=15, keyName="otherColor", name="Other Pet color", description="Highlight color for other pets", section="section")
    default public Color getOtherColor() {
        return new Color(18, 47, 193);
    }

    @ConfigItem(position=16, keyName="showNpcId", name="Show NPC ID", description="Show the pets NPC id next to its overhead name", section="section")
    default public boolean getShowNpcId() {
        return false;
    }

    public static enum HighlightMode {
        OFF,
        ALL,
        OWN;

    }

    public static enum PetOwnerColor {
        WHITE,
        YELLOW,
        COMBAT;

    }

    public static enum PetInfoColor {
        HIGHLIGHT,
        YELLOW;

    }

    public static enum PetMode {
        OFF,
        HIGHLIGHT,
        NAME_ONLY;

    }

    public static enum MenuMode {
        OFF,
        INFO,
        EXAMINE,
        BOTH;

    }
}

