/*
 * Decompiled with CFR 0.152.
 */
package com.micro.petinfo;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.micro.petinfo.PetsConfig;
import com.micro.petinfo.PetsOverlay;
import com.micro.petinfo.dataretrieval.Pet;
import com.micro.petinfo.dataretrieval.PetDataFetcher;
import com.micro.petinfo.dataretrieval.PetInfo;
import java.awt.Color;
import java.awt.Shape;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Pet Info", description="Highlights other players pets,shows the pets name and gives info about the pets.", tags={"pet"})
public class PetInfoPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PetInfoPlugin.class);
    private final List<NPC> pets = new ArrayList<NPC>();
    private final Color defaultWhite = new Color(0xFFFFFF);
    private final Color defaultYellow = new Color(0xFFFF00);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PetsOverlay overlay;
    @Inject
    private PetsConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    private PetInfo petInfo;
    private final String MENU_OPTION_INFO = "Info";
    private final String MENU_OPTION_EXAMINE = "Examine";

    @Provides
    PetsConfig getConfig(ConfigManager configManager) {
        return (PetsConfig)configManager.getConfig(PetsConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        try {
            this.petInfo = new PetInfo(new PetDataFetcher(this.okHttpClient, this.gson), this.config.getRemoteData());
        }
        catch (IOException e) {
            log.error("[Pet-Info]\tCould not load pet data... Shutting plugin down...");
            this.shutDown();
        }
    }

    protected void shutDown() {
        this.pets.clear();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        Pet pet = this.petInfo.findPet(npc.getId());
        if (pet != null) {
            this.pets.add(npc);
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcCompositionChanged) {
        NPC npc = npcCompositionChanged.getNpc();
        Pet pet = this.petInfo.findPet(npc.getId());
        if (pet != null && !this.pets.contains(npc)) {
            this.pets.add(npc);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.pets.clear();
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        if (this.pets.isEmpty()) {
            return;
        }
        NPC npc = npcDespawned.getNpc();
        this.pets.remove(npc);
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.config.menu() == PetsConfig.MenuMode.OFF || this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        this.addMenus();
    }

    public void onMenuOptionClicked(MenuEntry event) {
        if (event.getType() != MenuAction.RUNELITE) {
            log.error("[Pet-Info]\tSomehow got an incorrect menu entry?", (Object)event);
            return;
        }
        if (this.config.menu() == PetsConfig.MenuMode.INFO && !event.getOption().startsWith("Info")) {
            log.error("[Pet-Info]\tSomehow got an incorrect menu entry?", (Object)event);
            return;
        }
        if (this.config.menu() == PetsConfig.MenuMode.EXAMINE && !event.getOption().startsWith("Examine")) {
            log.error("[Pet-Info]\tSomehow got an incorrect menu entry?", (Object)event);
            return;
        }
        if (this.config.menu() == PetsConfig.MenuMode.BOTH && !event.getOption().startsWith("Info") && !event.getOption().startsWith("Examine")) {
            log.error("[Pet-Info]\tSomehow got an incorrect menu entry?", (Object)event);
            return;
        }
        if (this.config.menu() == PetsConfig.MenuMode.INFO) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "The " + event.getTarget() + " " + this.petInfo.getInfo(event.getIdentifier()), "");
        } else if (this.config.menu() == PetsConfig.MenuMode.EXAMINE) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.petInfo.getExamine(event.getIdentifier()), "");
        } else if (this.config.menu() == PetsConfig.MenuMode.BOTH) {
            if (event.getOption().startsWith("Info")) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "The " + event.getTarget() + " " + this.petInfo.getInfo(event.getIdentifier()), "");
            } else {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.petInfo.getExamine(event.getIdentifier()), "");
            }
        }
    }

    PetsConfig.PetMode showNpc(NPC npc) {
        Pet pet = this.petInfo.findPet(npc.getId());
        if (pet == null) {
            return PetsConfig.PetMode.OFF;
        }
        switch (pet.petGroup) {
            case BOSS: {
                return this.config.showBoss();
            }
            case SKILLING: {
                return this.config.showSkilling();
            }
            case TOY: {
                return this.config.showToy();
            }
            case OTHER: {
                return this.config.showOther();
            }
        }
        return PetsConfig.PetMode.OFF;
    }

    Color npcToColor(NPC npc) {
        Pet pet = this.petInfo.findPet(npc.getId());
        if (pet == null) {
            return null;
        }
        switch (pet.petGroup) {
            case BOSS: {
                return this.config.getBossColor();
            }
            case SKILLING: {
                return this.config.getSkillingColor();
            }
            case TOY: {
                return this.config.getToyColor();
            }
            case OTHER: {
                return this.config.getOtherColor();
            }
        }
        return null;
    }

    private List<NPC> getPetsUnderCursor() {
        Point mouseCanvasPosition = this.client.getMouseCanvasPosition();
        if (!this.mouseIsBlocked()) {
            int maxPets = Math.min(this.pets.size(), this.config.getMaxPets());
            ArrayList<NPC> list = new ArrayList<NPC>();
            for (int i = 0; i < maxPets; ++i) {
                if (!this.isClickable(this.pets.get(i), mouseCanvasPosition)) continue;
                list.add(this.pets.get(i));
            }
            return list;
        }
        return Collections.emptyList();
    }

    private boolean mouseIsBlocked() {
        ArrayList<MenuEntry> list = new ArrayList<MenuEntry>();
        for (MenuEntry menuEntry : this.client.getMenuEntries()) {
            if (menuEntry.getType() != MenuAction.WALK) continue;
            list.add(menuEntry);
        }
        return list.isEmpty();
    }

    private boolean isClickable(NPC npc, Point mouseCanvasPosition) {
        Shape npcHull = npc.getConvexHull();
        if (npcHull != null) {
            return npcHull.contains(mouseCanvasPosition.getX(), mouseCanvasPosition.getY());
        }
        return false;
    }

    private void addMenus() {
        List<NPC> petsUnderCursor = this.getPetsUnderCursor();
        if (!petsUnderCursor.isEmpty()) {
            for (NPC pet : petsUnderCursor) {
                if (this.config.menu().equals((Object)PetsConfig.MenuMode.INFO) || this.config.menu().equals((Object)PetsConfig.MenuMode.BOTH)) {
                    this.addPetMenu(pet, "Info");
                }
                if (!this.config.menu().equals((Object)PetsConfig.MenuMode.EXAMINE) && !this.config.menu().equals((Object)PetsConfig.MenuMode.BOTH)) continue;
                if (pet.getInteracting() == this.client.getLocalPlayer()) {
                    return;
                }
                this.addPetMenu(pet, "Examine");
            }
        }
    }

    private void addPetMenu(NPC pet, String option) {
        if (pet.getInteracting() != null && this.config.showPetOwner()) {
            option = (String)option + " " + this.colorOwnerName(pet.getInteracting()) + "'s";
        }
        this.client.createMenuEntry(0).setOption((String)option).setTarget(this.colorPetName(pet)).setType(MenuAction.RUNELITE).setIdentifier(pet.getId()).onClick(this::onMenuOptionClicked);
    }

    private String colorOwnerName(Actor owner) {
        Color ownerColor;
        switch (this.config.petOwnerColor()) {
            case WHITE: {
                ownerColor = this.defaultWhite;
                break;
            }
            case YELLOW: {
                ownerColor = this.defaultYellow;
                break;
            }
            case COMBAT: {
                Player player = this.client.getLocalPlayer();
                if (player == null) {
                    ownerColor = this.defaultYellow;
                    log.error("[Pet-Info]\tLocal player was null. Defaulting to yellow menu color.");
                    break;
                }
                ownerColor = this.getNameColorFromCombatLevels(player.getCombatLevel(), owner.getCombatLevel());
                break;
            }
            default: {
                return owner.getName();
            }
        }
        return this.colorChatString(ownerColor, owner.getName());
    }

    private String colorPetName(NPC pet) {
        String petName = pet.getName();
        switch (this.config.petInfoColor()) {
            case HIGHLIGHT: {
                return this.colorChatString(this.npcToColor(pet), petName);
            }
        }
        return this.colorChatString(this.defaultYellow, petName);
    }

    private String colorChatString(Color color, String name) {
        ChatMessageBuilder petNameColored = new ChatMessageBuilder().append(color, name);
        return petNameColored.build();
    }

    private Color getNameColorFromCombatLevels(int localPlayerLevel, int otherPlayerLevel) {
        int delta = localPlayerLevel - otherPlayerLevel;
        if (delta < -9) {
            return new Color(0xFF0000);
        }
        if (delta < -6) {
            return new Color(0xFF3000);
        }
        if (delta < -3) {
            return new Color(0xFF7000);
        }
        if (delta < 0) {
            return new Color(0xFFB000);
        }
        if (delta > 9) {
            return new Color(65280);
        }
        if (delta > 6) {
            return new Color(0x40FF00);
        }
        if (delta > 3) {
            return new Color(0x80FF00);
        }
        if (delta > 0) {
            return new Color(0xC0FF00);
        }
        return new Color(0xFFFF00);
    }

    List<NPC> getPets() {
        return this.pets;
    }

    Color getDefaultWhite() {
        return this.defaultWhite;
    }

    Color getDefaultYellow() {
        return this.defaultYellow;
    }
}

