/*
 * Decompiled with CFR 0.152.
 */
package abex.os.telemenu;

import abex.os.telemenu.Multikeybind;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import net.runelite.client.config.Keybind;
import net.runelite.client.ui.FontManager;

class MultikeybindButton
extends JButton {
    private Multikeybind value;
    private boolean fresh = true;

    public MultikeybindButton(Multikeybind value) {
        this.value = value;
        this.setFont(FontManager.getDefaultFont().deriveFont(12.0f));
        this.update();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                MultikeybindButton.this.value = new Multikeybind(new Keybind[0]);
                MultikeybindButton.this.update();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Multikeybind v = MultikeybindButton.this.value;
                if (MultikeybindButton.this.fresh) {
                    v = new Multikeybind(new Keybind[0]);
                    MultikeybindButton.this.fresh = false;
                }
                Keybind newBind = new Keybind(e);
                if (v.getKeybinds().size() < 1 || newBind.getKeyCode() != 0) {
                    v = v.with(newBind);
                }
                if (v.getKeybinds().size() == 2 && v.getKeybinds().get(0).getKeyCode() == 0) {
                    v = new Multikeybind(v.getKeybinds().get(1));
                }
                MultikeybindButton.this.value = v;
                MultikeybindButton.this.update();
            }
        });
    }

    private void update() {
        this.setText(this.value.toString());
    }

    public void setValue(Multikeybind value) {
        this.value = value;
        this.update();
    }

    public Multikeybind getValue() {
        return this.value;
    }
}

