/*
 * Decompiled with CFR 0.152.
 */
package abex.os.telemenu;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.runelite.client.config.Keybind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Multikeybind {
    private static final Logger log = LoggerFactory.getLogger(Multikeybind.class);
    private final List<Keybind> keybinds;

    public Multikeybind(Keybind ... binds) {
        this.keybinds = ImmutableList.copyOf((Object[])binds);
    }

    private Multikeybind(ImmutableList<Keybind> keybinds) {
        this.keybinds = keybinds;
    }

    @VisibleForTesting
    static int swapNumpadKey(int code) {
        if (code >= 48 && code <= 57) {
            code += 48;
        } else if (code >= 96 && code <= 105) {
            code -= 48;
        }
        return code;
    }

    private static boolean matches(Keybind bind, KeyEvent ev, boolean aliasNumpad) {
        int key2;
        if (bind.matches(ev)) {
            return true;
        }
        if (aliasNumpad && (key2 = Multikeybind.swapNumpadKey(bind.getKeyCode())) != bind.getKeyCode()) {
            return new Keybind(key2, bind.getModifiers()).matches(ev);
        }
        return false;
    }

    public MatchState matches(List<KeyEvent> evs) {
        return this.matches(evs, false);
    }

    public MatchState matches(List<KeyEvent> evs, boolean aliasNumpad) {
        block0: for (int ii = 0; ii < evs.size(); ++ii) {
            int ei = ii;
            int ki = 0;
            while (true) {
                if (ei >= evs.size()) {
                    if (ki >= this.keybinds.size()) {
                        return MatchState.YES;
                    }
                    return MatchState.PARTIAL;
                }
                if (ki >= this.keybinds.size()) {
                    while (ei < evs.size() && Multikeybind.isModifierOnly(evs.get(ei).getKeyCode())) {
                        ++ei;
                    }
                    continue block0;
                }
                KeyEvent ev = evs.get(ei);
                if (!Multikeybind.matches(this.keybinds.get(ki), ev, aliasNumpad)) {
                    if (!Multikeybind.isModifierOnly(ev.getKeyCode()) || ei == ii) continue block0;
                    --ki;
                }
                ++ki;
                ++ei;
            }
        }
        return MatchState.NO;
    }

    public static boolean isModifierOnly(int keyCode) {
        return keyCode == 0 || Keybind.getModifierForKeyCode((int)keyCode) != null;
    }

    public String toConfig() {
        return this.keybinds.stream().map(k -> k.getKeyCode() + ":" + k.getModifiers()).collect(Collectors.joining(":"));
    }

    public static Multikeybind fromConfig(String config) {
        ImmutableList.Builder v = ImmutableList.builder();
        if (config == null) {
            return null;
        }
        if (!config.isEmpty()) {
            try {
                Iterator bits = Splitter.on((char)':').split((CharSequence)config).iterator();
                while (bits.hasNext()) {
                    int code = Integer.parseInt((String)bits.next());
                    int mods = Integer.parseInt((String)bits.next());
                    if (code == 0 && mods == 0) continue;
                    v.add((Object)new Keybind(code, mods));
                }
            }
            catch (Exception e) {
                log.warn("Malformed Multikeybind", (Throwable)e);
            }
        }
        return new Multikeybind((ImmutableList<Keybind>)v.build());
    }

    public boolean isUnset() {
        return this.keybinds.size() == 0;
    }

    public String toString() {
        if (this.keybinds.size() == 0) {
            return "Not set";
        }
        return this.keybinds.stream().map(Keybind::toString).collect(Collectors.joining(" "));
    }

    public Multikeybind with(Keybind ... more) {
        return new Multikeybind((ImmutableList<Keybind>)ImmutableList.builder().addAll(this.keybinds).add((Object[])more).build());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Multikeybind)) {
            return false;
        }
        Multikeybind other = (Multikeybind)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Keybind> this$keybinds = this.getKeybinds();
        List<Keybind> other$keybinds = other.getKeybinds();
        return !(this$keybinds == null ? other$keybinds != null : !((Object)this$keybinds).equals(other$keybinds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Multikeybind;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Keybind> $keybinds = this.getKeybinds();
        result = result * 59 + ($keybinds == null ? 43 : ((Object)$keybinds).hashCode());
        return result;
    }

    public List<Keybind> getKeybinds() {
        return this.keybinds;
    }

    static enum MatchState {
        NO,
        PARTIAL,
        YES;

    }
}

