/*
 * Decompiled with CFR 0.152.
 */
package abex.os.telemenu;

import abex.os.telemenu.BetterTeleportMenuConfig;
import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.WeakHashMap;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.api.Rasterizer;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class MenuBackgroundOverlay
extends Overlay {
    private static final int IF_MENU = 187;
    private final Client client;
    private final ClientThread clientThread;
    private final BetterTeleportMenuConfig config;
    private boolean drawBackground;
    private WeakHashMap<Widget, Integer> defaultHeight = new WeakHashMap();
    private boolean hasPatched = false;

    @Inject
    public MenuBackgroundOverlay(Client client, ClientThread clientThread, BetterTeleportMenuConfig config) {
        this.client = client;
        this.clientThread = clientThread;
        this.config = config;
        this.drawAfterLayer(187, 0);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.MANUAL);
    }

    public void resize() {
        this.drawBackground = this.resize0();
    }

    private boolean resize0() {
        Widget bgContainer = this.client.getWidget(187, 0);
        if (bgContainer == null || !this.config.expandScrollMenu()) {
            return false;
        }
        Widget parent = bgContainer.getParent();
        Widget model = bgContainer.getChild(0);
        Widget scrollbar = this.client.getWidget(187, 2);
        Widget contents = this.client.getWidget(187, 3);
        if (parent == null || model == null || scrollbar == null || contents == null) {
            return false;
        }
        int contentHeight = this.defaultHeight(contents);
        int boundHeight = this.defaultHeight(bgContainer);
        int enlarge = Math.max(0, contents.getScrollHeight() - contentHeight);
        if ((enlarge = Math.min(enlarge, parent.getParent().getHeight() - boundHeight)) == 0) {
            return this.hasPatched;
        }
        this.hasPatched = true;
        int scrollY = contents.getScrollY();
        this.patchHeight(bgContainer, enlarge);
        this.patchHeight(parent, enlarge);
        this.patchHeight(scrollbar, enlarge);
        this.patchHeight(contents, enlarge);
        scrollbar.revalidateScroll();
        model.setHidden(true);
        boolean needScroll = contents.getHeight() < contents.getScrollHeight();
        scrollbar.setHidden(!needScroll);
        if (needScroll) {
            this.clientThread.invokeLater(() -> this.client.runScript(new Object[]{72, scrollbar.getId(), contents.getId(), scrollY}));
        }
        return true;
    }

    private int defaultHeight(Widget w) {
        return this.defaultHeight.computeIfAbsent(w, Widget::getOriginalHeight);
    }

    private void patchHeight(Widget w, int delta) {
        w.setOriginalHeight(this.defaultHeight(w) + delta);
        w.revalidate();
    }

    public Dimension render(Graphics2D g) {
        if (!this.drawBackground) {
            return null;
        }
        Widget container = this.client.getWidget(187, 0);
        Widget content = this.client.getWidget(187, 3);
        if (container == null || content == null || container.getChild(1) == null) {
            this.drawBackground = false;
            return null;
        }
        Widget text = container.getChild(1);
        ModelData md = this.client.loadModelData(26397);
        if (md == null) {
            return null;
        }
        Model m = md.cloneVertices().light();
        int[] vy = m.getVerticesZ();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int y : vy) {
            min = Math.min(min, y);
            max = Math.max(max, y);
        }
        int totalHeight = max - min;
        int hiEdge = max - 312 * totalHeight / 334;
        int loEdge = max - (90 + totalHeight / 334);
        int adj = (hiEdge + loEdge) / 2;
        for (int i = 0; i < vy.length; ++i) {
            int y = vy[i];
            int y2 = Math.min(Math.max(y, hiEdge), loEdge) - adj;
            vy[i] = y = y - y2 + y2 * content.getHeight() / 232;
        }
        m.calculateBoundsCylinder();
        Rectangle bounds = container.getBounds();
        Rasterizer r = this.client.getRasterizer();
        r.setDrawRegion(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
        r.resetRasterClipping();
        m.drawFrustum(0, 0, 0, 512, -1, 952, -68);
        Rectangle textBounds = text.getBounds();
        text.getFont().drawWidgetText(text.getText(), textBounds.x, textBounds.y, textBounds.width, textBounds.height, text.getTextColor(), text.getTextShadowed() ? 0 : -1, 255, text.getXTextAlignment(), text.getYTextAlignment(), text.getLineHeight());
        return null;
    }
}

