/*
 * Decompiled with CFR 0.152.
 */
package abex.os.telemenu;

import abex.os.telemenu.BetterTeleportMenuConfig;
import abex.os.telemenu.HotkeyDialog;
import abex.os.telemenu.MenuBackgroundOverlay;
import abex.os.telemenu.Multikeybind;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.inject.Provides;
import java.applet.Applet;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PostStructComposition;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.Keybind;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Better Teleport Menu", description="Customize hotkeys for the Spirit Tree/Jewelery box/Portal nexus layout/Diary/Construction cape interfaces", tags={"poh,jewelery,cape,diary,tele,port,nexus,hotkey,keybind,disable,strikethrough"})
public class BetterTeleportMenuPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(BetterTeleportMenuPlugin.class);
    private static final int PARAMID_TELENEXUS_DESTINATION_NAME = 660;
    private static final char CHAR_UNSET = '\u0000';
    @VisibleForTesting
    static final Pattern KEY_PREFIX_MATCHER = Pattern.compile("^(?:(<[^>]+>)([A-Za-z0-9])(:</[^>]+> |</[^>]+> *: +))?(.*?)((?:\\([^)]+\\))?)$");
    private static final Map<Integer, String> ALTERNATE_NEXUS_NAMES = ImmutableMap.builder().put((Object)459, (Object)"Digsite").put((Object)460, (Object)"Ape Atoll").put((Object)461, (Object)"Canifis").put((Object)466, (Object)"Demonic Ruins").put((Object)469, (Object)"Frozen Waste Plateau").put((Object)470, (Object)"Graveyard of Shadows").build();
    private static Map<String, String> canonicalNames = new HashMap<String, String>();
    private static Multimap<String, String> migrateNames = HashMultimap.create();
    @Inject
    private Client client;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private BetterTeleportMenuConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MenuBackgroundOverlay menuBackgroundOverlay;
    private List<KeyEvent> recentKeypresses = new ArrayList<KeyEvent>();
    private List<TeleMenu> teleMenus = new ArrayList<TeleMenu>();
    private int timeout = 0;
    private boolean menuJustOpened = false;
    private String activeMenu = null;

    @Subscribe
    private void onGameTick(GameTick t) {
        ArrayList<TeleMenu> change = null;
        for (TeleMenu menu : this.teleMenus) {
            if (this.client.getWidget(menu.textWidget.getId() >> 16, 0) != null) continue;
            if (change == null) {
                change = new ArrayList<TeleMenu>(this.teleMenus);
            }
            change.remove(menu);
        }
        if (change != null) {
            this.teleMenus = change;
        }
    }

    @Subscribe
    private void onBeforeRender(BeforeRender ev) {
    }

    @Subscribe
    private void onScriptPreFired(ScriptPreFired ev) {
        switch (ev.getScriptId()) {
            case 219: {
                String title = this.client.getStringStack()[this.client.getStringStackSize() - 1];
                this.activeMenu = BetterTeleportMenuPlugin.cleanify(title);
                this.teleMenus = new ArrayList<TeleMenu>();
                break;
            }
        }
    }

    @Subscribe
    private void onPostStructComposition(PostStructComposition ev) {
        String newName = ALTERNATE_NEXUS_NAMES.get(ev.getStructComposition().getId());
        if (newName != null && this.config.alternateNames()) {
            String oldName = ev.getStructComposition().getStringValue(660);
            String cleanOld = "telenexus-" + BetterTeleportMenuPlugin.cleanify(oldName);
            String cleanNew = "telenexus-" + BetterTeleportMenuPlugin.cleanify(newName);
            canonicalNames.put(cleanNew + "-", cleanOld);
            migrateNames.put((Object)cleanOld, (Object)cleanNew);
            ev.getStructComposition().setValue(660, newName + " (" + oldName + ")");
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged ev) {
        if (!"betterteleportmenu".equals(ev.getGroup())) {
            return;
        }
        if ("alternateNames".equals(ev.getKey())) {
            this.clientThread.invoke(() -> this.client.getStructCompositionCache().reset());
        }
    }

    @Subscribe
    private void onScriptPostFired(ScriptPostFired ev) {
        switch (ev.getScriptId()) {
            case 217: 
            case 909: {
                this.menuBackgroundOverlay.resize();
                break;
            }
            case 218: {
                if (this.activeMenu == null) break;
                new TeleMenu().textWidget(this.client.getScriptActiveWidget()).resumeWidget(this.client.getScriptActiveWidget()).opWidget(this.client.getScriptActiveWidget()).keyListenerWidget(this.client.getScriptDotWidget()).identifier(this.activeMenu).disable(() -> {
                    Widget textWidget = this.client.getScriptActiveWidget();
                    textWidget.setHidden(true);
                    int[] nArray = this.client.getIntStack();
                    int n = this.client.getIntStackSize() - 1;
                    nArray[n] = nArray[n] - textWidget.getOriginalHeight();
                }).build();
                break;
            }
            case 2675: {
                new TeleMenu().textWidget(this.client.getScriptActiveWidget()).resumeWidget(this.client.getScriptDotWidget()).opWidget(this.client.getWidget(this.client.getScriptActiveWidget().getId() + 1).getChild(this.client.getScriptActiveWidget().getIndex())).keyListenerWidget(this.client.getScriptDotWidget()).identifier("telenexus").build();
                break;
            }
            case 1688: {
                new TeleMenu().textWidget(this.client.getScriptActiveWidget()).resumeWidget(this.client.getScriptDotWidget()).opWidget(this.client.getScriptActiveWidget()).keyListenerWidget(this.client.getScriptDotWidget()).identifier("jewelbox").build();
            }
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked ev) {
        if (ev.getMenuAction() == MenuAction.CC_OP_LOW_PRIORITY && ev.getId() == 9) {
            for (TeleMenu menu : this.teleMenus) {
                if (menu.opWidget.getId() != ev.getParam1() || menu.opWidget.getIndex() != ev.getParam0()) continue;
                menu.openSetDialog();
                ev.consume();
                return;
            }
        }
    }

    public void resetConfiguration() {
        for (String key : this.configManager.getConfigurationKeys("betterteleportmenu.keybind.")) {
            int firstDot = key.indexOf(46);
            if (firstDot == -1) continue;
            this.configManager.unsetConfiguration("betterteleportmenu", key.substring(firstDot + 1));
        }
    }

    private void resume(Widget w) {
        assert (w.getId() == w.getParentId());
        this.client.runScript(new Object[]{1437, w.getId(), w.getIndex()});
    }

    private static String cleanify(String in) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if ((c = Character.toLowerCase(c)) >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            if (c != '-' && c != ' ') continue;
            sb.append('-');
        }
        return sb.toString();
    }

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this);
        this.overlayManager.add((Overlay)this.menuBackgroundOverlay);
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this);
        this.clientThread.invokeLater(() -> this.client.getStructCompositionCache().reset());
        this.overlayManager.remove((Overlay)this.menuBackgroundOverlay);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.teleMenus.isEmpty()) {
            return;
        }
        if (this.menuJustOpened) {
            this.menuJustOpened = false;
            this.recentKeypresses.clear();
        }
        this.recentKeypresses.add(keyEvent);
        while (this.recentKeypresses.size() > 8) {
            this.recentKeypresses.remove(0);
        }
        for (TeleMenu menu : this.teleMenus) {
            Multikeybind.MatchState match = menu.matches(this.recentKeypresses);
            if (match != Multikeybind.MatchState.NO) {
                keyEvent.consume();
                if (match == Multikeybind.MatchState.YES) {
                    this.clientThread.invokeLater(() -> menu.onTrigger());
                    return;
                }
            }
            if (menu.highlight == (match == Multikeybind.MatchState.PARTIAL)) continue;
            menu.highlight = match == Multikeybind.MatchState.PARTIAL;
            menu.hotkeyChanged();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    @Provides
    BetterTeleportMenuConfig provideConfig(ConfigManager configManager) {
        return (BetterTeleportMenuConfig)configManager.getConfig(BetterTeleportMenuConfig.class);
    }

    static {
        migrateNames.put((Object)"telenexus-carralanger", (Object)"telenexus-carralangar");
    }

    class TeleMenu {
        Widget textWidget;
        Widget resumeWidget;
        Widget opWidget;
        Widget keyListenerWidget;
        String identifier = "";
        String highlightTag = "<shad=ffffff>";
        Runnable disable;
        String displayText;
        char defaultBind;
        String preText;
        String postText;
        boolean highlight;
        boolean disabled;
        Multikeybind bind;

        public void build() {
            Matcher m;
            if (!this.identifier.isEmpty()) {
                this.identifier = this.identifier + "-";
            }
            if (!(m = KEY_PREFIX_MATCHER.matcher(this.textWidget.getText())).find()) {
                log.warn("bad msg \"{}\"", (Object)this.textWidget.getText());
                return;
            }
            this.preText = m.group(1);
            if (this.preText == null) {
                this.preText = "<col=735a28>";
            }
            this.defaultBind = m.group(2) == null ? (char)'\u0000' : Character.toUpperCase(m.group(2).charAt(0));
            this.postText = m.group(3);
            if (this.postText == null) {
                this.postText = "</col>: ";
            }
            this.displayText = m.group(4) + m.group(5);
            this.identifier = this.identifier + BetterTeleportMenuPlugin.cleanify(m.group(4));
            this.identifier = canonicalNames.getOrDefault(this.identifier, this.identifier);
            String strConfigValue = null;
            for (String ident : migrateNames.get((Object)this.identifier)) {
                String v;
                if (ident.equals(this.identifier) || (v = BetterTeleportMenuPlugin.this.configManager.getConfiguration("betterteleportmenu", "keybind." + ident)) == null) continue;
                strConfigValue = v;
                BetterTeleportMenuPlugin.this.configManager.unsetConfiguration("betterteleportmenu", "keybind." + ident);
            }
            String v = BetterTeleportMenuPlugin.this.configManager.getConfiguration("betterteleportmenu", "keybind." + this.identifier);
            if (v != null) {
                strConfigValue = v;
            } else if (strConfigValue != null) {
                BetterTeleportMenuPlugin.this.configManager.setConfiguration("betterteleportmenu", "keybind." + this.identifier, strConfigValue);
            }
            this.bind = Multikeybind.fromConfig(strConfigValue);
            if (this.bind == null) {
                this.bind = this.defaultMultiBind();
            }
            boolean bl = this.disabled = this.disable != null && BetterTeleportMenuPlugin.this.config.hideDisabled() && this.displayText.startsWith("<str>");
            if (this.disabled) {
                this.disable.run();
            }
            this.clearKeyListener();
            this.hotkeyChanged();
            if (this.opWidget.getOnOpListener() == null) {
                this.opWidget.setOnOpListener(new Object[]{10003});
            }
            ArrayList<TeleMenu> change = new ArrayList<TeleMenu>(BetterTeleportMenuPlugin.this.teleMenus);
            change.add(this);
            change.sort(Comparator.comparing(tm -> tm.bind.getKeybinds().size()).reversed());
            BetterTeleportMenuPlugin.this.teleMenus = change;
            BetterTeleportMenuPlugin.this.menuJustOpened = true;
        }

        Multikeybind defaultMultiBind() {
            if (this.defaultBind == '\u0000') {
                return new Multikeybind(new Keybind[0]);
            }
            return new Multikeybind(new Keybind((int)this.defaultBind, 0));
        }

        void hotkeyChanged() {
            this.opWidget.setAction(8, "Set Hotkey (" + this.bind + ")");
            if (this.bind.isUnset()) {
                this.textWidget.setText(this.displayText);
            } else {
                String preHighlight = this.highlight ? this.highlightTag : "";
                this.textWidget.setText(this.preText + this.bind + this.postText + preHighlight + this.displayText);
            }
        }

        void openSetDialog() {
            SwingUtilities.invokeLater(() -> {
                Window window = null;
                for (Container c = (Applet)BetterTeleportMenuPlugin.this.client; c != null; c = c.getParent()) {
                    if (!(c instanceof Window)) continue;
                    window = (Window)c;
                    break;
                }
                new HotkeyDialog(window, this.displayText, this.defaultMultiBind(), this.bind, bind -> {
                    this.bind = bind;
                    BetterTeleportMenuPlugin.this.configManager.setConfiguration("betterteleportmenu", "keybind." + this.identifier, bind.toConfig());
                    BetterTeleportMenuPlugin.this.clientThread.invokeLater(() -> this.hotkeyChanged());
                });
            });
        }

        void clearKeyListener() {
            this.keyListenerWidget.setOnKeyListener((Object[])null);
        }

        void onTrigger() {
            if (this.disabled || BetterTeleportMenuPlugin.this.timeout >= BetterTeleportMenuPlugin.this.client.getGameCycle()) {
                return;
            }
            BetterTeleportMenuPlugin.this.resume(this.resumeWidget);
            this.textWidget.setText("Please wait...");
            BetterTeleportMenuPlugin.this.timeout = BetterTeleportMenuPlugin.this.client.getGameCycle() + 20;
        }

        Multikeybind.MatchState matches(List<KeyEvent> keyEvent) {
            if (this.bind == null) {
                return Multikeybind.MatchState.NO;
            }
            return this.bind.matches(keyEvent, BetterTeleportMenuPlugin.this.config.aliasNumpad());
        }

        public TeleMenu textWidget(Widget textWidget) {
            this.textWidget = textWidget;
            return this;
        }

        public TeleMenu resumeWidget(Widget resumeWidget) {
            this.resumeWidget = resumeWidget;
            return this;
        }

        public TeleMenu opWidget(Widget opWidget) {
            this.opWidget = opWidget;
            return this;
        }

        public TeleMenu keyListenerWidget(Widget keyListenerWidget) {
            this.keyListenerWidget = keyListenerWidget;
            return this;
        }

        public TeleMenu identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public TeleMenu highlightTag(String highlightTag) {
            this.highlightTag = highlightTag;
            return this;
        }

        public TeleMenu disable(Runnable disable) {
            this.disable = disable;
            return this;
        }
    }
}

