/*
 * Decompiled with CFR 0.152.
 */
package trevor.chatboxopacity;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import trevor.chatboxopacity.ChatboxOpacityConfig;

@PluginDescriptor(name="Chatbox Opacity", description="Change the opacity on your transparent chatboxes")
public class ChatboxOpacityPlugin
extends Plugin {
    private static final int BUILD_CHATBOX_SCRIPT = 923;
    private static final int CHATBOX_GROUP = 162;
    private static final int CHATBOX_BUTTON_BACKGROUND = 3;
    private static final int ORIGINAL_BUTTON_BACKGROUND_TYPE = 5;
    private static final int NEW_BUTTON_BACKGROUND_TYPE = 3;
    @Inject
    private Client client;
    @Inject
    private ChatboxOpacityConfig config;
    @Inject
    private ClientThread clientThread;
    private int chatboxButtonBackgroundSprite = -1;
    private int previousChatboxOpacity = -1;

    @Provides
    ChatboxOpacityConfig provideConfig(ConfigManager configManager) {
        return (ChatboxOpacityConfig)configManager.getConfig(ChatboxOpacityConfig.class);
    }

    protected void startUp() throws Exception {
        this.clientThread.invoke(() -> this.writeChatboxOpacity());
    }

    protected void shutDown() throws Exception {
        this.clientThread.invoke(() -> {
            Widget widget;
            if (this.chatboxButtonBackgroundSprite != -1 && (widget = this.client.getWidget(162, 3)) != null) {
                widget.setSpriteId(this.chatboxButtonBackgroundSprite);
                widget.setFilled(false);
                widget.setType(5);
                this.chatboxButtonBackgroundSprite = -1;
            }
            this.client.runScript(new Object[]{923});
        });
    }

    @Subscribe
    private void onScriptPostFired(ScriptPostFired ev) {
        if (ev.getScriptId() != 923) {
            return;
        }
        this.writeChatboxOpacity();
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("chatboxopacity")) {
            this.clientThread.invokeLater(() -> this.writeChatboxOpacity());
        }
    }

    private void writeChatboxOpacity() {
        if (this.client.getGameState() != GameState.LOGGED_IN || !this.client.isResized() || this.client.getVar(4608) == 0) {
            return;
        }
        Widget widget = this.client.getWidget(WidgetInfo.CHATBOX_MESSAGES);
        if (widget == null || widget.isHidden()) {
            return;
        }
        widget = this.client.getWidget(WidgetInfo.CHATBOX_TRANSPARENT_BACKGROUND);
        Widget[] children = widget.getChildren();
        if (children.length == 20) {
            if (this.config.chatboxOpacity() != -1) {
                for (Widget child : children) {
                    child.setOpacity(this.config.chatboxOpacity());
                    this.previousChatboxOpacity = this.config.chatboxOpacity();
                }
            } else if (this.previousChatboxOpacity != -1) {
                this.previousChatboxOpacity = -1;
                this.client.runScript(new Object[]{923});
            }
        }
        if (this.config.buttonOpacity() != -1) {
            widget = this.client.getWidget(162, 3);
            if (widget != null) {
                if (this.chatboxButtonBackgroundSprite == -1) {
                    this.chatboxButtonBackgroundSprite = widget.getSpriteId();
                    widget.setSpriteId(-1);
                    widget.setType(3);
                    widget.setFilled(true);
                }
                widget.setOpacity(this.config.buttonOpacity());
            }
        } else if (this.chatboxButtonBackgroundSprite != -1 && (widget = this.client.getWidget(162, 3)) != null) {
            widget.setSpriteId(this.chatboxButtonBackgroundSprite);
            widget.setFilled(false);
            widget.setType(5);
            this.chatboxButtonBackgroundSprite = -1;
            this.client.runScript(new Object[]{923});
        }
    }
}

