/*
 * Decompiled with CFR 0.152.
 */
package com.bram91.brushmarkers;

import com.bram91.brushmarkers.BrushMarkerConfig;
import com.bram91.brushmarkers.BrushMarkerMinimapOverlay;
import com.bram91.brushmarkers.BrushMarkerOverlay;
import com.bram91.brushmarkers.BrushMarkerPoint;
import com.bram91.brushmarkers.BrushMarkerWorldmapOverlay;
import com.bram91.brushmarkers.BrushMemento;
import com.bram91.brushmarkers.ColorTileMarker;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Brush Markers", description="Enable marking of tiles using the Shift key", tags={"overlay", "tiles", "paint"})
public class BrushMarkerPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(BrushMarkerPlugin.class);
    private static final String CONFIG_GROUP = "brushMarkers";
    private static final String REGION_PREFIX = "region_";
    private static final Gson GSON = new Gson();
    private final List<ColorTileMarker> points = new ArrayList<ColorTileMarker>();
    @Inject
    private Client client;
    @Inject
    private BrushMarkerConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BrushMarkerOverlay overlay;
    @Inject
    private BrushMarkerMinimapOverlay minimapOverlay;
    @Inject
    private BrushMarkerWorldmapOverlay worldmapOverlay;
    @Inject
    private KeyManager keyManager;
    private boolean ctrlHeld;
    private boolean shiftHeld;
    private int currentColor = 0;
    private Stack<BrushMemento> undoStack;
    private Stack<BrushMemento> redoStack;
    private Color pickedColor;

    private void savePoints(int regionId, Collection<BrushMarkerPoint> points) {
        if (points == null || points.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
            return;
        }
        String json = GSON.toJson(points);
        this.configManager.setConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId, json);
    }

    private Collection<BrushMarkerPoint> getPoints(int regionId) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
        if (Strings.isNullOrEmpty((String)json)) {
            return Collections.emptyList();
        }
        return (Collection)GSON.fromJson(json, new TypeToken<List<BrushMarkerPoint>>(){}.getType());
    }

    public Collection<BrushMarkerPoint> getWorldPoints(int regionId) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
        if (Strings.isNullOrEmpty((String)json)) {
            return Collections.emptyList();
        }
        return (Collection)GSON.fromJson(json, new TypeToken<List<BrushMarkerPoint>>(){}.getType());
    }

    @Provides
    BrushMarkerConfig provideConfig(ConfigManager configManager) {
        return (BrushMarkerConfig)configManager.getConfig(BrushMarkerConfig.class);
    }

    private void loadPoints() {
        this.points.clear();
        int[] regions = this.client.getMapRegions();
        if (regions == null) {
            return;
        }
        for (int regionId : regions) {
            log.debug("Loading points for region {}", (Object)regionId);
            Collection<BrushMarkerPoint> regionPoints = this.getPoints(regionId);
            Collection<ColorTileMarker> colorTileMarkers = this.translateToColorTileMarker(regionPoints);
            this.points.addAll(colorTileMarkers);
        }
    }

    private Collection<ColorTileMarker> translateToColorTileMarker(Collection<BrushMarkerPoint> points) {
        if (points.isEmpty()) {
            return Collections.emptyList();
        }
        return points.stream().map(point -> new ColorTileMarker(WorldPoint.fromRegion((int)point.getRegionId(), (int)point.getRegionX(), (int)point.getRegionY(), (int)point.getZ()), point.getColor())).flatMap(colorTile -> {
            Collection localWorldPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)colorTile.getWorldPoint());
            return localWorldPoints.stream().map(wp -> new ColorTileMarker((WorldPoint)wp, colorTile.getColor()));
        }).collect(Collectors.toList());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.loadPoints();
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.overlayManager.add((Overlay)this.worldmapOverlay);
        this.keyManager.registerKeyListener((KeyListener)this);
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.loadPoints();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.overlayManager.remove((Overlay)this.worldmapOverlay);
        this.keyManager.unregisterKeyListener((KeyListener)this);
        this.points.clear();
    }

    public void keyPressed(KeyEvent e) {
        if (!this.config.paintMode()) {
            return;
        }
        if (e.getKeyCode() == 9) {
            this.currentColor = this.config.doubleColors() ? (this.currentColor >= 11 ? 0 : ++this.currentColor) : (this.currentColor >= 5 ? 0 : ++this.currentColor);
            e.consume();
        }
        if (e.getKeyCode() == 192) {
            this.currentColor = this.config.doubleColors() ? (this.currentColor <= 0 ? 11 : --this.currentColor) : (this.currentColor <= 0 ? 5 : --this.currentColor);
        } else if (e.getKeyCode() == 17) {
            this.ctrlHeld = true;
        } else if (e.getKeyCode() == 16) {
            this.shiftHeld = true;
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.ctrlHeld = false;
        } else if (e.getKeyCode() == 16) {
            this.shiftHeld = false;
        } else if (this.config.paintMode() && e.getKeyCode() == 90) {
            this.undo();
        } else if (this.config.paintMode() && e.getKeyCode() == 88) {
            this.redo();
        } else if (this.config.paintMode() && e.getKeyCode() == 81) {
            this.pickColor();
        }
    }

    private void pickColor() {
        BrushMarkerPoint point;
        WorldPoint worldPoint;
        int regionId;
        ArrayList<BrushMarkerPoint> brushMarkerPoints;
        if (this.client.getSelectedSceneTile() != null && (brushMarkerPoints = new ArrayList<BrushMarkerPoint>(this.getPoints(regionId = (worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getSelectedSceneTile().getLocalLocation())).getRegionID()))).contains(point = new BrushMarkerPoint(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), this.client.getPlane(), this.getColor()))) {
            for (BrushMarkerPoint markerPoint : brushMarkerPoints) {
                if (markerPoint.getRegionY() != point.getRegionY() || markerPoint.getRegionX() != point.getRegionX()) continue;
                this.pickedColor = markerPoint.getColor();
                this.currentColor = 12;
                break;
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    @Subscribe
    public void onClientTick(ClientTick tick) {
        if (this.config.paintMode() && this.client.getSelectedSceneTile() != null) {
            WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getSelectedSceneTile().getLocalLocation());
            int regionId = worldPoint.getRegionID();
            BrushMarkerPoint point = new BrushMarkerPoint(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), this.client.getPlane(), this.getColor());
            ArrayList<BrushMarkerPoint> brushMarkerPoints = new ArrayList<BrushMarkerPoint>(this.getPoints(regionId));
            if (this.shiftHeld) {
                for (BrushMarkerPoint brushMarkerPoint : this.getSelectedTiles(point)) {
                    if (brushMarkerPoint.getRegionX() < 0 || brushMarkerPoint.getRegionX() >= 64 || brushMarkerPoint.getRegionY() < 0 || brushMarkerPoint.getRegionY() >= 64) continue;
                    this.redoStack.clear();
                    if (this.config.replaceMode() && brushMarkerPoints.contains(brushMarkerPoint)) {
                        for (BrushMarkerPoint markerPoint : brushMarkerPoints) {
                            if (markerPoint.getRegionY() != brushMarkerPoint.getRegionY() || markerPoint.getRegionX() != brushMarkerPoint.getRegionX()) continue;
                            if (this.undoStack.size() != 0 && this.undoStack.peek().getPoint().equals(markerPoint)) break;
                            this.undoStack.push(new BrushMemento(markerPoint, false));
                            break;
                        }
                    }
                    if (this.undoStack.size() == 0 || !this.undoStack.peek().getPoint().equals(brushMarkerPoint)) {
                        this.undoStack.push(new BrushMemento(brushMarkerPoint, true));
                    }
                    if (this.config.replaceMode()) {
                        brushMarkerPoints.remove(brushMarkerPoint);
                        brushMarkerPoints.add(brushMarkerPoint);
                        continue;
                    }
                    if (brushMarkerPoints.contains(brushMarkerPoint)) continue;
                    brushMarkerPoints.add(brushMarkerPoint);
                }
                this.savePoints(regionId, brushMarkerPoints);
                this.loadPoints();
            } else if (this.ctrlHeld) {
                this.redoStack.clear();
                for (BrushMarkerPoint brushMarkerPoint : this.getSelectedTiles(point)) {
                    if (brushMarkerPoints.contains(brushMarkerPoint)) {
                        for (BrushMarkerPoint markerPoint : brushMarkerPoints) {
                            if (markerPoint.getRegionY() != brushMarkerPoint.getRegionY() || markerPoint.getRegionX() != brushMarkerPoint.getRegionX()) continue;
                            this.undoStack.push(new BrushMemento(markerPoint, false));
                            break;
                        }
                    }
                    if (!brushMarkerPoints.contains(brushMarkerPoint)) continue;
                    brushMarkerPoints.remove(brushMarkerPoint);
                }
                this.savePoints(regionId, brushMarkerPoints);
                this.loadPoints();
            }
        }
    }

    public ArrayList<BrushMarkerPoint> getSelectedTiles(BrushMarkerPoint point) {
        ArrayList<BrushMarkerPoint> points = new ArrayList<BrushMarkerPoint>();
        int size = this.config.brushSize().getSize();
        int offset = size / 2;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                points.add(new BrushMarkerPoint(point.getRegionId(), point.getRegionX() + x - offset, point.getRegionY() + y - offset, point.getZ(), point.getColor()));
            }
        }
        System.out.println(size + "-" + offset);
        return points;
    }

    public void undo() {
        if (this.undoStack.size() == 0) {
            return;
        }
        BrushMemento memento = this.undoStack.pop();
        this.redoStack.push(memento);
        ArrayList<BrushMarkerPoint> brushMarkerPoints = new ArrayList<BrushMarkerPoint>(this.getPoints(memento.getPoint().getRegionId()));
        if (!memento.isDraw()) {
            while (brushMarkerPoints.contains(memento.getPoint())) {
                brushMarkerPoints.remove(memento.getPoint());
            }
            brushMarkerPoints.add(memento.getPoint());
        } else {
            while (brushMarkerPoints.contains(memento.getPoint())) {
                brushMarkerPoints.remove(memento.getPoint());
            }
        }
        this.savePoints(memento.getPoint().getRegionId(), brushMarkerPoints);
        this.loadPoints();
    }

    public void redo() {
        if (this.redoStack.size() == 0) {
            return;
        }
        BrushMemento memento = this.redoStack.pop();
        this.undoStack.push(memento);
        ArrayList<BrushMarkerPoint> brushMarkerPoints = new ArrayList<BrushMarkerPoint>(this.getPoints(memento.getPoint().getRegionId()));
        if (memento.isDraw()) {
            brushMarkerPoints.remove(memento.getPoint());
            brushMarkerPoints.add(memento.getPoint());
        } else {
            brushMarkerPoints.remove(memento.getPoint());
        }
        this.savePoints(memento.getPoint().getRegionId(), brushMarkerPoints);
        this.loadPoints();
    }

    public Color getColor() {
        switch (this.currentColor) {
            case 0: {
                return this.config.markerColor1();
            }
            case 1: {
                return this.config.markerColor2();
            }
            case 2: {
                return this.config.markerColor3();
            }
            case 3: {
                return this.config.markerColor4();
            }
            case 4: {
                return this.config.markerColor5();
            }
            case 6: {
                return this.config.markerColor7();
            }
            case 7: {
                return this.config.markerColor8();
            }
            case 8: {
                return this.config.markerColor9();
            }
            case 9: {
                return this.config.markerColor10();
            }
            case 10: {
                return this.config.markerColor11();
            }
            case 11: {
                return this.config.markerColor12();
            }
            case 12: {
                return this.pickedColor;
            }
        }
        return this.config.markerColor6();
    }

    List<ColorTileMarker> getPoints() {
        return this.points;
    }
}

