/*
 * Decompiled with CFR 0.152.
 */
package com.bram91.brushmarkers;

import com.bram91.brushmarkers.BrushMarkerConfig;
import com.bram91.brushmarkers.BrushMarkerPlugin;
import com.bram91.brushmarkers.ColorTileMarker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class BrushMarkerOverlay
extends Overlay {
    private static final int MAX_DRAW_DISTANCE = 32;
    private final Client client;
    private final BrushMarkerConfig config;
    private final BrushMarkerPlugin plugin;
    @Inject
    ItemManager itemManager;

    @Inject
    private BrushMarkerOverlay(Client client, BrushMarkerConfig config, BrushMarkerPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        List<ColorTileMarker> points = this.plugin.getPoints();
        try {
            Polygon poly;
            for (ColorTileMarker point : points) {
                WorldPoint worldPoint = point.getWorldPoint();
                if (worldPoint.getPlane() != this.client.getPlane()) continue;
                Color tileColor = point.getColor();
                if (tileColor == null) {
                    tileColor = this.plugin.getColor();
                }
                this.drawTile(graphics, worldPoint, tileColor);
            }
            if (this.config.paintMode() && this.client.getSelectedSceneTile() != null && (poly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)this.client.getSelectedSceneTile().getLocalLocation(), (int)this.config.brushSize().getSize())) != null) {
                BufferedImage image = BrushMarkerOverlay.resize((BufferedImage)this.itemManager.getImage(670), poly.getBounds().width, poly.getBounds().height);
                Point imageLoc = Perspective.getCanvasImageLocation((Client)this.client, (LocalPoint)this.client.getSelectedSceneTile().getLocalLocation(), (BufferedImage)image, (int)0);
                OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)imageLoc, (BufferedImage)image);
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)this.plugin.getColor());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return null;
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW / 2, newH / 2, 4);
        BufferedImage dimg = new BufferedImage(newW / 2, newH / 2, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    private void drawTile(Graphics2D graphics, WorldPoint point, Color color) {
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 32) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly == null) {
            return;
        }
        if (this.config.fillPoly()) {
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.config.polyAlpha()));
            graphics.fillPolygon(poly);
        }
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
    }
}

