/*
 * Decompiled with CFR 0.152.
 */
package com.bram91.brushmarkers;

import com.bram91.brushmarkers.BrushMarkerConfig;
import com.bram91.brushmarkers.BrushMarkerPlugin;
import com.bram91.brushmarkers.ColorTileMarker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

class BrushMarkerMinimapOverlay
extends Overlay {
    private static final int MAX_DRAW_DISTANCE = 16;
    private static final int TILE_WIDTH = 4;
    private static final int TILE_HEIGHT = 4;
    private final Client client;
    private final BrushMarkerConfig config;
    private final BrushMarkerPlugin plugin;

    @Inject
    private BrushMarkerMinimapOverlay(Client client, BrushMarkerConfig config, BrushMarkerPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.drawTileOnMinimmap()) {
            return null;
        }
        List<ColorTileMarker> points = this.plugin.getPoints();
        for (ColorTileMarker point : points) {
            WorldPoint worldPoint = point.getWorldPoint();
            if (worldPoint.getPlane() != this.client.getPlane()) continue;
            Color tileColor = point.getColor();
            if (tileColor == null) {
                tileColor = this.plugin.getColor();
            }
            this.drawOnMinimap(graphics, worldPoint, tileColor);
        }
        return null;
    }

    private void drawOnMinimap(Graphics2D graphics, WorldPoint point, Color color) {
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 16) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Point posOnMinimap = Perspective.localToMinimap((Client)this.client, (LocalPoint)lp);
        if (posOnMinimap == null) {
            return;
        }
        OverlayUtil.renderMinimapRect((Client)this.client, (Graphics2D)graphics, (Point)posOnMinimap, (int)3, (int)3, (Color)color);
    }
}

