/*
 * Decompiled with CFR 0.152.
 */
package com.itemreminders;

import com.google.inject.Provides;
import com.itemreminders.ReminderConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ItemReminders")
public class ReminderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ReminderPlugin.class);
    private HashMap<Integer, List<String>> pairsMap = new HashMap();
    int tickDelay;
    @Inject
    private Notifier notifier;
    @Inject
    private Client client;
    @Inject
    private ReminderConfig config;

    protected void startUp() throws Exception {
        this.loadPairs();
        this.tickDelay = 0;
    }

    public boolean isInListedZone() {
        return this.client.getLocalPlayer() != null && this.pairsMap.containsKey(WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID());
    }

    private void loadPairs() {
        this.pairsMap.clear();
        if (!this.config.pairsString().trim().equals("")) {
            int i;
            String[] pairsArray = this.config.pairsString().split(";");
            ArrayList<String> pairs = new ArrayList<String>();
            for (i = 0; i < pairsArray.length; ++i) {
                pairs.add(pairsArray[i]);
            }
            for (i = 0; i < pairs.size(); ++i) {
                ArrayList<String> temp;
                String unbracketedPair = ((String)pairs.get(i)).substring(1, ((String)pairs.get(i)).length() - 1);
                String[] pair = unbracketedPair.split(",");
                int key = Integer.parseInt(pair[0]);
                if (this.pairsMap.containsKey(key)) {
                    temp = new ArrayList<String>();
                    temp.add(pair[1]);
                    temp.addAll((Collection)this.pairsMap.get(key));
                    this.pairsMap.remove(key);
                    this.pairsMap.put(key, temp);
                    continue;
                }
                temp = new ArrayList();
                temp.add(pair[1]);
                this.pairsMap.put(key, temp);
            }
        }
    }

    private void incrementCounter() {
        this.tickDelay = this.tickDelay == this.config.ticksNum() ? 0 : ++this.tickDelay;
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        int currentRegion;
        int debug = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
        System.out.println(debug);
        boolean anyItem = false;
        this.loadPairs();
        if (this.isInListedZone() && null != this.pairsMap.get(currentRegion = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID())) {
            ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
            ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
            for (int i = 0; i < this.pairsMap.get(currentRegion).size(); ++i) {
                if (inventory.contains(Integer.parseInt(this.pairsMap.get(currentRegion).get(i))) || equipment.contains(Integer.parseInt(this.pairsMap.get(currentRegion).get(i)))) continue;
                anyItem = true;
            }
            if (anyItem) {
                if (this.tickDelay == 0) {
                    this.notifier.notify("You are missing an item!");
                    this.incrementCounter();
                } else {
                    this.incrementCounter();
                }
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.tickDelay = 0;
    }

    @Provides
    ReminderConfig provideConfig(ConfigManager configManager) {
        return (ReminderConfig)configManager.getConfig(ReminderConfig.class);
    }
}

