/*
 * Decompiled with CFR 0.152.
 */
package com.herbiafk.QuestHelperTools;

import com.herbiafk.QuestHelperTools.DirectionArrow;
import com.herbiafk.QuestHelperTools.QuestPerspective;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.List;
import javax.annotation.Nonnull;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.OverlayUtil;

public class WorldLines {
    public static void createMinimapLines(Graphics2D graphics, Client client, List<WorldPoint> linePoints, Color color) {
        if (linePoints == null || linePoints.size() < 2) {
            return;
        }
        for (int i = 0; i < linePoints.size() - 1; ++i) {
            LocalPoint startPoint = QuestPerspective.getInstanceLocalPoint(client, linePoints.get(i));
            LocalPoint destinationPoint = QuestPerspective.getInstanceLocalPoint(client, linePoints.get(i + 1));
            if (startPoint == null || destinationPoint == null) continue;
            Point startPosOnMinimap = Perspective.localToMinimap((Client)client, (LocalPoint)startPoint, (int)10000000);
            Point destinationPosOnMinimap = Perspective.localToMinimap((Client)client, (LocalPoint)destinationPoint, (int)10000000);
            if (destinationPosOnMinimap == null || startPosOnMinimap == null) continue;
            Line2D.Double line = new Line2D.Double(startPosOnMinimap.getX(), startPosOnMinimap.getY(), destinationPosOnMinimap.getX(), destinationPosOnMinimap.getY());
            Rectangle bounds = new Rectangle(0, 0, client.getCanvasWidth(), client.getCanvasHeight());
            Widget minimapWidget = client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA);
            if (minimapWidget == null) {
                minimapWidget = client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA);
            }
            if (minimapWidget == null) {
                minimapWidget = client.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
            }
            if (minimapWidget != null) {
                bounds = minimapWidget.getBounds();
            }
            DirectionArrow.drawLine(graphics, line, color, bounds);
        }
    }

    public static Line2D.Double getWorldLines(@Nonnull Client client, @Nonnull LocalPoint startLocation, LocalPoint endLocation) {
        int plane = client.getPlane();
        int startX = startLocation.getX();
        int startY = startLocation.getY();
        int endX = endLocation.getX();
        int endY = endLocation.getY();
        int sceneX = startLocation.getSceneX();
        int sceneY = startLocation.getSceneY();
        if (sceneX < 0 || sceneY < 0 || sceneX >= 104 || sceneY >= 104) {
            return null;
        }
        int startHeight = Perspective.getTileHeight((Client)client, (LocalPoint)startLocation, (int)plane);
        int endHeight = Perspective.getTileHeight((Client)client, (LocalPoint)endLocation, (int)plane);
        Point p1 = Perspective.localToCanvas((Client)client, (int)startX, (int)startY, (int)startHeight);
        Point p2 = Perspective.localToCanvas((Client)client, (int)endX, (int)endY, (int)endHeight);
        if (p1 == null || p2 == null) {
            return null;
        }
        return new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static void drawLinesOnWorld(Graphics2D graphics, Client client, List<WorldPoint> linePoints, Color color) {
        for (int i = 0; i < linePoints.size() - 1; ++i) {
            Line2D.Double newLine;
            LocalPoint startLp = QuestPerspective.getInstanceLocalPoint(client, linePoints.get(i));
            LocalPoint endLp = QuestPerspective.getInstanceLocalPoint(client, linePoints.get(i + 1));
            if (startLp == null || endLp == null || (newLine = WorldLines.getWorldLines(client, startLp, endLp)) == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)newLine, (Color)color);
        }
    }
}

