/*
 * Decompiled with CFR 0.152.
 */
package com.herbiafk.QuestHelperTools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;

public class QuestPerspective {
    public static Collection<WorldPoint> toLocalInstance(Client client, WorldPoint worldPoint) {
        if (!client.isInInstancedRegion()) {
            return Collections.singleton(worldPoint);
        }
        ArrayList<WorldPoint> worldPoints = new ArrayList<WorldPoint>();
        int[][][] instanceTemplateChunks = client.getInstanceTemplateChunks();
        for (int z = 0; z < instanceTemplateChunks.length; ++z) {
            for (int x = 0; x < instanceTemplateChunks[z].length; ++x) {
                for (int y = 0; y < instanceTemplateChunks[z][x].length; ++y) {
                    int chunkData = instanceTemplateChunks[z][x][y];
                    int rotation = chunkData >> 1 & 3;
                    int templateChunkY = (chunkData >> 3 & 0x7FF) * 8;
                    int templateChunkX = (chunkData >> 14 & 0x3FF) * 8;
                    if (worldPoint.getX() < templateChunkX || worldPoint.getX() >= templateChunkX + 8 || worldPoint.getY() < templateChunkY || worldPoint.getY() >= templateChunkY + 8) continue;
                    WorldPoint p = new WorldPoint(client.getBaseX() + x * 8 + (worldPoint.getX() & 7), client.getBaseY() + y * 8 + (worldPoint.getY() & 7), z);
                    if (!(p = QuestPerspective.rotate(p, rotation)).isInScene(client)) continue;
                    worldPoints.add(p);
                }
            }
        }
        return worldPoints;
    }

    private static WorldPoint rotate(WorldPoint point, int rotation) {
        int chunkX = point.getX() & 0xFFFFFFF8;
        int chunkY = point.getY() & 0xFFFFFFF8;
        int x = point.getX() & 7;
        int y = point.getY() & 7;
        switch (rotation) {
            case 1: {
                return new WorldPoint(chunkX + y, chunkY + (7 - x), point.getPlane());
            }
            case 2: {
                return new WorldPoint(chunkX + (7 - x), chunkY + (7 - y), point.getPlane());
            }
            case 3: {
                return new WorldPoint(chunkX + (7 - y), chunkY + x, point.getPlane());
            }
        }
        return point;
    }

    public static LocalPoint getInstanceLocalPoint(Client client, WorldPoint wp) {
        WorldPoint instanceWorldPoint = QuestPerspective.getInstanceWorldPoint(client, wp);
        if (instanceWorldPoint == null) {
            return null;
        }
        return LocalPoint.fromWorld((Client)client, (WorldPoint)instanceWorldPoint);
    }

    public static WorldPoint getInstanceWorldPoint(Client client, WorldPoint wp) {
        Collection<WorldPoint> points = QuestPerspective.toLocalInstance(client, wp);
        for (WorldPoint point : points) {
            if (point == null) continue;
            return point;
        }
        return null;
    }

    public static Point getMinimapPoint(Client client, WorldPoint start, WorldPoint destination) {
        RenderOverview ro = client.getRenderOverview();
        if (ro.getWorldMapData().surfaceContainsPosition(start.getX(), start.getY()) != ro.getWorldMapData().surfaceContainsPosition(destination.getX(), destination.getY())) {
            return null;
        }
        int x = destination.getX() - start.getX();
        int y = destination.getY() - start.getY();
        float maxDistance = Math.max(Math.abs(x), Math.abs(y));
        x *= 100;
        y *= 100;
        x = (int)((float)x / maxDistance);
        y = (int)((float)y / maxDistance);
        Widget minimapDrawWidget = client.isResized() ? (client.getVar(4607) == 1 ? client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA) : client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA)) : client.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
        if (minimapDrawWidget == null) {
            return null;
        }
        int angle = client.getMapAngle() & 0x7FF;
        int sin = Perspective.SINE[angle];
        int cos = Perspective.COSINE[angle];
        int xx = y * sin + cos * x >> 16;
        int yy = sin * x - y * cos >> 16;
        Point loc = minimapDrawWidget.getCanvasLocation();
        int miniMapX = loc.getX() + xx + minimapDrawWidget.getWidth() / 2;
        int miniMapY = minimapDrawWidget.getHeight() / 2 + loc.getY() + yy;
        return new Point(miniMapX, miniMapY);
    }
}

