/*
 * Decompiled with CFR 0.152.
 */
package com.herbiafk;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import com.herbiafk.HerbiAfkConfig;
import com.herbiafk.HerbiAfkMinimapOverlay;
import com.herbiafk.HerbiAfkOverlay;
import com.herbiafk.HerbiboarSearchSpot;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.npcoverlay.HighlightedNpc;
import net.runelite.client.game.npcoverlay.NpcOverlayService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.herbiboars.HerbiboarPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Herbi AFK")
@PluginDependency(value=HerbiboarPlugin.class)
public class HerbiAfkPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HerbiAfkPlugin.class);
    @Inject
    private Client client;
    @Inject
    private HerbiAfkConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private HerbiAfkOverlay overlay;
    @Inject
    private HerbiAfkMinimapOverlay minimapOverlay;
    @Inject
    private HerbiboarPlugin herbiboarPlugin;
    @Inject
    private NpcOverlayService npcOverlayService;
    private List<WorldPoint> pathLinePoints = new ArrayList<WorldPoint>();
    private WorldPoint nextSearchSpot;
    private WorldPoint startLocation;
    private WorldPoint endLocation;
    private static boolean varbitChanged = false;
    private HerbiState herbiState;
    private int finishedId = -1;
    private static final List<WorldPoint> END_LOCATIONS = ImmutableList.of((Object)new WorldPoint(3693, 3798, 0), (Object)new WorldPoint(3702, 3808, 0), (Object)new WorldPoint(3703, 3826, 0), (Object)new WorldPoint(3710, 3881, 0), (Object)new WorldPoint(3700, 3877, 0), (Object)new WorldPoint(3715, 3840, 0), (Object)new WorldPoint(3751, 3849, 0), (Object)new WorldPoint(3685, 3869, 0), (Object)new WorldPoint(3681, 3863, 0));
    private static final List<WorldPoint> START_LOCATIONS = ImmutableList.of((Object)new WorldPoint(3686, 3870, 0), (Object)new WorldPoint(3751, 3850, 0), (Object)new WorldPoint(3695, 3800, 0), (Object)new WorldPoint(3704, 3810, 0), (Object)new WorldPoint(3705, 3830, 0));
    private static final String HERBI_STUN = "You stun the creature";
    private static final String HERBI_KC = "Your herbiboar harvest count is:";
    private static final String HERBIBOAR_NAME = "Herbiboar";
    private static final String HERBI_CIRCLES = "The creature has successfully confused you with its tracks, leading you round in circles";
    private static final Integer PATH_LINE_DIVISION = 10;
    public final Function<NPC, HighlightedNpc> isHerbiboar = n -> {
        boolean isHighlight;
        boolean bl = isHighlight = this.config.highlightHerbiHull() || this.config.highlightHerbiTile() || this.config.highlightHerbiOutline();
        if (isHighlight && n.getName() != null && n.getName().equals(HERBIBOAR_NAME)) {
            Color color = this.config.getHerbiboarColor();
            return HighlightedNpc.builder().npc(n).highlightColor(color).fillColor(ColorUtil.colorWithAlpha((Color)color, (int)(color.getAlpha() / 12))).hull(this.config.highlightHerbiHull()).tile(this.config.highlightHerbiTile()).outline(this.config.highlightHerbiOutline()).build();
        }
        return null;
    };

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.npcOverlayService.registerHighlighter(this.isHerbiboar);
        this.pathLinePoints = new ArrayList<WorldPoint>();
        this.herbiState = HerbiState.IDLE;
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.npcOverlayService.unregisterHighlighter(this.isHerbiboar);
        this.resetTrailData();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case HOPPING: 
            case LOGGING_IN: {
                this.resetTrailData();
                this.herbiState = HerbiState.IDLE;
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        varbitChanged = true;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.isInHerbiboarArea()) {
            this.herbiState = HerbiState.IDLE;
            return;
        }
        switch (this.herbiState) {
            case FINDING_START: {
                if (this.client.getLocalPlayer() != null) {
                    this.startLocation = this.client.getLocalPlayer().getWorldLocation();
                }
                this.endLocation = this.getNearestStartLocation();
                if (this.endLocation != null) {
                    this.updatePathLinePoints(this.startLocation, this.endLocation);
                }
                if (!varbitChanged) break;
                this.updateTrailData();
                varbitChanged = false;
                break;
            }
            case HUNTING: {
                if (varbitChanged) {
                    this.updateTrailData();
                    varbitChanged = false;
                }
                if (!this.config.pathRelativeToPlayer() || this.client.getLocalPlayer() == null || this.pathLinePoints == null) break;
                this.startLocation = this.client.getLocalPlayer().getWorldLocation();
                this.updatePathLinePoints(this.startLocation, this.endLocation);
                break;
            }
            case STUNNED: {
                this.updateTrailData();
                this.npcOverlayService.rebuild();
                break;
            }
            case IDLE: {
                if (!varbitChanged) break;
                this.updateTrailData();
                varbitChanged = false;
            }
        }
    }

    private void updateTrailData() {
        this.updateStartAndEndLocation();
        if (this.startLocation != null && this.endLocation != null) {
            this.updatePathLinePoints(this.startLocation, this.endLocation);
        }
    }

    private void updateStartAndEndLocation() {
        List currentPath = this.herbiboarPlugin.getCurrentPath();
        int currentPathSize = currentPath.size();
        WorldPoint newStartLocation = null;
        WorldPoint newEndLocation = null;
        if (this.herbiState == HerbiState.STUNNED) {
            newStartLocation = END_LOCATIONS.get(this.finishedId - 1);
            NPC herbi = this.getHerbiboarNpc();
            if (herbi != null) {
                newEndLocation = herbi.getWorldLocation();
            }
        } else if (currentPathSize >= 1) {
            if (this.herbiboarPlugin.getFinishId() > 0) {
                newStartLocation = HerbiboarSearchSpot.valueOf(((Enum)currentPath.get(currentPathSize - 1)).toString()).getLocation();
                this.finishedId = this.herbiboarPlugin.getFinishId();
                newEndLocation = END_LOCATIONS.get(this.finishedId - 1);
            } else if (currentPathSize == 1) {
                newStartLocation = this.herbiboarPlugin.getStartPoint();
                newEndLocation = HerbiboarSearchSpot.valueOf(((Enum)currentPath.get(0)).toString()).getLocation();
            } else {
                newStartLocation = HerbiboarSearchSpot.valueOf(((Enum)currentPath.get(currentPathSize - 2)).toString()).getLocation();
                newEndLocation = HerbiboarSearchSpot.valueOf(((Enum)currentPath.get(currentPathSize - 1)).toString()).getLocation();
            }
        }
        if (newStartLocation != null && newEndLocation != null) {
            if (this.config.pathRelativeToPlayer() && this.client.getLocalPlayer() != null) {
                newStartLocation = this.client.getLocalPlayer().getWorldLocation();
            }
            this.nextSearchSpot = newEndLocation;
            this.startLocation = newStartLocation;
            this.endLocation = newEndLocation;
            this.herbiState = HerbiState.HUNTING;
        }
    }

    private WorldPoint getNearestStartLocation() {
        WorldPoint neartestPoint = null;
        WorldPoint player = null;
        if (this.client.getLocalPlayer() != null) {
            player = this.client.getLocalPlayer().getWorldLocation();
        }
        if (player == null) {
            return null;
        }
        double shortestDistance = Double.MAX_VALUE;
        for (WorldPoint startPoint : START_LOCATIONS) {
            double distance = player.distanceTo2D(startPoint);
            if (!(distance < shortestDistance)) continue;
            neartestPoint = startPoint;
            shortestDistance = distance;
        }
        return neartestPoint;
    }

    private void updatePathLinePoints(WorldPoint start, WorldPoint end) {
        double distance = start.distanceTo2D(end);
        int divisions = (int)Math.ceil(distance / (double)PATH_LINE_DIVISION.intValue());
        this.pathLinePoints.clear();
        this.pathLinePoints.add(start);
        if (divisions == 1) {
            this.pathLinePoints.add(end);
            return;
        }
        double angle = Math.atan2(end.getY() - start.getY(), end.getX() - start.getX());
        double deltaH = distance / (double)divisions;
        int deltaX = (int)(deltaH * Math.cos(angle));
        int deltaY = (int)(deltaH * Math.sin(angle));
        int currentX = start.getX();
        int currentY = start.getY();
        for (int i = 1; i < divisions; ++i) {
            this.pathLinePoints.add(new WorldPoint(currentX += deltaX, currentY += deltaY, 0));
        }
        this.pathLinePoints.add(end);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE) {
            String message = Text.sanitize((String)Text.removeTags((String)event.getMessage()));
            if (message.contains(HERBI_STUN)) {
                this.herbiState = HerbiState.STUNNED;
            } else if (message.contains(HERBI_KC) || message.contains(HERBI_CIRCLES)) {
                this.resetTrailData();
            }
        }
    }

    private NPC getHerbiboarNpc() {
        NPC[] cachedNPCs;
        for (NPC npc : cachedNPCs = this.client.getCachedNPCs()) {
            if (npc == null || npc.getName() == null || !npc.getName().equals(HERBIBOAR_NAME)) continue;
            return npc;
        }
        return null;
    }

    private void resetTrailData() {
        this.pathLinePoints.clear();
        this.nextSearchSpot = null;
        this.startLocation = null;
        this.endLocation = null;
        this.finishedId = -1;
        this.herbiState = HerbiState.FINDING_START;
    }

    public boolean isInHerbiboarArea() {
        return this.herbiboarPlugin.isInHerbiboarArea();
    }

    @Provides
    HerbiAfkConfig provideConfig(ConfigManager configManager) {
        return (HerbiAfkConfig)configManager.getConfig(HerbiAfkConfig.class);
    }

    public Client getClient() {
        return this.client;
    }

    public List<WorldPoint> getPathLinePoints() {
        return this.pathLinePoints;
    }

    public WorldPoint getNextSearchSpot() {
        return this.nextSearchSpot;
    }

    private static enum HerbiState {
        IDLE,
        FINDING_START,
        HUNTING,
        STUNNED;

    }
}

