/*
 * Decompiled with CFR 0.152.
 */
package com.herbiafk;

import com.herbiafk.HerbiAfkConfig;
import com.herbiafk.HerbiAfkPlugin;
import com.herbiafk.QuestHelperTools.DirectionArrow;
import com.herbiafk.QuestHelperTools.WorldLines;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class HerbiAfkMinimapOverlay
extends Overlay {
    private final HerbiAfkPlugin plugin;
    private final HerbiAfkConfig config;

    @Inject
    public HerbiAfkMinimapOverlay(HerbiAfkPlugin plugin, HerbiAfkConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInHerbiboarArea()) {
            return null;
        }
        if (this.config.showMiniMapArrow() && this.plugin.getNextSearchSpot() != null) {
            DirectionArrow.renderMinimapArrow(graphics, this.plugin.getClient(), this.plugin.getNextSearchSpot(), this.config.getArrowColor());
        }
        if (this.config.showMiniMaplines() && this.plugin.getPathLinePoints() != null) {
            WorldLines.createMinimapLines(graphics, this.plugin.getClient(), this.plugin.getPathLinePoints(), this.config.getMinimapPathColor());
        }
        return null;
    }
}

