/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets.ui;

import com.pluginpresets.PluginPreset;
import com.pluginpresets.PluginPresetsPlugin;
import com.pluginpresets.PluginPresetsPresetEditor;
import com.pluginpresets.PluginPresetsUtils;
import com.pluginpresets.ui.Icons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.config.Keybind;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.FlatTextField;

class PresetPanel
extends JPanel {
    private static final Border NAME_BOTTOM_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR));
    private final PluginPresetsPlugin plugin;
    private final PluginPreset preset;
    private final JPanel labelWrapper = new JPanel();
    private final JLabel keybindLabel = new JLabel();
    private final JLabel shareLabel = new JLabel();
    private final JLabel editLabel = new JLabel();
    private final JLabel deleteLabel = new JLabel();
    private final JLabel loadLabel = new JLabel();
    private final FlatTextField nameInput = new FlatTextField();
    private final JLabel rename = new JLabel("Rename");
    private final JLabel saveRename = new JLabel("Save");
    private final JLabel cancelRename = new JLabel("Cancel");
    private final JPanel keybindWrapper = new JPanel();
    private final JLabel keybind = new JLabel();
    private final JLabel saveKeybind = new JLabel("Save");
    private final JLabel cancelKeybind = new JLabel("Cancel");
    private final JPanel presetNameContainer = new JPanel();
    private KeyEvent savedKeybind = null;

    PresetPanel(final PluginPreset pluginPreset, PluginPresetsPlugin pluginPresetsPlugin) {
        boolean keybindSet;
        this.plugin = pluginPresetsPlugin;
        this.preset = pluginPreset;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel nameWrapper = new JPanel(new BorderLayout());
        nameWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        nameWrapper.setBorder(NAME_BOTTOM_BORDER);
        JPanel nameActions = new JPanel(new BorderLayout(3, 0));
        nameActions.setBorder(new EmptyBorder(0, 0, 0, 8));
        nameActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PresetPanel.this.editPreset(pluginPreset);
                }
            }
        });
        this.saveRename.setVisible(false);
        this.saveRename.setFont(FontManager.getRunescapeSmallFont());
        this.saveRename.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.saveRename.setToolTipText("Save new name");
        this.saveRename.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    PresetPanel.this.saveRename();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PresetPanel.this.saveRename.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PresetPanel.this.saveRename.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
            }
        });
        this.cancelRename.setVisible(false);
        this.cancelRename.setFont(FontManager.getRunescapeSmallFont());
        this.cancelRename.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.cancelRename.setToolTipText("Cancel rename");
        this.cancelRename.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    PresetPanel.this.cancelRename();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PresetPanel.this.cancelRename.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PresetPanel.this.cancelRename.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            }
        });
        this.rename.setFont(FontManager.getRunescapeSmallFont());
        this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        this.rename.setToolTipText("Rename preset");
        this.rename.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    PresetPanel.this.updateNameActions(true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PresetPanel.this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker().darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PresetPanel.this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            }
        });
        nameActions.add((Component)this.saveRename, "East");
        nameActions.add((Component)this.cancelRename, "West");
        nameActions.add((Component)this.rename, "Center");
        JPanel nameContainer = new JPanel(new FlowLayout(0, 0, 0));
        nameContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameInput.setText(this.preset.getName());
        this.nameInput.setBorder(null);
        this.nameInput.setEditable(false);
        this.nameInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameInput.setPreferredSize(new Dimension(145, 25));
        this.nameInput.setVisible(false);
        this.nameInput.getTextField().setForeground(Color.WHITE);
        this.nameInput.getTextField().setBorder(new EmptyBorder(0, 5, 0, 0));
        this.nameInput.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PresetPanel.this.saveRename();
                } else if (e.getKeyCode() == 27) {
                    PresetPanel.this.cancelRename();
                }
            }
        });
        JLabel nameLabel = new JLabel(this.preset.getName());
        nameLabel.setPreferredSize(new Dimension(170, 15));
        nameLabel.setForeground(Color.WHITE);
        nameLabel.setHorizontalTextPosition(2);
        if (!this.preset.getLocal().booleanValue()) {
            nameLabel.setIcon(Icons.SYNC_CONFIG_ICON);
            nameLabel.setToolTipText("Stored in RuneLite config");
        }
        this.presetNameContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.presetNameContainer.add(nameLabel);
        nameContainer.add((Component)this.nameInput);
        nameContainer.add(this.presetNameContainer);
        nameWrapper.add((Component)nameContainer, "Center");
        nameWrapper.add((Component)nameActions, "East");
        JPanel bottomContainer = new JPanel(new BorderLayout());
        bottomContainer.setBorder(new EmptyBorder(6, 0, 6, 0));
        bottomContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel leftActions = new JPanel(new FlowLayout(0, 3, 3));
        leftActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftActions.setPreferredSize(new Dimension(65, 14));
        this.loadLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.loadLabel.setPreferredSize(new Dimension(25, 14));
        Boolean loadOnFocus = this.preset.getLoadOnFocus();
        boolean autoUpdate = this.plugin.getAutoUpdater() != null && this.plugin.getAutoUpdater().getEditedPreset().getId() == this.preset.getId();
        this.loadLabel.setComponentPopupMenu(this.getLoadLabelPopup());
        JLabel notice = new JLabel();
        boolean emptyPreset = false;
        Boolean match = this.preset.match(this.plugin.getCurrentConfigurations());
        if (match.booleanValue()) {
            this.loadLabel.setIcon(Icons.SWITCH_ON_ICON);
            this.loadLabel.setToolTipText("Current configurations match this preset");
            emptyPreset = this.preset.isEmpty();
            if (emptyPreset) {
                notice.setFont(FontManager.getRunescapeSmallFont());
                notice.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
                notice.setText("Empty preset");
                notice.setBorder(new EmptyBorder(0, 5, 0, 0));
                notice.setToolTipText("This preset has no configurations, click the edit icon to add configurations.");
                leftActions.setVisible(false);
            }
        } else {
            this.loadLabel.setIcon(Icons.SWITCH_OFF_ICON);
            this.loadLabel.setToolTipText("Load this preset");
            this.loadLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        PresetPanel.this.plugin.loadPreset(PresetPanel.this.preset);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    PresetPanel.this.loadLabel.setIcon(Icons.SWITCH_OFF_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    PresetPanel.this.loadLabel.setIcon(Icons.SWITCH_OFF_ICON);
                }
            });
        }
        JLabel focusActionLabel = new JLabel();
        if (loadOnFocus != null && !emptyPreset) {
            String text;
            if (loadOnFocus.booleanValue()) {
                focusActionLabel.setIcon(Icons.FOCUS_ICON);
                text = "This preset gets loaded when client gets focused";
            } else {
                focusActionLabel.setIcon(Icons.UNFOCUS_ICON);
                text = "This preset gets loaded when client gets unfocused";
            }
            focusActionLabel.setToolTipText(text);
        }
        JLabel autoUpdateLabel = new JLabel();
        if (!emptyPreset) {
            if (autoUpdate) {
                autoUpdateLabel.setIcon(Icons.ORANGE_REFRESH_ICON);
                autoUpdateLabel.setToolTipText("Auto updated preset");
            } else if (this.preset.getAutoUpdated() != null) {
                autoUpdateLabel.setIcon(Icons.REFRESH_INACTIVE_ICON);
                Object tooltipText = "Auto updated when loaded.";
                if (match.booleanValue()) {
                    tooltipText = (String)tooltipText + " Click to auto update this preset.";
                    autoUpdateLabel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent mouseEvent) {
                            if (mouseEvent.getButton() == 1) {
                                PresetPanel.this.toggleAutoUpdate();
                            }
                        }
                    });
                }
                autoUpdateLabel.setToolTipText((String)tooltipText);
            }
        }
        leftActions.add(this.loadLabel);
        leftActions.add(autoUpdateLabel);
        leftActions.add(focusActionLabel);
        JPanel rightActions = new JPanel();
        rightActions.setLayout(new FlowLayout(2, 8, 0));
        rightActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.keybindWrapper.setLayout(new FlowLayout(2, 0, 3));
        this.keybindWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.keybindWrapper.setVisible(false);
        JPanel keybindActions = new JPanel();
        keybindActions.setLayout(new BorderLayout(3, 0));
        keybindActions.setBorder(new EmptyBorder(0, 5, 0, 2));
        keybindActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        keybindActions.setAlignmentX(1.0f);
        this.saveKeybind.setFont(FontManager.getRunescapeSmallFont());
        this.saveKeybind.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.saveKeybind.setToolTipText("Save keybind");
        this.saveKeybind.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    PresetPanel.this.saveKeybind();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PresetPanel.this.saveKeybind.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PresetPanel.this.saveKeybind.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
            }
        });
        this.cancelKeybind.setFont(FontManager.getRunescapeSmallFont());
        this.cancelKeybind.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.cancelKeybind.setToolTipText("Cancel keybind");
        this.cancelKeybind.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    PresetPanel.this.cancelKeybind();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PresetPanel.this.cancelKeybind.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PresetPanel.this.cancelKeybind.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            }
        });
        keybindActions.add((Component)this.cancelKeybind, "West");
        keybindActions.add((Component)this.saveKeybind, "East");
        this.keybind.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.keybind.setFont(FontManager.getRunescapeSmallFont());
        int keybindWidth = emptyPreset ? 50 : 60;
        this.keybind.setPreferredSize(new Dimension(keybindWidth, 12));
        this.keybind.setHorizontalAlignment(4);
        boolean bl = keybindSet = this.preset.getKeybind() != null;
        if (keybindSet) {
            String keybindText = this.preset.getKeybind().toString();
            this.keybindLabel.setText(keybindText);
            this.keybindLabel.setToolTipText(keybindText + " (Click to edit)");
            this.keybindLabel.setPreferredSize(new Dimension(keybindWidth, 12));
            this.keybindLabel.setHorizontalAlignment(4);
            this.keybindLabel.setAlignmentX(1.0f);
            this.keybind.setText(keybindText);
            this.keybind.setToolTipText(keybindText + " (Clear with backspace)");
            if (!this.plugin.getLoggedIn().booleanValue()) {
                this.keybindLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
                this.keybindLabel.setToolTipText(keybindText + " (Keybinds are disabled on login screen)");
            }
        } else {
            this.keybindLabel.setText("Not set");
            this.keybindLabel.setToolTipText("Click to bind this preset to a keybind");
            this.keybindLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker().darker());
            this.keybind.setText("No keybind set");
            this.keybind.setToolTipText("Type a keybind you wish to set");
        }
        this.keybindLabel.addMouseListener(new MouseAdapter(){
            private Color foreground;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    PresetPanel.this.editKeybind();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.foreground = PresetPanel.this.keybindLabel.getForeground();
                PresetPanel.this.keybindLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PresetPanel.this.keybindLabel.setForeground(this.foreground);
            }
        });
        this.keybindWrapper.add(this.keybind);
        this.keybindWrapper.add(keybindActions);
        this.shareLabel.setIcon(Icons.DUPLICATE_ICON);
        this.shareLabel.setToolTipText("Duplicate preset");
        this.shareLabel.setComponentPopupMenu(this.getCopyLabelPopup());
        this.shareLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    PresetPanel.this.plugin.duplicatePreset(PresetPanel.this.preset);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PresetPanel.this.shareLabel.setIcon(Icons.DUPLICATE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PresetPanel.this.shareLabel.setIcon(Icons.DUPLICATE_ICON);
            }
        });
        this.deleteLabel.setIcon(Icons.DELETE_ICON);
        this.deleteLabel.setToolTipText("Delete preset");
        this.deleteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int confirm;
                if (mouseEvent.getButton() == 1 && (confirm = JOptionPane.showConfirmDialog(PresetPanel.this, "Are you sure you want to permanently delete this plugin preset?", "Delete preset", 0, 2)) == 0) {
                    PresetPanel.this.plugin.deletePreset(PresetPanel.this.preset);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PresetPanel.this.deleteLabel.setIcon(Icons.DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PresetPanel.this.deleteLabel.setIcon(Icons.DELETE_ICON);
            }
        });
        this.editLabel.setIcon(Icons.EDIT_ICON);
        this.editLabel.setToolTipText("Edit preset configurations");
        this.editLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    PresetPanel.this.editPreset(PresetPanel.this.preset);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PresetPanel.this.editLabel.setIcon(Icons.EDIT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PresetPanel.this.editLabel.setIcon(Icons.EDIT_ICON);
            }
        });
        this.labelWrapper.setLayout(new FlowLayout(2, 8, 0));
        this.labelWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.labelWrapper.add(this.keybindLabel);
        this.labelWrapper.add(this.shareLabel);
        this.labelWrapper.add(this.editLabel);
        this.labelWrapper.add(this.deleteLabel);
        rightActions.add(this.keybindWrapper);
        rightActions.add(this.labelWrapper);
        bottomContainer.add((Component)leftActions, "West");
        bottomContainer.add((Component)notice, "Center");
        bottomContainer.add((Component)rightActions, "East");
        this.add((Component)nameWrapper, "North");
        this.add((Component)bottomContainer, "Center");
    }

    private void saveRename() {
        this.updatePresetName();
        this.nameInput.setEditable(false);
        this.updateNameActions(false);
        this.requestFocusInWindow();
        this.plugin.savePresets();
    }

    private void updatePresetName() {
        boolean validName;
        String nameInputText = this.nameInput.getText();
        boolean empty = nameInputText.isEmpty();
        boolean stringContainsInvalidCharacters = PluginPresetsUtils.stringContainsInvalidCharacters(nameInputText);
        boolean bl = validName = !empty && !stringContainsInvalidCharacters;
        if (validName) {
            this.preset.setName(nameInputText);
        } else if (empty) {
            this.setDefaultPresetName();
        } else {
            this.plugin.setErrorMessage("Rename failed because name input had invalid characters.");
        }
    }

    private void setDefaultPresetName() {
        String defaultPresetName = "Preset";
        this.preset.setName(defaultPresetName);
        this.nameInput.setText(defaultPresetName);
    }

    private void cancelRename() {
        this.nameInput.setEditable(false);
        this.nameInput.setText(this.preset.getName());
        this.updateNameActions(false);
        this.requestFocusInWindow();
    }

    private void updateNameActions(boolean saveAndCancel) {
        this.saveRename.setVisible(saveAndCancel);
        this.cancelRename.setVisible(saveAndCancel);
        this.rename.setVisible(!saveAndCancel);
        this.nameInput.setEditable(saveAndCancel);
        this.nameInput.setVisible(saveAndCancel);
        this.presetNameContainer.setVisible(!saveAndCancel);
        if (saveAndCancel) {
            this.nameInput.getTextField().requestFocusInWindow();
            this.nameInput.getTextField().selectAll();
        }
    }

    private void showKeybind(boolean show) {
        this.labelWrapper.setVisible(!show);
        this.keybindWrapper.setVisible(show);
    }

    private void editKeybind() {
        this.showKeybind(true);
        this.keybind.requestFocusInWindow();
        this.keybind.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PresetPanel.this.handleKeybindInput(e);
            }
        });
    }

    private void handleKeybindInput(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 10) {
            this.saveKeybind();
        } else if (keyCode == 27) {
            this.cancelKeybind();
        } else if (keyCode == 8) {
            this.savedKeybind = e;
            this.clearKeybind();
        } else {
            this.savedKeybind = e;
            String keyText = KeyEvent.getKeyText(keyCode);
            String keybindText = keyText.toUpperCase();
            int modifiersEx = e.getModifiersEx();
            if (modifiersEx != 0) {
                String modifiersExText = InputEvent.getModifiersExText(modifiersEx);
                String text = (modifiersExText + "+" + keyText).toUpperCase();
                if (!modifiersExText.equals(keyText)) {
                    keybindText = text;
                }
                this.keybind.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                this.keybind.setToolTipText(keybindText + " (Clear with backspace)");
            } else {
                this.keybind.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
                this.keybind.setToolTipText("Add some modifier to this keybind! This preset could possibly be accidentally enabled e.g. when typing chat messages.");
            }
            if (!this.keybind.getText().equals(keybindText)) {
                this.keybind.setText(keybindText);
            }
        }
    }

    private void saveKeybind() {
        this.showKeybind(false);
        if (this.preset.getKeybind() != null && this.savedKeybind == null) {
            return;
        }
        Keybind presetKeybind = this.savedKeybind == null || this.savedKeybind.getKeyCode() == 8 ? null : new Keybind(this.savedKeybind);
        this.preset.setKeybind(presetKeybind);
        this.plugin.savePresets();
    }

    private void cancelKeybind() {
        this.savedKeybind = null;
        this.showKeybind(false);
    }

    private void clearKeybind() {
        this.keybind.setText("No keybind set");
        this.keybind.setToolTipText("Save to clear keybind");
    }

    private JPopupMenu getCopyLabelPopup() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem duplicatePreset = new JMenuItem();
        duplicatePreset.setText("Duplicate preset");
        duplicatePreset.addActionListener(e -> this.plugin.duplicatePreset(this.preset));
        JMenuItem copyToClipboard = new JMenuItem();
        copyToClipboard.setText("Copy preset to clipboard");
        copyToClipboard.addActionListener(e -> {
            this.plugin.exportPresetToClipboard(this.preset);
            JOptionPane.showMessageDialog(this.shareLabel, "Preset data of '" + this.preset.getName() + "' copied to clipboard.", "Preset exported", 1);
        });
        popupMenu.add(duplicatePreset);
        popupMenu.add(copyToClipboard);
        return popupMenu;
    }

    private JPopupMenu getLoadLabelPopup() {
        JPopupMenu popupMenu = new JPopupMenu();
        Boolean match = this.preset.match(this.plugin.getCurrentConfigurations());
        if (!match.booleanValue()) {
            JMenuItem loadOption = new JMenuItem();
            loadOption.setText("Load preset");
            loadOption.addActionListener(e -> this.plugin.loadPreset(this.preset));
            JMenuItem divider = this.getDivider();
            popupMenu.add(loadOption);
            popupMenu.add(divider);
        }
        JMenuItem toggleAutoUpdate = new JMenuItem();
        toggleAutoUpdate.setText("Toggle auto update");
        toggleAutoUpdate.addActionListener(e -> this.toggleAutoUpdate());
        JMenuItem clearAutoUpdate = new JMenuItem();
        clearAutoUpdate.setText("Clear auto update");
        clearAutoUpdate.addActionListener(e -> this.clearAutoUpdate());
        JMenuItem divider = this.getDivider();
        JMenuItem focusedOption = new JMenuItem();
        focusedOption.setText("Load when focused");
        focusedOption.setToolTipText("Load this preset automatically when client gets focused");
        focusedOption.addActionListener(e -> this.setPresetWindowFocus(true));
        JMenuItem unfocusedOption = new JMenuItem();
        unfocusedOption.setText("Load when unfocused");
        unfocusedOption.setToolTipText("Load this preset automatically when client gets unfocused");
        unfocusedOption.addActionListener(e -> this.setPresetWindowFocus(false));
        JMenuItem clearFocusOption = new JMenuItem();
        clearFocusOption.setText("Clear focus action");
        clearFocusOption.addActionListener(e -> this.setPresetWindowFocus(null));
        popupMenu.setBorder(new EmptyBorder(2, 2, 2, 0));
        popupMenu.add(toggleAutoUpdate);
        popupMenu.add(clearAutoUpdate);
        popupMenu.add(divider);
        popupMenu.add(focusedOption);
        popupMenu.add(unfocusedOption);
        popupMenu.add(clearFocusOption);
        return popupMenu;
    }

    private JMenuItem getDivider() {
        JMenuItem divider = new JMenuItem();
        divider.setBorder(new EmptyBorder(1, 5, 1, 5));
        divider.setPreferredSize(new Dimension(0, 1));
        divider.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
        return divider;
    }

    private void toggleAutoUpdate() {
        if (this.preset.match(this.plugin.getCurrentConfigurations()).booleanValue()) {
            this.plugin.setAutoUpdatedPreset(this.preset.getId());
        } else {
            this.preset.setAutoUpdated(true);
            this.plugin.savePresets();
        }
    }

    private void clearAutoUpdate() {
        boolean thisAutoUpdated;
        boolean bl = thisAutoUpdated = this.plugin.getAutoUpdater() != null && this.plugin.getAutoUpdater().getEditedPreset().getId() == this.preset.getId();
        if (thisAutoUpdated) {
            this.plugin.setAutoUpdatedPreset(null);
        }
        this.plugin.removeAutoUpdateFrom(this.preset);
    }

    private void setPresetWindowFocus(Boolean loadOnFocus) {
        this.preset.setLoadOnFocus(loadOnFocus);
        this.plugin.savePresets();
    }

    public void editPreset(PluginPreset preset) {
        this.plugin.setPresetEditor(new PluginPresetsPresetEditor(this.plugin, preset, this.plugin.getCurrentConfigurations()));
        this.plugin.setFocusChangedPaused(true);
        this.plugin.rebuildPluginUi();
    }
}

