/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets.ui;

import com.pluginpresets.CurrentConfigurations;
import com.pluginpresets.CustomSetting;
import com.pluginpresets.PluginConfig;
import com.pluginpresets.PluginPreset;
import com.pluginpresets.PluginPresetsPlugin;
import com.pluginpresets.PluginPresetsPresetEditor;
import com.pluginpresets.ui.ConfigPanel;
import com.pluginpresets.ui.Icons;
import com.pluginpresets.ui.NoPresetsPanel;
import com.pluginpresets.ui.PresetPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.LinkBrowser;

public class PluginPresetsPluginPanel
extends PluginPanel {
    private final PluginPresetsPlugin plugin;
    private final GridBagConstraints constraints = new GridBagConstraints();
    private final JPanel contentView = new JPanel(new GridBagLayout());
    private final JPanel editPanel = new JPanel(new BorderLayout());
    private final JLabel errorNotification = new JLabel(Icons.NOTIFICATION_ICON);
    private final JLabel helpButton = new JLabel(Icons.HELP_ICON);
    private final JLabel pauseLabel = new JLabel();
    private final JLabel addPreset = new JLabel(Icons.ADD_ICON);
    private final JLabel stopEdit = new JLabel(Icons.ARROW_LEFT_ICON);
    private final JLabel refreshPlugins = new JLabel(Icons.REFRESH_ICON);
    private final JLabel ellipsisMenu = new JLabel(Icons.ELLIPSIS);
    private final JLabel syncLabel = new JLabel();
    private final JLabel updateAll = new JLabel(Icons.REFRESH_ICON);
    private final NoPresetsPanel noPresetsPanel = new NoPresetsPanel();
    private final PluginErrorPanel noContent = new PluginErrorPanel();
    private final JPanel titlePanel = new JPanel(new BorderLayout());
    private final JLabel title = new JLabel();
    private final JLabel editTitle = new JLabel();
    private final IconTextField searchBar = new IconTextField();
    private final String[] filters = new String[]{"All A to Z", "Included", "Not included", "Modified", "Plugin enabled", "Plugin disabled", "Configs match", "Only Plugin Hub"};
    private final List<String> openSettings = new ArrayList<String>();
    private final List<PluginConfig> filtered = new ArrayList<PluginConfig>();
    private final JLabel autoUpdateLabel = new JLabel();
    private final JLabel autoUpdate = new JLabel();
    private String filter = this.filters[0];
    private boolean syncLocal;
    private PluginPreset editedPreset;
    private boolean openPartialConfigs;
    private boolean openAll;
    private MouseAdapter pauseMouseAdapter;
    private MouseAdapter autoUpdateMouseAdapter;

    public PluginPresetsPluginPanel(PluginPresetsPlugin pluginPresetsPlugin) {
        super(false);
        this.plugin = pluginPresetsPlugin;
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(10, 10, 10, 5));
        this.title.setText("Plugin Presets");
        this.title.setForeground(Color.WHITE);
        this.title.setBorder(new EmptyBorder(0, 0, 0, 40));
        JPanel presetActions = new JPanel(new FlowLayout(0, 8, 3));
        this.errorNotification.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.errorNotification.setVisible(false);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.errorNotification.setIcon(Icons.NOTIFICATION_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.errorNotification.setIcon(Icons.NOTIFICATION_ICON);
            }
        });
        this.helpButton.setToolTipText("Open Plugin Presets wiki: https://github.com/antero111/plugin-presets/wiki/General-Features#using-plugin-presets");
        this.helpButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    LinkBrowser.browse((String)"https://github.com/antero111/plugin-presets/wiki/General-Features#using-plugin-presets");
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.helpButton.setIcon(Icons.HELP_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.helpButton.setIcon(Icons.HELP_ICON);
            }
        });
        this.refreshPlugins.setToolTipText("Refresh presets");
        this.refreshPlugins.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    PluginPresetsPluginPanel.this.plugin.refreshPresets();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.refreshPlugins.setIcon(Icons.REFRESH_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.refreshPlugins.setIcon(Icons.REFRESH_ICON);
            }
        });
        this.addPreset.setToolTipText("Create new plugin preset");
        JPopupMenu importPopupMenu = this.getImportMenuPopup();
        this.addPreset.setComponentPopupMenu(importPopupMenu);
        this.addPreset.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 3) {
                    PluginPresetsPluginPanel.this.promptPresetCreation(true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.addPreset.setIcon(Icons.ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.addPreset.setIcon(Icons.ADD_ICON);
            }
        });
        presetActions.add(this.errorNotification);
        presetActions.add(this.pauseLabel);
        presetActions.add(this.helpButton);
        presetActions.add(this.refreshPlugins);
        presetActions.add(this.addPreset);
        this.titlePanel.add((Component)this.title, "West");
        this.titlePanel.add((Component)presetActions, "East");
        this.editTitle.setForeground(Color.WHITE);
        this.stopEdit.setToolTipText("Back to presets");
        this.stopEdit.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.stopEdit.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.stopEdit();
                PluginPresetsPluginPanel.this.emptyBar();
                PluginPresetsPluginPanel.this.rebuild();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.stopEdit.setIcon(Icons.ARROW_LEFT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.stopEdit.setIcon(Icons.ARROW_LEFT_ICON);
            }
        });
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PluginPresetsPluginPanel.this.rebuild();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PluginPresetsPluginPanel.this.rebuild();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PluginPresetsPluginPanel.this.rebuild();
            }
        });
        this.autoUpdateLabel.setText("Auto updated");
        this.autoUpdateLabel.setToolTipText("This preset automatically runs update all after every config change.");
        this.autoUpdateLabel.setVisible(false);
        this.autoUpdateLabel.setFont(FontManager.getRunescapeSmallFont());
        this.autoUpdateLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        this.autoUpdateLabel.setBorder(new EmptyBorder(5, 0, 0, 5));
        this.updateAll.setToolTipText("Update all modified configurations with your current settings.");
        this.updateAll.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.updateAll.setText("Update all");
        this.updateAll.setForeground(Color.WHITE);
        this.updateAll.setVisible(false);
        this.updateAll.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.plugin.getPresetEditor().updateAllModified();
                if (PluginPresetsPluginPanel.this.plugin.getAutoUpdater() == null && PluginPresetsPluginPanel.this.editedPreset.getAutoUpdated() != null) {
                    PluginPresetsPluginPanel.this.plugin.setAutoUpdatedPreset(PluginPresetsPluginPanel.this.plugin.getPresetEditor().getEditedPreset().getId());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.updateAll.setIcon(Icons.REFRESH_HOVER_ICON);
                PluginPresetsPluginPanel.this.updateAll.setForeground(PluginPresetsPluginPanel.this.updateAll.getForeground().darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.updateAll.setIcon(Icons.REFRESH_ICON);
                PluginPresetsPluginPanel.this.updateAll.setForeground(Color.WHITE);
            }
        });
        JPanel editActions = new JPanel();
        editActions.add(this.updateAll);
        editActions.add(this.autoUpdateLabel);
        JPanel filterWrapper = new JPanel();
        filterWrapper.setAlignmentX(0.0f);
        JComboBox<String> filterDropdown = new JComboBox<String>(this.filters);
        filterDropdown.setFocusable(false);
        filterDropdown.setForeground(Color.WHITE);
        filterDropdown.setToolTipText("Filter configuration listing");
        filterDropdown.addActionListener(this::selectFilter);
        filterWrapper.add(filterDropdown);
        JPanel editActionsWrapper = new JPanel(new BorderLayout());
        editActionsWrapper.setBorder(new EmptyBorder(5, 0, 3, 0));
        editActionsWrapper.add((Component)filterWrapper, "West");
        editActionsWrapper.add((Component)editActions, "East");
        JPanel searchWrapper = new JPanel(new BorderLayout());
        searchWrapper.add((Component)this.searchBar, "Center");
        searchWrapper.add((Component)editActionsWrapper, "North");
        JPanel rightActions = new JPanel();
        rightActions.setLayout(new FlowLayout(2, 5, 0));
        this.syncLocal = true;
        this.syncLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    PluginPresetsPluginPanel.this.plugin.getPresetEditor().toggleLocal();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.syncLabel.setIcon(PluginPresetsPluginPanel.this.syncLocal ? Icons.SYNC_LOCAL_HOVER_ICON : Icons.SYNC_CONFIG_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.syncLabel.setIcon(PluginPresetsPluginPanel.this.syncLocal ? Icons.SYNC_LOCAL_ICON : Icons.SYNC_CONFIG_ICON);
            }
        });
        this.ellipsisMenu.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.ellipsisMenu.addMouseListener(new MouseAdapter(){
            private final JPopupMenu popup;
            {
                this.popup = PluginPresetsPluginPanel.this.getEllipsisMenuPopup();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.ellipsisMenu.setIcon(Icons.ELLIPSIS_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.ellipsisMenu.setIcon(Icons.ELLIPSIS);
            }

            private void showPopup(MouseEvent e) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        rightActions.add(this.syncLabel);
        rightActions.add(this.autoUpdate);
        rightActions.add(this.ellipsisMenu);
        this.editPanel.add((Component)this.stopEdit, "West");
        this.editPanel.add((Component)this.editTitle, "Center");
        this.editPanel.add((Component)rightActions, "East");
        this.editPanel.add((Component)searchWrapper, "South");
        this.editPanel.setVisible(false);
        northPanel.add((Component)this.titlePanel, "North");
        northPanel.add((Component)this.editPanel, "Center");
        this.contentView.setBorder(new EmptyBorder(0, 7, 0, 7));
        JPanel contentWrapper = new JPanel(new BorderLayout());
        contentWrapper.add((Component)this.contentView, "North");
        JScrollPane scrollableContainer = new JScrollPane(contentWrapper);
        scrollableContainer.setHorizontalScrollBarPolicy(31);
        this.noPresetsPanel.setVisible(false);
        this.add(northPanel, "North");
        this.add(scrollableContainer, "Center");
    }

    private void selectFilter(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        this.filter = (String)cb.getSelectedItem();
        this.rebuild();
        if (this.filter.equals("Not included")) {
            this.openPartialConfigs();
        }
    }

    public void rebuild() {
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.contentView.removeAll();
        boolean editingPreset = this.plugin.getPresetEditor() != null;
        this.titlePanel.setVisible(!editingPreset);
        this.editPanel.setVisible(editingPreset);
        if (editingPreset) {
            this.renderEditView();
        } else {
            this.renderPresetView();
        }
        this.errorNotification.setVisible(false);
        this.repaint();
        this.revalidate();
    }

    private void renderPresetView() {
        for (PluginPreset preset : this.plugin.getPluginPresets()) {
            this.contentView.add((Component)new PresetPanel(preset, this.plugin), this.constraints);
            ++this.constraints.gridy;
            this.contentView.add(Box.createRigidArea(new Dimension(0, 10)), this.constraints);
            ++this.constraints.gridy;
        }
        boolean empty = this.constraints.gridy == 0;
        this.noPresetsPanel.setVisible(empty);
        this.helpButton.setVisible(!empty);
        this.title.setVisible(!empty);
        this.openSettings.clear();
        if (!empty) {
            boolean showPause = this.showPause();
            this.pauseLabel.setVisible(showPause);
            if (showPause) {
                this.showFocusPause();
            }
        }
        this.contentView.add((Component)this.noPresetsPanel, this.constraints);
        ++this.constraints.gridy;
    }

    private boolean showPause() {
        List<PluginPreset> presets = this.plugin.getPluginPresets();
        for (PluginPreset p : presets) {
            if (p.getLoadOnFocus() == null || p.getPluginConfigs().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void showFocusPause() {
        Boolean paused = this.plugin.getFocusChangedPaused();
        final ImageIcon icon = paused != false ? Icons.PLAY_ICON : Icons.PAUSE_ICON;
        final ImageIcon hoverIcon = paused != false ? Icons.PLAY_HOVER_ICON : Icons.PAUSE_HOVER_ICON;
        this.pauseLabel.setIcon(icon);
        this.pauseLabel.setToolTipText(paused != false ? "Resume" : "Pause focus preset loading");
        this.pauseLabel.removeMouseListener(this.pauseMouseAdapter);
        this.pauseMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Boolean focusChangedPaused = PluginPresetsPluginPanel.this.plugin.getFocusChangedPaused();
                PluginPresetsPluginPanel.this.plugin.setFocusChangedPaused(focusChangedPaused == false);
                PluginPresetsPluginPanel.this.rebuild();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.pauseLabel.setIcon(hoverIcon);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.pauseLabel.setIcon(icon);
            }
        };
        this.pauseLabel.addMouseListener(this.pauseMouseAdapter);
    }

    private void renderEditView() {
        PluginPresetsPresetEditor presetEditor = this.plugin.getPresetEditor();
        this.editedPreset = presetEditor.getEditedPreset();
        this.setLocalIcon(this.editedPreset.getLocal());
        this.editTitle.setText("Editing " + this.editedPreset.getName());
        this.searchBar.requestFocusInWindow();
        CurrentConfigurations currentConfigurations = this.plugin.getCurrentConfigurations();
        List<PluginConfig> configurations = currentConfigurations.getPluginConfigs();
        this.filterCustomConfigs(configurations);
        this.addMissingConfigurations(configurations);
        List keywordFilteredConfigNames = this.filterIfSearchKeyword(configurations).stream().map(PluginConfig::getName).collect(Collectors.toList());
        List<PluginConfig> filteredConfigs = this.filterConfigurations(this.filter, configurations);
        List filterConfigNames = filteredConfigs.stream().map(PluginConfig::getName).collect(Collectors.toList());
        this.plugin.updateCurrentConfigurations();
        if (filteredConfigs.isEmpty() || keywordFilteredConfigNames.isEmpty()) {
            this.noContent.setContent(null, "There is nothing to be shown");
            this.contentView.add((Component)this.noContent);
            ++this.constraints.gridy;
        }
        int notMatchingConfigs = 0;
        for (PluginConfig currentConfig : configurations) {
            PluginConfig presetConfig = this.editedPreset.getConfig(currentConfig);
            if (presetConfig != null && !presetConfig.match(currentConfig).booleanValue()) {
                ++notMatchingConfigs;
            }
            if (!keywordFilteredConfigNames.contains(currentConfig.getName()) || !filterConfigNames.contains(currentConfig.getName())) continue;
            this.contentView.add((Component)new ConfigPanel(currentConfig, presetConfig, this.plugin, this.openSettings), this.constraints);
            ++this.constraints.gridy;
        }
        boolean modified = notMatchingConfigs > 0;
        this.setUpdateAllVisibility(modified);
    }

    private void filterCustomConfigs(List<PluginConfig> configurations) {
        List<CustomSetting> editedPresetCustomSettings = this.plugin.getCustomSettingsManager().getCustomSettingsFor(this.editedPreset.getId());
        List customSettingKeys = editedPresetCustomSettings.stream().map(customSetting -> customSetting.getSetting().getKey()).collect(Collectors.toList());
        configurations.forEach(c -> c.getSettings().removeIf(setting -> setting.getCustomConfigName() != null && !customSettingKeys.contains(setting.getKey())));
    }

    private void addMissingConfigurations(List<PluginConfig> configurations) {
        List names = configurations.stream().map(PluginConfig::getName).collect(Collectors.toList());
        for (PluginConfig config : this.editedPreset.getPluginConfigs()) {
            if (names.contains(config.getName())) continue;
            configurations.add(config);
        }
    }

    private void setLocalIcon(Boolean local) {
        this.syncLocal = local;
        if (local.booleanValue()) {
            this.syncLabel.setIcon(Icons.SYNC_LOCAL_ICON);
            this.syncLabel.setText("Local");
            this.syncLabel.setToolTipText("Stored in presets folder (Click to change)");
        } else {
            this.syncLabel.setIcon(Icons.SYNC_CONFIG_ICON);
            this.syncLabel.setText("Config");
            this.syncLabel.setToolTipText("Stored in RuneLite config (Click to change)");
        }
    }

    private void setUpdateAllVisibility(final boolean modified) {
        boolean hasAutoUpdater = this.plugin.getAutoUpdater() != null;
        final boolean thisHasAutoUpdater = hasAutoUpdater && this.plugin.getAutoUpdater().getEditedPreset().getId() == this.editedPreset.getId();
        final boolean thisAutoUpdated = this.editedPreset.getAutoUpdated() != null;
        String text = "Automatically run update all on this preset";
        if (thisAutoUpdated) {
            if (thisHasAutoUpdater) {
                this.updateAll.setVisible(false);
                this.autoUpdateLabel.setVisible(true);
            } else {
                this.updateAll.setVisible(modified);
                this.autoUpdateLabel.setVisible(false);
            }
            this.autoUpdate.setIcon(Icons.ORANGE_REFRESH_ICON);
            text = "Turn auto updating off from this preset";
        } else {
            this.updateAll.setVisible(modified);
            this.autoUpdateLabel.setVisible(false);
            this.autoUpdate.setIcon(Icons.REFRESH_INACTIVE_ICON);
        }
        this.autoUpdate.setToolTipText(text);
        this.autoUpdate.removeMouseListener(this.autoUpdateMouseAdapter);
        final ImageIcon icon = thisAutoUpdated ? Icons.ORANGE_REFRESH_ICON : Icons.REFRESH_INACTIVE_ICON;
        final ImageIcon hoverIcon = thisAutoUpdated ? Icons.ORANGE_REFRESH_HOVER_ICON : Icons.REFRESH_HOVER_ICON;
        this.autoUpdateMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    if (thisAutoUpdated) {
                        if (thisHasAutoUpdater) {
                            PluginPresetsPluginPanel.this.plugin.setAutoUpdatedPreset(null);
                        }
                        PluginPresetsPluginPanel.this.plugin.removeAutoUpdateFrom(PluginPresetsPluginPanel.this.plugin.getPresetEditor().getEditedPreset());
                    } else if (modified) {
                        PluginPresetsPluginPanel.this.plugin.addAutoUpdateFrom(PluginPresetsPluginPanel.this.plugin.getPresetEditor().getEditedPreset());
                    } else {
                        PluginPresetsPluginPanel.this.plugin.setAutoUpdatedPreset(PluginPresetsPluginPanel.this.plugin.getPresetEditor().getEditedPreset().getId());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.autoUpdate.setIcon(hoverIcon);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PluginPresetsPluginPanel.this.autoUpdate.setIcon(icon);
            }
        };
        this.autoUpdate.addMouseListener(this.autoUpdateMouseAdapter);
    }

    private List<PluginConfig> filterIfSearchKeyword(List<PluginConfig> currentConfigurations) {
        String text = this.searchBar.getText();
        if (!text.isEmpty()) {
            currentConfigurations = currentConfigurations.stream().filter(c -> c.getName().toLowerCase().contains(text.toLowerCase())).collect(Collectors.toList());
        }
        return currentConfigurations;
    }

    private void sortAlphabetically(List<PluginConfig> configurations) {
        configurations.sort(Comparator.comparing(PluginConfig::getConfigName));
    }

    private List<PluginConfig> filterConfigurations(String filter, List<PluginConfig> configurations) {
        if (!this.filtered.isEmpty()) {
            this.filtered.clear();
        }
        this.sortAlphabetically(configurations);
        for (PluginConfig config : configurations) {
            boolean someSettingsUnticked;
            PluginConfig presetConfig = this.editedPreset.getConfig(config);
            boolean bl = someSettingsUnticked = presetConfig != null && presetConfig.getSettings().size() < config.getSettings().size();
            if (filter.equals("All A to Z")) {
                this.filtered.add(config);
            }
            if (filter.equals("Only Plugin Hub") && this.plugin.getPresetManager().isExternalPlugin(config.getName())) {
                this.filtered.add(config);
            } else if (presetConfig == null) {
                if (filter.equals("Not included")) {
                    this.filtered.add(config);
                }
            } else {
                if (filter.equals("Included")) {
                    this.filtered.add(config);
                }
                if (filter.equals("Not included") && someSettingsUnticked) {
                    this.filtered.add(config);
                }
                if (presetConfig.getEnabled() != null) {
                    if (filter.equals("Plugin enabled") && presetConfig.getEnabled().booleanValue()) {
                        this.filtered.add(config);
                    }
                    if (filter.equals("Plugin disabled") && !presetConfig.getEnabled().booleanValue()) {
                        this.filtered.add(config);
                    }
                }
                if (presetConfig.match(config).booleanValue()) {
                    if (filter.equals("Configs match")) {
                        this.filtered.add(config);
                    }
                } else if (filter.equals("Modified")) {
                    this.filtered.add(config);
                }
            }
            if (!this.openPartialConfigs || !someSettingsUnticked) continue;
            this.openSettings.add(config.getName());
        }
        if (this.openAll) {
            this.filtered.forEach(f -> this.openSettings.add(f.getName()));
        }
        return this.filtered;
    }

    private JPopupMenu getEllipsisMenuPopup() {
        JMenuItem enableAllOption = new JMenuItem();
        enableAllOption.setText("Add all");
        enableAllOption.setToolTipText("Adds all visible configurations to edited preset");
        enableAllOption.addActionListener(e -> this.enableAllVisible());
        JMenuItem disableAllOption = new JMenuItem();
        disableAllOption.setText("Remove all");
        disableAllOption.setToolTipText("Removes all visible settings from edited preset.");
        disableAllOption.addActionListener(e -> this.disableAllVisible());
        JMenuItem openAllOption = new JMenuItem();
        openAllOption.setText("Open all");
        openAllOption.setToolTipText("Opens all visible configuration dropdowns.");
        openAllOption.addActionListener(e -> this.openAll());
        JMenuItem openPartialOption = new JMenuItem();
        openPartialOption.setText("Open partial");
        openPartialOption.setToolTipText("Opens all visible configurations that have some settings ticked also unticked.");
        openPartialOption.addActionListener(e -> this.openPartialConfigs());
        JMenuItem collapseAllOption = new JMenuItem();
        collapseAllOption.setText("Close all");
        collapseAllOption.setToolTipText("Closes all open configuration dropdowns.");
        collapseAllOption.addActionListener(e -> this.closeAll());
        JMenuItem divider = new JMenuItem();
        divider.setBorder(new EmptyBorder(1, 5, 1, 5));
        divider.setPreferredSize(new Dimension(0, 1));
        divider.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(2, 2, 2, 0));
        popupMenu.add(enableAllOption);
        popupMenu.add(disableAllOption);
        popupMenu.add(divider);
        popupMenu.add(openAllOption);
        popupMenu.add(openPartialOption);
        popupMenu.add(collapseAllOption);
        return popupMenu;
    }

    private void enableAllVisible() {
        List<PluginConfig> configs = this.filterIfSearchKeyword(this.filtered);
        this.plugin.getPresetEditor().addAll(configs);
    }

    private void disableAllVisible() {
        List<PluginConfig> configs = this.filterIfSearchKeyword(this.filtered);
        this.plugin.getPresetEditor().removeAll(configs);
    }

    private void openAll() {
        this.openAll = true;
        this.rebuild();
        this.openAll = false;
    }

    private void openPartialConfigs() {
        this.openPartialConfigs = true;
        this.rebuild();
        this.openPartialConfigs = false;
    }

    private void closeAll() {
        if (!this.openSettings.isEmpty()) {
            this.openSettings.clear();
            this.rebuild();
        }
    }

    private JPopupMenu getImportMenuPopup() {
        JMenuItem importOption = new JMenuItem();
        importOption.setText("Import preset from clipboard");
        importOption.addActionListener(e -> this.plugin.importPresetFromClipboard());
        JMenuItem createEmptyOption = new JMenuItem();
        createEmptyOption.setText("Create new preset with all settings");
        createEmptyOption.addActionListener(e -> this.promptPresetCreation(false));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(2, 2, 2, 0));
        popupMenu.add(importOption);
        popupMenu.add(createEmptyOption);
        return popupMenu;
    }

    private void promptPresetCreation(boolean empty) {
        String customPresetName = JOptionPane.showInputDialog((Component)((Object)this), "Name your new preset.", "New Plugin Preset", -1);
        if (customPresetName != null) {
            this.plugin.createPreset(customPresetName, empty);
        }
    }

    public void renderNotification(String errorMessage) {
        this.errorNotification.setToolTipText(errorMessage);
        this.errorNotification.setVisible(true);
    }

    private void emptyBar() {
        this.searchBar.setText("");
    }

    private void stopEdit() {
        this.plugin.setPresetEditor(null);
        this.plugin.setFocusChangedPaused(false);
        this.editedPreset = null;
    }
}

