/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets.ui;

import com.pluginpresets.PluginConfig;
import com.pluginpresets.PluginPresetsPlugin;
import com.pluginpresets.PluginPresetsPresetEditor;
import com.pluginpresets.PluginPresetsUtils;
import com.pluginpresets.PluginSetting;
import com.pluginpresets.ui.Icons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class ConfigRow
extends JPanel {
    private final PluginSetting currentSetting;
    private final PluginSetting presetSetting;
    private final JLabel checkboxLabel = new JLabel();
    private final boolean presetHasConfigurations;
    private final PluginPresetsPresetEditor presetEditor;

    public ConfigRow(final PluginConfig currentConfig, final PluginSetting currentSetting, final PluginSetting presetSetting, PluginPresetsPlugin plugin) {
        boolean isCustomSetting;
        this.currentSetting = currentSetting;
        this.presetSetting = presetSetting;
        this.presetEditor = plugin.getPresetEditor();
        this.presetHasConfigurations = this.presetHasConfigurations();
        boolean configsMatch = this.configsMatch();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel title = new JLabel();
        if (currentSetting == null) {
            title.setText(PluginPresetsUtils.splitAndCapitalize(presetSetting.getKey()));
            title.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            title.setToolTipText(presetSetting.getKey());
        } else if (currentSetting.getName().length() == 0) {
            title.setText(PluginPresetsUtils.splitAndCapitalize(currentSetting.getKey()));
            title.setToolTipText(currentSetting.getKey());
        } else {
            title.setText(currentSetting.getName());
            title.setToolTipText(currentSetting.getName() + " - " + currentSetting.getKey());
        }
        title.setPreferredSize(new Dimension(0, 16));
        title.setFont(FontManager.getRunescapeSmallFont());
        if (this.presetHasConfigurations) {
            String customConfigName = presetSetting.getCustomConfigName();
            if (customConfigName != null) {
                this.checkboxLabel.setText("remove");
                this.checkboxLabel.setPreferredSize(new Dimension(38, 16));
                this.checkboxLabel.setFont(FontManager.getRunescapeSmallFont());
                this.checkboxLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                this.checkboxLabel.setToolTipText("Remove custom setting '" + presetSetting.getName() + "' from preset.");
                this.checkboxLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        int confirm = JOptionPane.showConfirmDialog(ConfigRow.this.checkboxLabel, "Are you sure to remove custom setting '" + presetSetting.getName() + "'?", "Remove custom setting", 2, 2);
                        if (confirm == 0) {
                            ConfigRow.this.presetEditor.removeSettingFromEdited(currentConfig, presetSetting);
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        ConfigRow.this.checkboxLabel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        ConfigRow.this.checkboxLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                    }
                });
            } else {
                this.checkboxLabel.setIcon(Icons.CHECKBOX_CHECKED_ICON);
                this.checkboxLabel.setToolTipText("Remove '" + presetSetting.getName() + "' from preset.");
                this.checkboxLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        ConfigRow.this.presetEditor.removeSettingFromEdited(currentConfig, presetSetting);
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        ConfigRow.this.checkboxLabel.setIcon(Icons.CHECKBOX_CHECKED_HOVER_ICON);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        ConfigRow.this.checkboxLabel.setIcon(Icons.CHECKBOX_CHECKED_ICON);
                    }
                });
            }
            if (configsMatch) {
                title.setForeground(Color.LIGHT_GRAY);
            } else {
                title.setForeground(ColorScheme.BRAND_ORANGE);
            }
        } else if (currentSetting == null) {
            this.checkboxLabel.setIcon(Icons.NOTIFICATION_ICON);
            this.checkboxLabel.setToolTipText("Invalid plugin setting configuration (Click to remove)");
            this.checkboxLabel.setBorder(new EmptyBorder(2, 0, 2, 0));
            this.checkboxLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    ConfigRow.this.presetEditor.removeSettingFromEdited(null, presetSetting);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    ConfigRow.this.checkboxLabel.setIcon(Icons.NOTIFICATION_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ConfigRow.this.checkboxLabel.setIcon(Icons.NOTIFICATION_ICON);
                }
            });
        } else {
            title.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
            this.checkboxLabel.setIcon(Icons.CHECKBOX_ICON);
            this.checkboxLabel.setToolTipText("Add '" + currentSetting.getName() + "' to preset.");
            this.checkboxLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    ConfigRow.this.presetEditor.addSettingToEdited(currentConfig, currentSetting);
                }
            });
        }
        JLabel customSettingLabel = new JLabel();
        boolean bl = isCustomSetting = currentSetting != null && currentSetting.getCustomConfigName() != null || presetSetting != null && presetSetting.getCustomConfigName() != null;
        if (isCustomSetting) {
            customSettingLabel.setText("(Custom)");
            customSettingLabel.setFont(FontManager.getRunescapeSmallFont());
            customSettingLabel.setToolTipText("User added custom setting");
            customSettingLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        }
        JPanel rightActions = new JPanel();
        rightActions.setLayout(new FlowLayout(0, 14, 0));
        JLabel updateLabel = new JLabel();
        rightActions.add(updateLabel);
        rightActions.add(this.checkboxLabel);
        JPanel leftActions = new JPanel();
        leftActions.setLayout(new BorderLayout());
        leftActions.add((Component)title, "Center");
        leftActions.add((Component)customSettingLabel, "East");
        this.add((Component)leftActions, "Center");
        this.add((Component)rightActions, "East");
    }

    private boolean presetHasConfigurations() {
        return this.currentSetting != null && this.presetSetting != null;
    }

    private boolean configsMatch() {
        return this.presetHasConfigurations && this.presetSetting.equals(this.currentSetting);
    }
}

