/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets.ui;

import com.pluginpresets.PluginConfig;
import com.pluginpresets.PluginPresetsPlugin;
import com.pluginpresets.PluginPresetsPresetEditor;
import com.pluginpresets.PluginPresetsPresetManager;
import com.pluginpresets.PluginSetting;
import com.pluginpresets.ui.ConfigRow;
import com.pluginpresets.ui.Icons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class ConfigPanel
extends JPanel {
    private final PluginConfig presetConfig;
    private final PluginConfig currentConfig;
    private final PluginPresetsPlugin plugin;
    private final JLabel updateLabel = new JLabel();
    private final JLabel notificationLabel = new JLabel();
    private final boolean presetHasConfigurations;
    private final boolean external;
    private final boolean configsMatch;
    private final JPanel settings = new JPanel(new GridBagLayout());
    private final List<String> openSettings;
    private final boolean settingsVisible;
    private final PluginPresetsPresetManager presetManager;
    private final PluginPresetsPresetEditor presetEditor;

    public ConfigPanel(final PluginConfig currentConfig, final PluginConfig presetConfig, PluginPresetsPlugin plugin, List<String> openSettings) {
        JPopupMenu updateAllPopupMenu;
        this.presetConfig = presetConfig;
        this.currentConfig = currentConfig;
        this.plugin = plugin;
        this.openSettings = openSettings;
        this.presetManager = plugin.getPresetManager();
        this.presetEditor = plugin.getPresetEditor();
        this.presetHasConfigurations = this.presetHasConfigurations();
        this.configsMatch = currentConfig.match(presetConfig);
        this.external = this.isExternalPluginConfig();
        boolean installed = this.isExternalPluginInstalled();
        this.settingsVisible = this.isSettingsVisible();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 3, 0, 0));
        JCheckBox checkbox = new JCheckBox();
        checkbox.setBackground(ColorScheme.LIGHT_GRAY_COLOR);
        final JLabel title = new JLabel();
        final JLabel downArrow = new JLabel();
        title.setText(currentConfig.getName());
        JPopupMenu customSettingPopupMenu = this.getCustomSettingPopupMenu();
        title.setComponentPopupMenu(customSettingPopupMenu);
        title.setPreferredSize(new Dimension(0, 26));
        title.addMouseListener(new MouseAdapter(){
            private Color foreground;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 3) {
                    ConfigPanel.this.toggleSettings();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.foreground = title.getForeground();
                title.setForeground(ColorScheme.BRAND_ORANGE);
                if (!ConfigPanel.this.settingsVisible) {
                    downArrow.setIcon(Icons.ARROW_RIGHT_HOVER_ICON);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                title.setForeground(this.foreground);
                if (!ConfigPanel.this.settingsVisible) {
                    downArrow.setIcon(Icons.ARROW_RIGHT_ICON);
                }
            }
        });
        JLabel externalNotice = new JLabel();
        if (this.external) {
            externalNotice.setText("(E)");
            externalNotice.setToolTipText("Plugin from Plugin Hub");
            externalNotice.setBorder(new EmptyBorder(0, 3, 0, 0));
            externalNotice.setForeground(ColorScheme.BRAND_ORANGE);
        }
        JLabel partialNotice = new JLabel();
        if (this.presetHasConfigurations && this.isPartial()) {
            partialNotice.setText("(P)");
            partialNotice.setToolTipText("Some settings unticked");
            partialNotice.setBorder(new EmptyBorder(0, 3, 0, 0));
            partialNotice.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        }
        JLabel customNotice = new JLabel();
        if (currentConfig.containsCustomSettings()) {
            customNotice.setText("(C)");
            customNotice.setToolTipText("Contains custom settings");
            customNotice.setBorder(new EmptyBorder(0, 3, 0, 0));
            customNotice.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        }
        JLabel statusLabel = new JLabel();
        final JLabel notInstalledLabel = new JLabel();
        if (this.presetHasConfigurations) {
            checkbox.setSelected(true);
            checkbox.setToolTipText("Remove '" + currentConfig.getName() + "' configurations from the preset.");
            updateAllPopupMenu = this.getUpdateAllMenuPopup();
            checkbox.setComponentPopupMenu(updateAllPopupMenu);
            checkbox.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() != 3) {
                        ConfigPanel.this.presetEditor.removeConfigurationFromEdited(presetConfig);
                    }
                }
            });
            if (!this.configsMatch) {
                title.setToolTipText("Your '" + currentConfig.getName() + "' configurations do not match the preset.");
                statusLabel.setText("Modified");
                statusLabel.setForeground(ColorScheme.PROGRESS_INPROGRESS_COLOR);
                statusLabel.setToolTipText("Your '" + currentConfig.getName() + "' configurations do not match the preset.");
                if (this.settingsVisible) {
                    statusLabel.setBorder(new EmptyBorder(5, 0, 0, 0));
                    this.updateLabel.setBorder(new EmptyBorder(4, 0, 0, 5));
                }
                this.updateLabel.setIcon(Icons.UPDATE_ICON);
                this.updateLabel.setToolTipText("Replace presets '" + currentConfig.getName() + "' configurations with your current configuration.");
                this.updateLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        ConfigPanel.this.presetEditor.updateConfigurations(presetConfig, currentConfig);
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        ConfigPanel.this.updateLabel.setIcon(Icons.UPDATE_HOVER_ICON);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        ConfigPanel.this.updateLabel.setIcon(Icons.UPDATE_ICON);
                    }
                });
            } else {
                title.setToolTipText("Your '" + currentConfig.getName() + "' configurations match the preset.");
                title.setForeground(Color.WHITE);
            }
            if (this.external && !installed) {
                title.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
                notInstalledLabel.setIcon(Icons.NOT_INSTALLED_ICON);
                notInstalledLabel.setToolTipText("Plugin not installed, download from Plugin Hub if you want to use these settings or click to remove.");
                notInstalledLabel.setBorder(new EmptyBorder(5, 0, 0, 4));
                notInstalledLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        int confirm = JOptionPane.showConfirmDialog(notInstalledLabel, "Are you sure to remove '" + presetConfig.getName() + "' configurations from the preset.", "Remove configuration", 2, 2);
                        if (confirm == 0) {
                            ConfigPanel.this.presetEditor.removeConfigurationFromEdited(presetConfig);
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        notInstalledLabel.setIcon(Icons.NOT_INSTALLED_HOVER_ICON);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        notInstalledLabel.setIcon(Icons.NOT_INSTALLED_ICON);
                    }
                });
            }
        } else {
            title.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
            title.setToolTipText("This preset does not include any configurations to '" + currentConfig.getName() + "' plugin.");
            checkbox.setSelected(false);
            checkbox.setToolTipText("Add your current '" + currentConfig.getName() + "' configurations to the preset.");
            updateAllPopupMenu = this.getUpdateAllMenuPopup();
            checkbox.setComponentPopupMenu(updateAllPopupMenu);
            checkbox.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() != 3) {
                        ConfigPanel.this.presetEditor.addConfigurationToEdited(currentConfig);
                    }
                }
            });
        }
        this.notificationLabel.setIcon(Icons.NOTIFICATION_ICON);
        this.notificationLabel.setVisible(false);
        downArrow.setIcon(this.settingsVisible ? Icons.ARROW_DOWN_ICON : Icons.ARROW_RIGHT_ICON);
        downArrow.addMouseListener(new MouseAdapter(){
            private Color foreground;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ConfigPanel.this.toggleSettings();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.foreground = title.getForeground();
                title.setForeground(ColorScheme.BRAND_ORANGE);
                if (!ConfigPanel.this.settingsVisible) {
                    downArrow.setIcon(Icons.ARROW_RIGHT_HOVER_ICON);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                title.setForeground(this.foreground);
                if (!ConfigPanel.this.settingsVisible) {
                    downArrow.setIcon(Icons.ARROW_RIGHT_ICON);
                }
            }
        });
        checkbox.setVisible(!this.settingsVisible && (!this.external || installed));
        JPanel leftActions = new JPanel();
        leftActions.setLayout(new BoxLayout(leftActions, 0));
        leftActions.add(downArrow);
        leftActions.add(title);
        leftActions.add(externalNotice);
        leftActions.add(partialNotice);
        leftActions.add(customNotice);
        JPanel rightActions = new JPanel();
        rightActions.setLayout(new FlowLayout(0, 3, 0));
        rightActions.add(statusLabel);
        rightActions.add(notInstalledLabel);
        rightActions.add(this.notificationLabel);
        rightActions.add(this.updateLabel);
        rightActions.add(checkbox);
        JPanel topActions = new JPanel(new BorderLayout());
        topActions.add((Component)leftActions, "Center");
        topActions.add((Component)rightActions, "East");
        if (this.settingsVisible) {
            this.createSettings();
        }
        this.settings.setBorder(new EmptyBorder(0, 5, 3, 0));
        this.settings.setVisible(this.settingsVisible);
        this.add((Component)topActions, "North");
        this.add((Component)this.settings, "Center");
    }

    private void createSettings() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.settings.removeAll();
        this.settings.add((Component)this.getEnabledRow(), constraints);
        ++constraints.gridy;
        List<PluginSetting> presetSettings = this.presetConfig != null ? this.presetConfig.getSettings() : null;
        ArrayList loopedInvalidConfigurations = new ArrayList();
        String configName = this.currentConfig.getConfigName();
        List<String> keys = this.currentConfig.getSettingKeys();
        this.currentConfig.getSettings().forEach(currentSetting -> {
            PluginSetting presetSetting;
            if (this.presetHasConfigurations) {
                assert (this.presetConfig != null);
                presetSetting = this.presetConfig.getSetting((PluginSetting)currentSetting);
            } else {
                presetSetting = null;
            }
            if (presetSettings != null && !loopedInvalidConfigurations.contains(configName)) {
                presetSettings.forEach(setting -> {
                    boolean invalidSetting;
                    boolean bl = invalidSetting = !keys.contains(setting.getKey()) && setting.getCustomConfigName() == null;
                    if (invalidSetting) {
                        this.settings.add((Component)new ConfigRow(null, null, (PluginSetting)setting, this.plugin), constraints);
                        ++constraints.gridy;
                        if (!this.settingsVisible) {
                            this.notificationLabel.setVisible(true);
                            this.notificationLabel.setToolTipText("Preset contains invalid configurations for this plugin");
                        }
                    }
                });
                loopedInvalidConfigurations.add(configName);
            }
            this.settings.add((Component)new ConfigRow(this.currentConfig, (PluginSetting)currentSetting, presetSetting, this.plugin), constraints);
            ++constraints.gridy;
        });
    }

    private JPanel getEnabledRow() {
        JPanel enabledRow = new JPanel(new BorderLayout());
        JLabel title = new JLabel();
        title.setText("Plugin on/off");
        title.setToolTipText("Whether the plugin is disabled or not.");
        title.setPreferredSize(new Dimension(0, 16));
        title.setFont(FontManager.getRunescapeSmallFont());
        final JLabel checkBox = new JLabel();
        if (this.presetHasConfigurations && this.presetConfig.getEnabled() != null) {
            checkBox.setIcon(Icons.CHECKBOX_CHECKED_ICON);
            checkBox.setToolTipText("Remove plugin on/off configuration from the preset.");
            checkBox.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    ConfigPanel.this.presetEditor.removeEnabledFromEdited(ConfigPanel.this.currentConfig);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    checkBox.setIcon(Icons.CHECKBOX_CHECKED_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    checkBox.setIcon(Icons.CHECKBOX_CHECKED_ICON);
                }
            });
            if (this.currentConfig.getEnabled().equals(this.presetConfig.getEnabled())) {
                title.setForeground(Color.LIGHT_GRAY);
            } else {
                title.setForeground(ColorScheme.BRAND_ORANGE);
            }
        } else {
            title.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
            checkBox.setIcon(Icons.CHECKBOX_ICON);
            checkBox.setToolTipText("Add plugin on/off configuration to the preset.");
            checkBox.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    ConfigPanel.this.presetEditor.addEnabledToEdited(ConfigPanel.this.currentConfig);
                }
            });
        }
        JPanel rightActions = new JPanel();
        rightActions.setLayout(new FlowLayout(0, 14, 0));
        rightActions.add(checkBox);
        enabledRow.add((Component)title, "Center");
        enabledRow.add((Component)rightActions, "East");
        return enabledRow;
    }

    private boolean isSettingsVisible() {
        return this.openSettings.contains(this.currentConfig.getName());
    }

    private JPopupMenu getCustomSettingPopupMenu() {
        JMenuItem addCustomOption = new JMenuItem();
        addCustomOption.setText("Add custom setting");
        addCustomOption.addActionListener(e -> this.promptCustomSettingInput());
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(2, 2, 2, 0));
        popupMenu.add(addCustomOption);
        return popupMenu;
    }

    private void promptCustomSettingInput() {
        String customPresetName = JOptionPane.showInputDialog(this, "Format: configName.settingKey", this.currentConfig.getName() + " custom setting", -1);
        if (customPresetName != null && customPresetName.length() > 0) {
            this.presetEditor.addCustomSettingToEdited(this.currentConfig, customPresetName);
        }
    }

    private void toggleSettings() {
        String name = this.currentConfig.getName();
        if (this.settingsVisible) {
            this.openSettings.remove(name);
        } else {
            this.openSettings.add(name);
        }
        this.plugin.rebuildPluginUi();
    }

    private boolean presetHasConfigurations() {
        return this.presetConfig != null;
    }

    private boolean isExternalPluginConfig() {
        return this.presetManager.isExternalPlugin(this.currentConfig.getName());
    }

    private boolean isExternalPluginInstalled() {
        return this.external && this.presetManager.isExternalPluginInstalled(this.currentConfig.getName());
    }

    private boolean isPartial() {
        return this.presetConfig.getSettings().size() < this.currentConfig.getSettings().size() || this.presetConfig.getEnabled() == null && this.presetConfig.getSettings().size() > 0;
    }

    private JPopupMenu getUpdateAllMenuPopup() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(2, 2, 2, 0));
        if (this.configsMatch) {
            JMenuItem removeOption = new JMenuItem();
            removeOption.setText("Remove " + this.currentConfig.getName() + " from all presets");
            removeOption.addActionListener(e -> this.presetEditor.removeConfigurationFromPresets(this.currentConfig));
            popupMenu.add(removeOption);
        } else {
            JMenuItem addOption = new JMenuItem();
            addOption.setText("Add " + this.currentConfig.getName() + " to all presets");
            addOption.addActionListener(e -> this.presetEditor.addConfigurationToPresets(this.currentConfig));
            popupMenu.add(addOption);
        }
        return popupMenu;
    }
}

