/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.google.common.base.Strings;
import com.pluginpresets.PluginPreset;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.text.WordUtils;

public class PluginPresetsUtils {
    public static boolean stringContainsInvalidCharacters(String string) {
        return !Pattern.compile("(?i)^[ a-\u00f60-9-_.,;=()+!]+$").matcher(string).matches();
    }

    public static String splitAndCapitalize(String string) {
        return WordUtils.capitalize((String)string.replaceAll("\\W", "").replaceAll("(.)([A-Z])", "$1 $2"));
    }

    public static String pluginListToString(List<String> plugins) {
        StringBuilder message = new StringBuilder(plugins.get(0));
        for (int i = 1; i < plugins.size(); ++i) {
            if (i == plugins.size() - 1) {
                message.append(" and ").append(plugins.get(i));
                break;
            }
            message.append(", ");
            if (i % 4 == 0) {
                message.append("\n");
            }
            message.append(plugins.get(i));
        }
        if (plugins.size() == 1) {
            return message + " plugin.";
        }
        return message + " plugins.";
    }

    public static String getClipboardText() {
        String clipboardText;
        try {
            clipboardText = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException | IOException ignore) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)clipboardText)) {
            return null;
        }
        return clipboardText;
    }

    public static String createNameWithSuffixIfNeeded(String name, List<PluginPreset> pluginPresets) {
        int duplicates = 0;
        for (PluginPreset preset : pluginPresets) {
            if (!preset.getName().contains(name)) continue;
            ++duplicates;
        }
        if (duplicates > 0) {
            boolean endWithSuffix;
            boolean bl = endWithSuffix = name.length() > 2 && name.charAt(name.length() - 2) == '(' && name.endsWith(")");
            if (endWithSuffix) {
                return String.format("%s (%d)", name.substring(0, name.length() - 3), duplicates);
            }
            return String.format("%s (%d)", name, duplicates);
        }
        return name;
    }
}

