/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.pluginpresets.PluginPreset;
import com.pluginpresets.PluginPresetsPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginPresetsStorage {
    private static final Logger log = LoggerFactory.getLogger(PluginPresetsStorage.class);
    private static final File PRESETS_DIR = PluginPresetsPlugin.PRESETS_DIR;
    private final List<String> failedFileNames = new ArrayList<String>();
    private final PluginPresetsPlugin plugin;
    @Inject
    private Gson gson;
    private Thread thread;
    private WatchService watcher;
    private boolean localClientChange = false;
    private long lastRefreshTime;

    @Inject
    public PluginPresetsStorage(PluginPresetsPlugin plugin) {
        this.plugin = plugin;
    }

    private static File createNewPresetFileWithCustomSuffix(PluginPreset pluginPreset, int fileNumber) {
        return new File(PRESETS_DIR, String.format("%s (%d).json", pluginPreset.getName(), fileNumber));
    }

    public static void createPresetFolder() {
        boolean presetFolderWasCreated = PRESETS_DIR.mkdirs();
        if (presetFolderWasCreated) {
            log.info(String.format("Preset folder created at %s", PRESETS_DIR.getAbsolutePath()));
        }
    }

    public void deletePresetFolderIfEmpty() {
        if (PRESETS_DIR.exists() && Objects.requireNonNull(PRESETS_DIR.listFiles()).length > 0) {
            return;
        }
        this.deletePresetFolder();
    }

    private void deletePresetFolder() {
        boolean folderDeleted = PRESETS_DIR.delete();
        if (!folderDeleted) {
            log.warn(String.format("Could not delete %s", PRESETS_DIR.getName()));
        }
    }

    public void savePresets(List<PluginPreset> pluginPresets) {
        this.localClientChange = true;
        this.clearPresetFolder();
        pluginPresets.forEach(this::storePluginPresetToJsonFile);
    }

    private void clearPresetFolder() {
        for (File file : Objects.requireNonNull(PRESETS_DIR.listFiles())) {
            if (this.failedFileNames.contains(file.getName())) continue;
            this.deleteFile(file);
        }
    }

    private void deleteFile(File file) {
        boolean fileWasDeleted = file.delete();
        if (!fileWasDeleted) {
            log.warn(String.format("Could not delete %s", file.getName()));
        }
    }

    private void storePluginPresetToJsonFile(PluginPreset pluginPreset) {
        if (!pluginPreset.getLocal().booleanValue()) {
            return;
        }
        File presetJsonFile = this.getPresetJsonFileFrom(pluginPreset);
        if (presetJsonFile.exists()) {
            presetJsonFile = this.giveJsonFileCustomSuffixNumber(pluginPreset, presetJsonFile);
        }
        this.writePresetDataToJsonFile(pluginPreset, presetJsonFile);
    }

    private File getPresetJsonFileFrom(PluginPreset pluginPreset) {
        return new File(PRESETS_DIR, String.format("%s.json", pluginPreset.getName()));
    }

    private File giveJsonFileCustomSuffixNumber(PluginPreset pluginPreset, File presetJsonFile) {
        int fileNumber = 1;
        while (presetJsonFile.exists()) {
            presetJsonFile = PluginPresetsStorage.createNewPresetFileWithCustomSuffix(pluginPreset, fileNumber);
            ++fileNumber;
        }
        return presetJsonFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePresetDataToJsonFile(PluginPreset pluginPreset, File presetJsonFile) {
        pluginPreset.setLocal(null);
        try (FileWriter writer = new FileWriter(presetJsonFile);){
            this.gson.toJson((Object)pluginPreset, (Appendable)writer);
        }
        catch (Exception exception) {
        }
        finally {
            pluginPreset.setLocal(true);
        }
    }

    public List<PluginPreset> loadPresets() throws IOException {
        this.failedFileNames.clear();
        ArrayList<Long> loadedIds = new ArrayList<Long>();
        ArrayList<PluginPreset> pluginPresetsFromFolder = new ArrayList<PluginPreset>();
        for (File file : Objects.requireNonNull(PRESETS_DIR.listFiles())) {
            if (!file.isFile()) continue;
            PluginPreset pluginPreset = this.parsePluginPresetFrom(file);
            if (pluginPreset != null) {
                long id = pluginPreset.getId();
                if (loadedIds.contains(id)) continue;
                pluginPreset.setLocal(true);
                pluginPresetsFromFolder.add(pluginPreset);
                loadedIds.add(id);
                continue;
            }
            this.failedFileNames.add(file.getName());
        }
        return pluginPresetsFromFolder;
    }

    private PluginPreset parsePluginPresetFrom(File file) throws IOException {
        PluginPreset newPreset;
        try (FileReader reader = new FileReader(file);){
            newPreset = (PluginPreset)this.gson.fromJson((Reader)reader, new TypeToken<PluginPreset>(){}.getType());
        }
        catch (JsonSyntaxException | FileNotFoundException e) {
            log.warn(String.format("Failed to load preset from %s, %s", file.getAbsolutePath(), e.getMessage()));
            return null;
        }
        if (this.isMalformedPluginPreset(newPreset)) {
            log.warn(String.format("Plugin Preset data is malformed in file and could not be loaded %s, %s", file.getAbsolutePath(), newPreset));
            return null;
        }
        return newPreset;
    }

    private boolean isMalformedPluginPreset(PluginPreset newPreset) {
        return newPreset.getName() == null || newPreset.getPluginConfigs() == null;
    }

    public PluginPreset parsePluginPresetFrom(String string) {
        PluginPreset newPreset;
        try {
            newPreset = (PluginPreset)this.gson.fromJson(string, new TypeToken<PluginPreset>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            return null;
        }
        if (newPreset == null || newPreset.getName() == null || newPreset.getPluginConfigs() == null) {
            return null;
        }
        return newPreset;
    }

    public void watchFolderChanges() {
        this.thread = new Thread(this::watchFolder);
        this.thread.setName("PresetFolderWatcher");
        this.thread.start();
    }

    public void stopWatcher() {
        this.thread.interrupt();
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.watcher = null;
        this.thread = null;
    }

    public void watchFolder() {
        Path presetDir = PRESETS_DIR.toPath();
        try {
            this.watcher = presetDir.getFileSystem().newWatchService();
            presetDir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (this.watcher != null) {
            boolean valid;
            WatchKey wk;
            if (!this.thread.isAlive()) {
                return;
            }
            try {
                wk = this.watcher.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            if (!wk.pollEvents().isEmpty()) {
                boolean validMillisDiff;
                boolean bl = validMillisDiff = System.currentTimeMillis() - this.lastRefreshTime > 100L;
                if (validMillisDiff) {
                    if (!this.localClientChange) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    this.lastRefreshTime = System.currentTimeMillis();
                    SwingUtilities.invokeLater(this.plugin::refreshPresets);
                    this.localClientChange = false;
                }
            }
            if (valid = wk.reset()) continue;
            break;
        }
    }
}

