/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.google.common.reflect.ClassPath;
import com.google.inject.Inject;
import com.pluginpresets.PluginConfig;
import com.pluginpresets.PluginPreset;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PluginPresetsPresetManager {
    private static final Logger log = LoggerFactory.getLogger(PluginPresetsPresetManager.class);
    private final PluginManager pluginManager;
    private final ConfigManager configManager;
    private final List<String> corePlugins;

    @Inject
    public PluginPresetsPresetManager(PluginManager pluginManager, ConfigManager configManager) {
        this.pluginManager = pluginManager;
        this.configManager = configManager;
        this.corePlugins = this.getCorePlugins();
    }

    public void disablePreset(PluginPreset preset, Runnable onComplete) {
        Collection plugins = this.pluginManager.getPlugins();
        preset.getPluginConfigs().forEach(pluginConfig -> {
            Plugin plugin = this.findPlugin(pluginConfig.getName(), plugins);
            Boolean enabled = pluginConfig.getEnabled();
            if (plugin != null && enabled != null && enabled.booleanValue()) {
                this.enablePlugin(plugin, false);
            }
        });
        onComplete.run();
    }

    public void loadPreset(PluginPreset preset, Runnable onComplete) {
        Collection plugins = this.pluginManager.getPlugins();
        Map<Plugin, Boolean> customPluginsToRestart = preset.getPluginConfigs().stream().filter(PluginConfig::containsCustomSettings).map(config -> {
            Plugin plugin = this.findPlugin(config.getName(), plugins);
            Boolean enabled = plugin != null ? Boolean.valueOf(this.pluginManager.isPluginEnabled(plugin)) : null;
            Boolean shouldEnable = config.getEnabled();
            return shouldEnable == null || Objects.equals(enabled, shouldEnable) ? plugin : null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(p -> p, arg_0 -> ((PluginManager)this.pluginManager).isPluginEnabled(arg_0)));
        preset.getPluginConfigs().forEach(pluginConfig -> {
            Plugin plugin = this.findPlugin(pluginConfig.getName(), plugins);
            pluginConfig.getSettings().forEach(setting -> {
                String value = setting.getValue();
                if (value != null) {
                    String customConfigName = setting.getCustomConfigName();
                    boolean customConfig = customConfigName != null;
                    String groupName = customConfig ? customConfigName : pluginConfig.getConfigName();
                    this.configManager.setConfiguration(groupName, setting.getKey(), value);
                }
            });
            Boolean enabled = pluginConfig.getEnabled();
            if (plugin != null && enabled != null) {
                this.enablePlugin(plugin, enabled);
            }
        });
        if (customPluginsToRestart.isEmpty()) {
            onComplete.run();
        } else {
            customPluginsToRestart.forEach((plugin, enabled) -> this.enablePlugin((Plugin)plugin, enabled == false, false));
            SwingUtilities.invokeLater(() -> {
                customPluginsToRestart.forEach((plugin, enabled) -> this.enablePlugin((Plugin)plugin, (boolean)enabled, false));
                onComplete.run();
            });
        }
    }

    private Plugin findPlugin(String plugin, Collection<Plugin> plugins) {
        for (Plugin p : plugins) {
            if (!p.getName().equals(plugin)) continue;
            return p;
        }
        return null;
    }

    private void enablePlugin(Plugin plugin, boolean enabled) {
        this.enablePlugin(plugin, enabled, false);
    }

    private void enablePlugin(Plugin plugin, boolean enabled, boolean skipSetEnable) {
        if (!skipSetEnable) {
            this.pluginManager.setPluginEnabled(plugin, enabled);
        }
        try {
            if (enabled) {
                this.pluginManager.startPlugin(plugin);
            } else {
                this.pluginManager.stopPlugin(plugin);
            }
        }
        catch (PluginInstantiationException ex) {
            log.warn("Error when {} plugin {}", new Object[]{enabled ? "starting" : "stopping", plugin.getClass().getSimpleName(), ex});
        }
    }

    public PluginPreset createPluginPreset(String presetName) {
        return new PluginPreset(presetName);
    }

    public boolean isExternalPlugin(String pluginName) {
        if (pluginName.equals("RuneLite")) {
            return false;
        }
        return !this.corePlugins.contains(pluginName);
    }

    public boolean isExternalPluginInstalled(String pluginName) {
        return this.pluginManager.getPlugins().stream().map(Plugin::getName).collect(Collectors.toList()).contains(pluginName);
    }

    public String getConfiguration(String groupName, String key) {
        return this.configManager.getConfiguration(groupName, key);
    }

    private List<String> getCorePlugins() {
        ArrayList<String> pluginNames = new ArrayList<String>();
        try {
            ClassPath classPath = ClassPath.from((ClassLoader)this.pluginManager.getClass().getClassLoader());
            List plugins = classPath.getTopLevelClassesRecursive("net.runelite.client.plugins").stream().map(ClassPath.ClassInfo::load).collect(Collectors.toList());
            for (Class clazz : plugins) {
                PluginDescriptor pluginDescriptor = clazz.getAnnotation(PluginDescriptor.class);
                if (pluginDescriptor == null) continue;
                pluginNames.add(pluginDescriptor.name());
            }
        }
        catch (IOException e) {
            log.error("Error getting core plugins", (Throwable)e);
        }
        return pluginNames;
    }
}

