/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.pluginpresets.CurrentConfigurations;
import com.pluginpresets.PluginConfig;
import com.pluginpresets.PluginPreset;
import com.pluginpresets.PluginPresetsPlugin;
import com.pluginpresets.PluginPresetsUtils;
import com.pluginpresets.PluginSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginPresetsPresetEditor {
    private static final Logger log = LoggerFactory.getLogger(PluginPresetsPresetEditor.class);
    private final PluginPresetsPlugin plugin;
    private final CurrentConfigurations currentConfigurations;
    private final PluginPreset editedPreset;

    public PluginPresetsPresetEditor(PluginPresetsPlugin plugin, PluginPreset editedPreset, CurrentConfigurations currentConfigurations) {
        this.plugin = plugin;
        this.editedPreset = editedPreset;
        this.currentConfigurations = currentConfigurations;
    }

    public void removeConfigurationFromEdited(PluginConfig configuration) {
        this.removeConfigurationFromEdited(configuration, false);
    }

    private void removeConfigurationFromEdited(PluginConfig configuration, Boolean skipUpdate) {
        List<PluginConfig> pluginConfigs = this.editedPreset.getPluginConfigs().stream().filter(c -> !c.getName().equals(configuration.getName())).collect(Collectors.toList());
        this.editedPreset.setPluginConfigs(pluginConfigs);
        if (!skipUpdate.booleanValue()) {
            this.updateEditedPreset();
        }
    }

    public void addConfigurationToEdited(PluginConfig configuration) {
        this.addConfigurationToEdited(configuration, false);
    }

    private void addConfigurationToEdited(PluginConfig configuration, Boolean skipUpdate) {
        List<PluginConfig> pluginConfigs = this.editedPreset.getPluginConfigs();
        pluginConfigs.add(configuration);
        this.editedPreset.setPluginConfigs(pluginConfigs);
        if (!skipUpdate.booleanValue()) {
            this.updateEditedPreset();
        }
    }

    public void removeSettingFromEdited(PluginConfig currentConfig, PluginSetting setting) {
        this.editedPreset.getPluginConfigs().forEach(configuration -> {
            boolean configToBeRemoved;
            boolean bl = configToBeRemoved = currentConfig == null || configuration.getName().equals(currentConfig.getName());
            if (configToBeRemoved) {
                boolean lastSetting;
                List<PluginSetting> settings = configuration.getSettings().stream().filter(s -> !s.getKey().equals(setting.getKey())).collect(Collectors.toList());
                configuration.setSettings(settings);
                boolean bl2 = lastSetting = configuration.getSettings().isEmpty() && configuration.getEnabled() == null;
                if (lastSetting) {
                    this.removeConfigurationFromEdited((PluginConfig)configuration);
                }
            }
        });
        this.updateEditedPreset();
    }

    public void addSettingToEdited(PluginConfig currentConfig, PluginSetting setting) {
        boolean noneMatch = this.editedPreset.getPluginConfigs().stream().noneMatch(c -> c.getName().equals(currentConfig.getName()));
        if (noneMatch) {
            ArrayList<PluginSetting> settings = new ArrayList<PluginSetting>();
            settings.add(setting);
            PluginConfig pluginConfig = new PluginConfig(currentConfig.getName(), currentConfig.getConfigName(), null, settings);
            this.editedPreset.getPluginConfigs().add(pluginConfig);
        } else {
            this.editedPreset.getPluginConfigs().forEach(configuration -> {
                if (configuration.getName().equals(currentConfig.getName())) {
                    configuration.getSettings().add(setting);
                }
            });
        }
        this.updateEditedPreset();
    }

    public void addCustomSettingToEdited(PluginConfig currentConfig, String customSetting) {
        String key;
        String configName;
        try {
            String[] split = customSetting.split("\\.");
            configName = split[0];
            key = split[1].split("=")[0];
        }
        catch (Exception e) {
            log.warn("Failed to add custom setting " + customSetting + " to preset. Reason: " + e.getMessage());
            return;
        }
        PluginConfig config = this.editedPreset.getPluginConfigs().stream().filter(customer -> customer.getConfigName().equals(currentConfig.getConfigName())).findAny().orElse(null);
        if (config == null) {
            for (PluginConfig c : this.currentConfigurations.getPluginConfigs()) {
                if (!c.getConfigName().equals(currentConfig.getConfigName())) continue;
                config = new PluginConfig(c.getName(), c.getConfigName(), null, new ArrayList<PluginSetting>());
            }
            this.editedPreset.getPluginConfigs().add(config);
        }
        if (config == null) {
            log.warn("Could not add custom setting.");
            return;
        }
        String value = this.plugin.getPresetManager().getConfiguration(configName, key);
        PluginSetting setting = new PluginSetting(PluginPresetsUtils.splitAndCapitalize(key), key, value, configName, config.getConfigName());
        if (config.getSetting(setting) == null) {
            config.getSettings().add(setting);
            this.updateEditedPreset();
            this.plugin.refreshPresets();
        }
    }

    public void addEnabledToEdited(PluginConfig currentConfig) {
        boolean noneMatch = this.editedPreset.getPluginConfigs().stream().noneMatch(c -> currentConfig.getName().equals(c.getName()));
        if (noneMatch) {
            ArrayList<PluginSetting> settings = new ArrayList<PluginSetting>();
            PluginConfig pluginConfig = new PluginConfig(currentConfig.getName(), currentConfig.getConfigName(), currentConfig.getEnabled(), settings);
            this.editedPreset.getPluginConfigs().add(pluginConfig);
        } else {
            this.editedPreset.getPluginConfigs().forEach(configuration -> {
                if (configuration.getName().equals(currentConfig.getName())) {
                    configuration.setEnabled(currentConfig.getEnabled());
                }
            });
        }
        this.updateEditedPreset();
    }

    public void removeEnabledFromEdited(PluginConfig currentConfig) {
        this.editedPreset.getPluginConfigs().forEach(configurations -> {
            if (configurations.getName().equals(currentConfig.getName())) {
                configurations.setEnabled(null);
                if (configurations.getSettings().isEmpty()) {
                    this.removeConfigurationFromEdited((PluginConfig)configurations);
                }
            }
        });
        this.updateEditedPreset();
    }

    public void addConfigurationToPresets(PluginConfig configuration) {
        this.addConfigurationToEdited(configuration);
        this.plugin.getPluginPresets().forEach(preset -> {
            boolean contains = preset.getPluginConfigs().stream().map(PluginConfig::getName).collect(Collectors.toList()).contains(configuration.getName());
            if (contains) {
                List<PluginConfig> pluginConfigs = preset.getPluginConfigs().stream().filter(c -> !c.getName().equals(configuration.getName())).collect(Collectors.toList());
                preset.setPluginConfigs(pluginConfigs);
            }
            preset.getPluginConfigs().add(configuration);
        });
    }

    public void removeConfigurationFromPresets(PluginConfig configuration) {
        this.removeConfigurationFromEdited(configuration);
        this.plugin.getPluginPresets().forEach(preset -> {
            List<PluginConfig> pluginConfigs = preset.getPluginConfigs().stream().filter(c -> !c.getName().equals(configuration.getName())).collect(Collectors.toList());
            preset.setPluginConfigs(pluginConfigs);
        });
        this.plugin.savePresets();
    }

    public void updateConfigurations(PluginConfig presetConfig, PluginConfig currentConfig) {
        this.removeConfigurationFromEdited(presetConfig, true);
        List<String> presetConfigKeys = presetConfig.getSettingKeys();
        List<PluginSetting> currentSettings = currentConfig.getSettings().stream().filter(s -> presetConfigKeys.contains(s.getKey())).collect(Collectors.toList());
        currentConfig.setSettings(currentSettings);
        if (presetConfig.getEnabled() == null) {
            currentConfig.setEnabled(null);
        }
        this.addConfigurationToEdited(currentConfig, true);
        this.updateEditedPreset();
    }

    public void updateAllModified() {
        for (PluginConfig presetConfig : this.editedPreset.getPluginConfigs()) {
            PluginConfig currentConfig = this.currentConfigurations.getPluginConfigs().stream().filter(c -> c.getName().equals(presetConfig.getName())).findAny().orElse(null);
            this.removeConfigurationFromEdited(presetConfig, true);
            List keys = presetConfig.getSettings().stream().map(PluginSetting::getKey).collect(Collectors.toList());
            if (currentConfig == null) {
                this.addConfigurationToEdited(presetConfig, true);
                continue;
            }
            List<PluginSetting> updatedSettings = currentConfig.getSettings().stream().filter(s -> keys.contains(s.getKey())).collect(Collectors.toList());
            currentConfig.setSettings(updatedSettings);
            if (presetConfig.getEnabled() == null) {
                currentConfig.setEnabled(null);
            }
            this.addConfigurationToEdited(currentConfig, true);
        }
        this.updateEditedPreset();
    }

    public void addAll(List<PluginConfig> pluginConfigs) {
        for (PluginConfig pluginConfig : pluginConfigs) {
            this.removeConfigurationFromEdited(pluginConfig, true);
            this.addConfigurationToEdited(pluginConfig, true);
        }
        this.updateEditedPreset();
    }

    public void removeAll(List<PluginConfig> pluginConfigs) {
        for (PluginConfig pluginConfig : pluginConfigs) {
            this.removeConfigurationFromEdited(pluginConfig, true);
        }
        this.updateEditedPreset();
    }

    public void toggleLocal() {
        this.editedPreset.setLocal(this.editedPreset.getLocal() == false);
        this.updateEditedPreset();
    }

    private PluginPreset getPresetBeingEdited() {
        for (PluginPreset preset : this.plugin.getPluginPresets()) {
            if (preset.getId() != this.editedPreset.getId()) continue;
            return preset;
        }
        return null;
    }

    public void syncAutoUpdate() {
        this.editedPreset.setAutoUpdated(Objects.requireNonNull(this.getPresetBeingEdited()).getAutoUpdated());
        this.updateEditedPreset();
    }

    public void updateEditedPreset() {
        PluginPreset preset = this.getPresetBeingEdited();
        if (preset != null) {
            preset.setPluginConfigs(this.editedPreset.getPluginConfigs());
            preset.setAutoUpdated(this.editedPreset.getAutoUpdated());
            preset.setLocal(this.editedPreset.getLocal());
        }
        this.plugin.savePresets();
    }

    public PluginPreset getEditedPreset() {
        return this.editedPreset;
    }
}

