/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.pluginpresets.CurrentConfigurations;
import com.pluginpresets.CustomSettingsManager;
import com.pluginpresets.KeybindManager;
import com.pluginpresets.PluginPreset;
import com.pluginpresets.PluginPresetsPresetEditor;
import com.pluginpresets.PluginPresetsPresetManager;
import com.pluginpresets.PluginPresetsStorage;
import com.pluginpresets.PluginPresetsUtils;
import com.pluginpresets.ui.PluginPresetsPluginPanel;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.GameState;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.Keybind;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.ExternalPluginsChanged;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;

@PluginDescriptor(name="Plugin Presets", description="Create presets of your plugin configurations.", tags={"preset", "setups", "plugins"})
public class PluginPresetsPlugin
extends Plugin {
    public static final File PRESETS_DIR = new File(RuneLite.RUNELITE_DIR, "presets");
    public static final String HELP_LINK = "https://github.com/antero111/plugin-presets/wiki/General-Features#using-plugin-presets";
    public static final String DEFAULT_PRESET_NAME = "Preset";
    static final List<String> IGNORED_PLUGINS = Stream.of("Plugin Presets", "Configuration", "Xtea").collect(Collectors.toList());
    static final List<String> IGNORED_KEYS = Stream.of("channel", "oauth", "username", "notesData", "tzhaarStartTime", "tzhaarLastTime", "chatsData", "previousPartyId", "lastWorld", "tab", "position").collect(Collectors.toList());
    private static final String PLUGIN_NAME = "Plugin Presets";
    private static final String ICON_FILE = "panel_icon.png";
    private static final String CONFIG_GROUP = "pluginpresets";
    private static final String CONFIG_KEY_PRESETS = "presets";
    private static final String CONFIG_KEY_AUTO_UPDATE = "autoUpdate";
    private final List<PluginPreset> pluginPresets = new ArrayList<PluginPreset>();
    private final KeyListener keybindListener = new KeyListener(){

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            PluginPreset preset = PluginPresetsPlugin.this.keybindManager.getPresetFor(new Keybind(e));
            if (preset != null) {
                PluginPresetsPlugin.this.loadPreset(preset);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    @Inject
    private CurrentConfigurations currentConfigurations;
    @Inject
    private CustomSettingsManager customSettingsManager;
    @Inject
    private KeybindManager keybindManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private KeyManager keyManager;
    private NavigationButton navigationButton;
    private PluginPresetsPluginPanel pluginPanel;
    @Inject
    private PluginPresetsPresetManager presetManager;
    @Inject
    private PluginPresetsStorage presetStorage;
    private PluginPresetsPresetEditor presetEditor;
    private PluginPresetsPresetEditor autoUpdater;
    private Boolean loggedIn = false;
    private Boolean loadingPreset = false;
    private String errorMessage;
    private Boolean focusChangedPaused = false;

    protected void startUp() {
        PluginPresetsStorage.createPresetFolder();
        this.pluginPanel = new PluginPresetsPluginPanel(this);
        this.loadPresets();
        this.updateCurrentConfigurations();
        this.setupAutoUpdater();
        this.savePresets();
        this.rebuildPluginUi();
        this.presetStorage.watchFolderChanges();
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)ICON_FILE);
        this.navigationButton = NavigationButton.builder().tooltip(PLUGIN_NAME).priority(8).icon(icon).panel((PluginPanel)this.pluginPanel).popup((Map)ImmutableMap.builder().put((Object)"Open preset folder...", () -> LinkBrowser.open((String)PRESETS_DIR.toString())).build()).build();
        this.clientToolbar.addNavigation(this.navigationButton);
        this.keyManager.registerKeyListener(this.keybindListener);
    }

    protected void shutDown() {
        this.pluginPresets.clear();
        this.keybindManager.clearKeybinds();
        this.autoUpdater = null;
        this.presetStorage.stopWatcher();
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.keyManager.unregisterKeyListener(this.keybindListener);
        this.presetStorage.deletePresetFolderIfEmpty();
        this.pluginPanel = null;
        this.presetEditor = null;
        this.navigationButton = null;
    }

    @Subscribe
    public void onExternalPluginsChanged(ExternalPluginsChanged externalPluginsChanged) {
        this.updateCurrentConfigurations();
        SwingUtilities.invokeLater(this::rebuildPluginUi);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        boolean updated;
        if (this.validConfigChange(configChanged) && !this.loadingPreset.booleanValue() && (updated = this.updateCurrentConfigurations())) {
            if (this.autoUpdater != null) {
                SwingUtilities.invokeLater(this.autoUpdater::updateAllModified);
            } else {
                SwingUtilities.invokeLater(this::rebuildPluginUi);
            }
        }
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged profileChanged) {
        SwingUtilities.invokeLater(this::refreshPresets);
    }

    public boolean updateCurrentConfigurations() {
        Boolean updated = this.currentConfigurations.update();
        if (updated.booleanValue()) {
            this.keybindManager.setCurrentConfigurations(this.currentConfigurations);
        }
        return updated;
    }

    private boolean validConfigChange(ConfigChanged configChanged) {
        return !configChanged.getKey().equals("pluginpresetsplugin") && !configChanged.getGroup().equals(CONFIG_GROUP);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.loggedIn = event.getGameState() == GameState.LOGGED_IN;
        SwingUtilities.invokeLater(this::rebuildPluginUi);
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!this.focusChangedPaused.booleanValue()) {
            boolean focused = focusChanged.isFocused();
            for (PluginPreset preset : this.pluginPresets) {
                Boolean loadOnFocus = preset.getLoadOnFocus();
                if (loadOnFocus == null || loadOnFocus != focused) continue;
                this.loadPreset(preset);
            }
        }
    }

    public void updateConfig() {
        List<PluginPreset> syncPresets = this.pluginPresets.stream().filter(preset -> preset.getLocal() == false).collect(Collectors.toList());
        syncPresets.forEach(preset -> preset.setLocal(null));
        if (syncPresets.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY_PRESETS);
        } else {
            String json = this.gson.toJson(syncPresets);
            this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY_PRESETS, json);
        }
        syncPresets.forEach(preset -> preset.setLocal(false));
        if (syncPresets.size() == this.pluginPresets.size()) {
            this.refreshPresets();
        }
    }

    private void loadConfig(String json) {
        if (Strings.isNullOrEmpty((String)json)) {
            return;
        }
        List configPresetData = (List)this.gson.fromJson(json, new TypeToken<ArrayList<PluginPreset>>(){}.getType());
        configPresetData.forEach(preset -> preset.setLocal(false));
        this.pluginPresets.addAll(configPresetData);
    }

    public void createPreset(String presetName, boolean empty) {
        boolean invalidName;
        boolean noName = ((String)presetName).equals("");
        boolean bl = invalidName = !noName && PluginPresetsUtils.stringContainsInvalidCharacters((String)presetName);
        if (noName || invalidName) {
            presetName = "Preset " + (this.pluginPresets.size() + 1);
            if (invalidName) {
                this.errorMessage = "Preset name contained invalid characters.";
            }
        }
        PluginPreset preset = this.presetManager.createPluginPreset((String)presetName);
        if (!empty) {
            preset.setPluginConfigs(this.currentConfigurations.getPluginConfigs());
        }
        this.pluginPresets.add(preset);
        this.savePresets();
    }

    public void savePresets() {
        this.presetStorage.savePresets(this.pluginPresets);
        this.updateConfig();
    }

    public void refreshPresets() {
        this.pluginPresets.clear();
        this.loadPresets();
        this.rebuildPluginUi();
        if (this.errorMessage != null) {
            this.renderPanelErrorNotification(this.errorMessage);
            this.errorMessage = null;
        }
    }

    public void loadPreset(PluginPreset preset) {
        this.loadingPreset = true;
        if (this.autoUpdater != null && !this.autoUpdater.getEditedPreset().match(preset).booleanValue()) {
            this.setAutoUpdatedPreset(null);
        }
        this.presetManager.loadPreset(preset, () -> {
            this.loadingPreset = false;
            this.updateCurrentConfigurations();
            this.rebuildPluginUi();
            if (preset.getAutoUpdated() != null) {
                this.setAutoUpdatedPreset(preset.getId());
            }
        });
    }

    public void disablePreset(PluginPreset preset) {
        this.loadingPreset = true;
        this.presetManager.disablePreset(preset, () -> {
            this.loadingPreset = false;
            this.updateCurrentConfigurations();
            this.rebuildPluginUi();
        });
    }

    public void deletePreset(PluginPreset preset) {
        this.pluginPresets.remove(preset);
        this.savePresets();
    }

    public void loadPresets() {
        this.pluginPresets.addAll(this.presetStorage.loadPresets());
        this.loadConfig(this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY_PRESETS));
        this.pluginPresets.sort(Comparator.comparing(PluginPreset::getName));
        this.customSettingsManager.parseCustomSettings(this.pluginPresets);
        this.keybindManager.cacheKeybinds(this.pluginPresets);
    }

    private void setupAutoUpdater() {
        String configuration = this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY_AUTO_UPDATE);
        if (configuration != null) {
            long id = Long.parseLong(configuration);
            boolean failed = true;
            for (PluginPreset p : this.pluginPresets) {
                if (p.getId() != id) continue;
                PluginPresetsPresetEditor updater = new PluginPresetsPresetEditor(this, p, this.currentConfigurations);
                this.setAutoUpdater(updater);
                failed = false;
            }
            if (failed) {
                this.setAutoUpdatedPreset(null);
            } else {
                this.autoUpdater.updateAllModified();
            }
        }
    }

    public void setAutoUpdatedPreset(Long id) {
        if (id == null) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY_AUTO_UPDATE);
            this.setAutoUpdater(null);
            this.rebuildPluginUi();
        } else {
            boolean doRefresh = false;
            this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY_AUTO_UPDATE, (Object)id);
            for (PluginPreset p : this.pluginPresets) {
                if (p.getId() != id.longValue()) continue;
                p.setAutoUpdated(true);
                doRefresh = true;
                this.savePresets();
            }
            this.setupAutoUpdater();
            if (doRefresh && this.presetEditor != null) {
                this.presetEditor.syncAutoUpdate();
            }
        }
    }

    public void addAutoUpdateFrom(PluginPreset preset) {
        preset.setAutoUpdated(true);
        this.savePresets();
        this.rebuildPluginUi();
    }

    public void removeAutoUpdateFrom(PluginPreset preset) {
        preset.setAutoUpdated(null);
        this.savePresets();
        this.rebuildPluginUi();
    }

    public void importPresetFromClipboard() {
        String clipboardText = PluginPresetsUtils.getClipboardText();
        if (clipboardText == null) {
            this.renderPanelErrorNotification("Unable read to clipboard content.");
            return;
        }
        PluginPreset newPreset = this.presetStorage.parsePluginPresetFrom(clipboardText);
        if (newPreset != null) {
            newPreset.setId(Instant.now().toEpochMilli());
            newPreset.setName(PluginPresetsUtils.createNameWithSuffixIfNeeded(newPreset.getName(), this.pluginPresets));
            newPreset.setLocal(true);
            this.pluginPresets.add(newPreset);
            this.savePresets();
            this.refreshPresets();
        } else {
            this.renderPanelErrorNotification("You do not have any valid presets in your clipboard.");
        }
    }

    public void duplicatePreset(PluginPreset preset) {
        PluginPreset newPreset = new PluginPreset(PluginPresetsUtils.createNameWithSuffixIfNeeded(preset.getName(), this.pluginPresets));
        newPreset.setPluginConfigs(preset.getPluginConfigs());
        this.pluginPresets.add(newPreset);
        this.savePresets();
        this.refreshPresets();
    }

    public void exportPresetToClipboard(PluginPreset preset) {
        String json = this.gson.toJson((Object)preset);
        StringSelection contents = new StringSelection(json);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
    }

    public void renderPanelErrorNotification(String message) {
        this.pluginPanel.renderNotification(message);
    }

    public void rebuildPluginUi() {
        this.pluginPanel.rebuild();
    }

    public List<PluginPreset> getPluginPresets() {
        return this.pluginPresets;
    }

    public CurrentConfigurations getCurrentConfigurations() {
        return this.currentConfigurations;
    }

    public CustomSettingsManager getCustomSettingsManager() {
        return this.customSettingsManager;
    }

    public KeybindManager getKeybindManager() {
        return this.keybindManager;
    }

    public PluginPresetsPresetManager getPresetManager() {
        return this.presetManager;
    }

    public PluginPresetsPresetEditor getPresetEditor() {
        return this.presetEditor;
    }

    public void setPresetEditor(PluginPresetsPresetEditor presetEditor) {
        this.presetEditor = presetEditor;
    }

    public PluginPresetsPresetEditor getAutoUpdater() {
        return this.autoUpdater;
    }

    public void setAutoUpdater(PluginPresetsPresetEditor autoUpdater) {
        this.autoUpdater = autoUpdater;
    }

    public Boolean getLoggedIn() {
        return this.loggedIn;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Boolean getFocusChangedPaused() {
        return this.focusChangedPaused;
    }

    public void setFocusChangedPaused(Boolean focusChangedPaused) {
        this.focusChangedPaused = focusChangedPaused;
    }
}

