/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.pluginpresets.CustomSetting;
import com.pluginpresets.CustomSettingsManager;
import com.pluginpresets.PluginConfig;
import com.pluginpresets.PluginPresetsPlugin;
import com.pluginpresets.PluginPresetsUtils;
import com.pluginpresets.PluginSetting;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigDescriptor;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.plugins.PluginManager;

@Singleton
public class PluginPresetsCurrentConfigManager {
    private final PluginManager pluginManager;
    private final ConfigManager configManager;
    private final RuneLiteConfig runeLiteConfig;
    private final CustomSettingsManager customSettingsManager;

    @Inject
    public PluginPresetsCurrentConfigManager(PluginManager pluginManager, ConfigManager configManager, RuneLiteConfig runeLiteConfig, CustomSettingsManager customSettingsManager) {
        this.pluginManager = pluginManager;
        this.configManager = configManager;
        this.runeLiteConfig = runeLiteConfig;
        this.customSettingsManager = customSettingsManager;
    }

    public List<PluginConfig> getCurrentConfigs() {
        ArrayList<PluginConfig> pluginConfigs = new ArrayList<PluginConfig>();
        this.pluginManager.getPlugins().forEach(p -> {
            String name = p.getName();
            if (!PluginPresetsPlugin.IGNORED_PLUGINS.contains(name)) {
                String configName;
                Config pluginConfigProxy = this.pluginManager.getPluginConfigProxy(p);
                boolean enabled = this.pluginManager.isPluginEnabled(p);
                ArrayList<PluginSetting> pluginSettings = new ArrayList<PluginSetting>();
                if (pluginConfigProxy == null) {
                    configName = p.getClass().getSimpleName().toLowerCase();
                } else {
                    ConfigDescriptor configDescriptor = this.configManager.getConfigDescriptor(pluginConfigProxy);
                    configName = configDescriptor.getGroup().value();
                    configDescriptor.getItems().forEach(i -> {
                        if (!PluginPresetsPlugin.IGNORED_KEYS.contains(i.key())) {
                            String settingName = i.name();
                            if (i.name().equals("")) {
                                settingName = PluginPresetsUtils.splitAndCapitalize(settingName);
                            }
                            String configuration = this.configManager.getConfiguration(configDescriptor.getGroup().value(), i.key());
                            PluginSetting pluginSetting = new PluginSetting(settingName, i.key(), configuration, null, null);
                            pluginSettings.add(pluginSetting);
                        }
                    });
                }
                List<CustomSetting> configsCustomSettings = this.customSettingsManager.getCustomConfigsFor(configName);
                if (!configsCustomSettings.isEmpty()) {
                    ArrayList addedCustomSettings = new ArrayList();
                    configsCustomSettings.forEach(customSetting -> {
                        String customConfigKey;
                        PluginSetting setting = customSetting.getSetting();
                        String customConfigName = setting.getCustomConfigName();
                        String customConfig = customConfigName + "." + (customConfigKey = setting.getKey());
                        if (!addedCustomSettings.contains(customConfig)) {
                            String value = this.configManager.getConfiguration(customConfigName, setting.getKey());
                            PluginSetting pluginSetting = new PluginSetting(setting.getName(), setting.getKey(), value, customConfigName, setting.getConfigName());
                            pluginSettings.add(pluginSetting);
                            addedCustomSettings.add(customConfig);
                        }
                    });
                }
                PluginConfig pluginConfig = new PluginConfig(name, configName, enabled, pluginSettings);
                pluginConfigs.add(pluginConfig);
            }
        });
        ArrayList<PluginSetting> runelitePluginSettings = new ArrayList<PluginSetting>();
        PluginConfig runeliteConfig = new PluginConfig("RuneLite", "runelite", true, runelitePluginSettings);
        this.configManager.getConfigDescriptor((Config)this.runeLiteConfig).getItems().forEach(i -> {
            if (!PluginPresetsPlugin.IGNORED_KEYS.contains(i.key())) {
                String configuration = this.configManager.getConfiguration("runelite", i.key());
                PluginSetting pluginSetting = new PluginSetting(i.name(), i.key(), configuration, null, null);
                runelitePluginSettings.add(pluginSetting);
            }
        });
        List<CustomSetting> customRuneLiteSettings = this.customSettingsManager.getCustomConfigsFor("runelite");
        if (!customRuneLiteSettings.isEmpty()) {
            customRuneLiteSettings.forEach(customSetting -> {
                PluginSetting setting = customSetting.getSetting();
                String value = this.configManager.getConfiguration(setting.getCustomConfigName(), setting.getKey());
                setting.setValue(value);
                runelitePluginSettings.add(setting);
            });
        }
        pluginConfigs.add(runeliteConfig);
        return pluginConfigs;
    }
}

