/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.pluginpresets.CurrentConfigurations;
import com.pluginpresets.PluginConfig;
import com.pluginpresets.PluginSetting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.runelite.client.config.Keybind;

public class PluginPreset {
    private long id = Instant.now().toEpochMilli();
    private String name;
    private Keybind keybind;
    private Boolean local;
    private Boolean loadOnFocus;
    private Boolean autoUpdated;
    private List<PluginConfig> pluginConfigs;

    public PluginPreset(String name) {
        this.name = name;
        this.keybind = null;
        this.local = true;
        this.loadOnFocus = null;
        this.autoUpdated = null;
        this.pluginConfigs = new ArrayList<PluginConfig>();
    }

    public Boolean match(PluginPreset preset) {
        for (PluginConfig presetConfig : this.pluginConfigs) {
            for (PluginConfig comparedConfig : preset.getPluginConfigs()) {
                if (!comparedConfig.getName().equals(presetConfig.getName()) || presetConfig.match(comparedConfig).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public Boolean match(CurrentConfigurations currentConfigurations) {
        for (PluginConfig presetConfig : this.pluginConfigs) {
            PluginConfig currentConfig = null;
            for (PluginConfig config : currentConfigurations.getPluginConfigs()) {
                if (!config.getName().equals(presetConfig.getName())) continue;
                currentConfig = config;
                break;
            }
            if (currentConfig == null) continue;
            if (presetConfig.getEnabled() != null && !presetConfig.getEnabled().equals(currentConfig.getEnabled())) {
                return false;
            }
            List<PluginSetting> currentSettings = currentConfig.getSettings();
            for (PluginSetting presetConfigSetting : presetConfig.getSettings()) {
                PluginSetting currentConfigSetting = currentSettings.stream().filter(c -> c.getKey().equals(presetConfigSetting.getKey())).findFirst().orElse(null);
                if (currentConfigSetting == null || presetConfigSetting.getValue() == null || presetConfigSetting.getValue().equals(currentConfigSetting.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public PluginConfig getConfig(PluginConfig searchedConfig) {
        PluginConfig presetConfig = null;
        for (PluginConfig config : this.pluginConfigs) {
            if (!config.getName().equals(searchedConfig.getName())) continue;
            presetConfig = config;
            break;
        }
        return presetConfig;
    }

    public boolean isEmpty() {
        return this.pluginConfigs.isEmpty();
    }

    public boolean canBeDisabled() {
        for (PluginConfig presetConfig : this.pluginConfigs) {
            if (presetConfig.getEnabled() == null || !presetConfig.getEnabled().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Keybind getKeybind() {
        return this.keybind;
    }

    public void setKeybind(Keybind keybind) {
        this.keybind = keybind;
    }

    public Boolean getLocal() {
        return this.local;
    }

    public void setLocal(Boolean local) {
        this.local = local;
    }

    public Boolean getLoadOnFocus() {
        return this.loadOnFocus;
    }

    public void setLoadOnFocus(Boolean loadOnFocus) {
        this.loadOnFocus = loadOnFocus;
    }

    public Boolean getAutoUpdated() {
        return this.autoUpdated;
    }

    public void setAutoUpdated(Boolean autoUpdated) {
        this.autoUpdated = autoUpdated;
    }

    public List<PluginConfig> getPluginConfigs() {
        return this.pluginConfigs;
    }

    public void setPluginConfigs(List<PluginConfig> pluginConfigs) {
        this.pluginConfigs = pluginConfigs;
    }
}

