/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.pluginpresets.PluginSetting;
import java.util.List;
import java.util.stream.Collectors;

public class PluginConfig {
    private String name;
    private String configName;
    private Boolean enabled;
    private List<PluginSetting> settings;

    public Boolean match(PluginConfig presetConfig) {
        if (presetConfig == null) {
            return false;
        }
        Boolean presetEnabled = presetConfig.getEnabled();
        if (presetEnabled != null && this.enabled != null && !presetEnabled.equals(this.enabled)) {
            return false;
        }
        List<PluginSetting> currentSettings = this.settings;
        for (PluginSetting presetConfigSetting : presetConfig.getSettings()) {
            PluginSetting currentConfigSetting = currentSettings.stream().filter(c -> c.getKey().equals(presetConfigSetting.getKey())).findFirst().orElse(null);
            if (currentConfigSetting == null || presetConfigSetting.getValue() == null || presetConfigSetting.getValue().equals(currentConfigSetting.getValue())) continue;
            return false;
        }
        return true;
    }

    public PluginSetting getSetting(PluginSetting searchedSetting) {
        PluginSetting presetSetting = null;
        if (this.settings != null) {
            for (PluginSetting setting : this.settings) {
                if (!setting.getKey().equals(searchedSetting.getKey())) continue;
                presetSetting = setting;
                break;
            }
        }
        return presetSetting;
    }

    public List<String> getSettingKeys() {
        return this.settings.stream().map(PluginSetting::getKey).collect(Collectors.toList());
    }

    public boolean containsCustomSettings() {
        for (PluginSetting s : this.settings) {
            if (s.getCustomConfigName() == null) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigName() {
        return this.configName;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public List<PluginSetting> getSettings() {
        return this.settings;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setSettings(List<PluginSetting> settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginConfig)) {
            return false;
        }
        PluginConfig other = (PluginConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$configName = this.getConfigName();
        String other$configName = other.getConfigName();
        if (this$configName == null ? other$configName != null : !this$configName.equals(other$configName)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        List<PluginSetting> this$settings = this.getSettings();
        List<PluginSetting> other$settings = other.getSettings();
        return !(this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PluginConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $configName = this.getConfigName();
        result = result * 59 + ($configName == null ? 43 : $configName.hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        List<PluginSetting> $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        return result;
    }

    public String toString() {
        return "PluginConfig(name=" + this.getName() + ", configName=" + this.getConfigName() + ", enabled=" + this.getEnabled() + ", settings=" + this.getSettings() + ")";
    }

    public PluginConfig(String name, String configName, Boolean enabled, List<PluginSetting> settings) {
        this.name = name;
        this.configName = configName;
        this.enabled = enabled;
        this.settings = settings;
    }
}

