/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.pluginpresets.CurrentConfigurations;
import com.pluginpresets.PluginPreset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.config.Keybind;

@Singleton
public class KeybindManager {
    private final HashMap<Keybind, List<PluginPreset>> keybinds = new HashMap();
    private CurrentConfigurations currentConfigurations;

    @Inject
    public KeybindManager() {
    }

    public void cacheKeybinds(List<PluginPreset> pluginPresets) {
        this.keybinds.clear();
        pluginPresets.forEach(preset -> {
            Keybind keybind = preset.getKeybind();
            if (keybind != null) {
                if (this.keybinds.containsKey(keybind)) {
                    this.keybinds.get(keybind).add((PluginPreset)preset);
                } else {
                    ArrayList<PluginPreset> list = new ArrayList<PluginPreset>();
                    list.add((PluginPreset)preset);
                    this.keybinds.put(keybind, list);
                }
            }
        });
    }

    public PluginPreset getPresetFor(Keybind keybind) {
        if (this.keybinds.containsKey(keybind)) {
            return this.getNextPreset(this.keybinds.get(keybind));
        }
        return null;
    }

    public void clearKeybinds() {
        this.keybinds.clear();
    }

    private PluginPreset getNextPreset(List<PluginPreset> list) {
        int currentIndex = -1;
        for (int i = 0; i < list.size(); ++i) {
            PluginPreset preset = list.get(i);
            if (!preset.match(this.currentConfigurations).booleanValue()) continue;
            currentIndex = i;
            break;
        }
        return list.get(currentIndex == list.size() - 1 ? 0 : currentIndex + 1);
    }

    public void setCurrentConfigurations(CurrentConfigurations currentConfigurations) {
        this.currentConfigurations = currentConfigurations;
    }
}

