/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.pluginpresets.CustomSetting;
import com.pluginpresets.PluginConfig;
import com.pluginpresets.PluginPreset;
import com.pluginpresets.PluginSetting;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CustomSettingsManager {
    private final List<CustomSetting> settings = new ArrayList<CustomSetting>();

    @Inject
    public CustomSettingsManager() {
    }

    public List<CustomSetting> getCustomSettingsFor(long id) {
        ArrayList<CustomSetting> customSettingsList = new ArrayList<CustomSetting>();
        this.settings.forEach(s -> {
            if (s.parentPreset.getId() == id) {
                customSettingsList.add((CustomSetting)s);
            }
        });
        return customSettingsList;
    }

    public List<CustomSetting> getCustomConfigsFor(String configName) {
        ArrayList<CustomSetting> customSettingsList = new ArrayList<CustomSetting>();
        this.settings.forEach(s -> {
            if (s.parentConfig.getConfigName().equals(configName)) {
                customSettingsList.add((CustomSetting)s);
            }
        });
        return customSettingsList;
    }

    public void parseCustomSettings(List<PluginPreset> pluginPresets) {
        this.settings.clear();
        pluginPresets.forEach(preset -> preset.getPluginConfigs().forEach(configuration -> configuration.getSettings().forEach(setting -> {
            if (setting.getCustomConfigName() != null) {
                CustomSetting customSetting = new CustomSetting((PluginSetting)setting, (PluginConfig)configuration, (PluginPreset)preset);
                this.settings.add(customSetting);
            }
        })));
    }
}

