/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpresets;

import com.google.inject.Inject;
import com.pluginpresets.PluginConfig;
import com.pluginpresets.PluginPresetsCurrentConfigManager;
import java.util.List;

public class CurrentConfigurations {
    private static final int UPDATE_INTERVAL_MS = 150;
    private final PluginPresetsCurrentConfigManager currentConfigManager;
    private List<PluginConfig> pluginConfigs;
    private Long lastUpdate = null;

    @Inject
    public CurrentConfigurations(PluginPresetsCurrentConfigManager currentConfigManager) {
        this.currentConfigManager = currentConfigManager;
    }

    public Boolean update() {
        boolean updated = false;
        Long timestamp = System.currentTimeMillis();
        if (this.lastUpdate == null || timestamp - this.lastUpdate > 150L) {
            this.setPluginConfigs(this.currentConfigManager.getCurrentConfigs());
            updated = true;
        }
        this.lastUpdate = timestamp;
        return updated;
    }

    public List<PluginConfig> getPluginConfigs() {
        return this.pluginConfigs;
    }

    public void setPluginConfigs(List<PluginConfig> pluginConfigs) {
        this.pluginConfigs = pluginConfigs;
    }
}

