/*
 * Decompiled with CFR 0.152.
 */
package com.worldheatmap;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import com.worldheatmap.Heatmap;
import com.worldheatmap.WorldHeatmapConfig;
import com.worldheatmap.WorldHeatmapPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="World Heatmap")
public class WorldHeatmapPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WorldHeatmapPlugin.class);
    private static final int OVERWORLD_MAX_X = 3904;
    private static final int OVERWORLD_MAX_Y = 4160;
    private static final int TYPE_A_HEATMAP_AUTOSAVE_FREQUENCY = 100;
    private static final int TYPE_B_HEATMAP_AUTOSAVE_FREQUENCY = 500;
    private static final int HEATMAP_OFFSET_X = -1152;
    private static final int HEATMAP_OFFSET_Y = -2496;
    private int lastX = 0;
    private int lastY = 0;
    private int lastStepCountA = 0;
    private int lastStepCountB = 0;
    protected final File WORLDHEATMAP_DIR = new File(RuneLite.RUNELITE_DIR.toString(), "worldheatmap");
    protected final String HEATMAP_FILES_DIR = Paths.get(this.WORLDHEATMAP_DIR.toString(), "Heatmap Files").toString();
    protected final String HEATMAP_IMAGE_DIR = Paths.get(this.WORLDHEATMAP_DIR.toString(), "Heatmap Images").toString();
    private final int HEATMAP_WIDTH = 2752;
    private final int HEATMAP_HEIGHT = 1664;
    protected Heatmap heatmapTypeA;
    protected Heatmap heatmapTypeB;
    private NavigationButton toolbarButton;
    private WorldHeatmapPanel panel;
    private boolean shouldLoadHeatmaps;
    private String mostRecentLocalUserName;
    private final float HEATMAP_TRANSPARENCY = 0.65f;
    @Inject
    private Client client;
    protected final Runnable LOAD_HEATMAP_FILES = () -> {
        String filepathTypeA = Paths.get(this.HEATMAP_FILES_DIR, this.client.getLocalPlayer().getName()) + "_TypeA.heatmap";
        String filepathTypeB = Paths.get(this.HEATMAP_FILES_DIR, this.client.getLocalPlayer().getName()) + "_TypeB.heatmap";
        this.heatmapTypeA = this.readHeatmapFile(filepathTypeA);
        this.heatmapTypeB = this.readHeatmapFile(filepathTypeB);
        this.panel.writeTypeAHeatmapImageButton.setEnabled(true);
        this.panel.writeTypeBHeatmapImageButton.setEnabled(true);
        this.panel.clearTypeAHeatmapButton.setEnabled(true);
        this.panel.clearTypeBHeatmapButton.setEnabled(true);
    };
    private Future loadHeatmapsFuture;
    private final Runnable SAVE_TYPE_A_HEATMAP = () -> {
        if (Strings.isNullOrEmpty((String)this.mostRecentLocalUserName)) {
            return;
        }
        log.info("Saving 'Type A' .heatmap to disk...");
        long startTime = System.nanoTime();
        String filepathTypeA = Paths.get(this.HEATMAP_FILES_DIR, this.mostRecentLocalUserName) + "_TypeA.heatmap";
        this.writeHeatmapFile(this.heatmapTypeA, filepathTypeA);
        log.info("Finished writing 'Type A' .heatmap to disk after " + (System.nanoTime() - startTime) / 1000000L + " ms");
    };
    private final Runnable SAVE_TYPE_B_HEATMAP = () -> {
        if (Strings.isNullOrEmpty((String)this.mostRecentLocalUserName)) {
            return;
        }
        log.info("Saving 'Type B' .heatmap to disk...");
        long startTime = System.nanoTime();
        String filepathTypeB = Paths.get(this.HEATMAP_FILES_DIR, this.mostRecentLocalUserName) + "_TypeB.heatmap";
        this.writeHeatmapFile(this.heatmapTypeB, filepathTypeB);
        log.info("Finished writing 'Type B' .heatmap to disk after " + (System.nanoTime() - startTime) / 1000000L + " ms");
    };
    protected final Runnable WRITE_TYPE_A_IMAGE = () -> {
        log.info("Saving 'Type A' heatmap image to disk...");
        long startTime = System.nanoTime();
        String filepathTypeA = Paths.get(this.HEATMAP_IMAGE_DIR, this.client.getLocalPlayer().getName() + "_TypeA").toString();
        this.writeHeatmapImage(this.heatmapTypeA, filepathTypeA, 0);
        log.info("Finished writing 'Type A' heatmap image to disk after " + (System.nanoTime() - startTime) / 1000000L + " ms");
    };
    protected final Runnable WRITE_TYPE_B_IMAGE = () -> {
        log.info("Saving 'Type B' heatmap image to disk...");
        long startTime = System.nanoTime();
        String filepathTypeB = Paths.get(this.HEATMAP_IMAGE_DIR, this.client.getLocalPlayer().getName() + "_TypeB").toString();
        this.writeHeatmapImage(this.heatmapTypeB, filepathTypeB, 1);
        log.info("Finished writing 'Type B' heatmap image to disk after " + (System.nanoTime() - startTime) / 1000000L + " ms");
    };
    protected final Runnable CLEAR_TYPE_A_HEATMAP = () -> {
        this.heatmapTypeA = new Heatmap(2752, 1664, -1152, -2496);
        log.info("Writing blank 'Type A' heatmap image to disk...");
        long startTime = System.nanoTime();
        String imageFilepathTypeA = Paths.get(this.HEATMAP_IMAGE_DIR, this.client.getLocalPlayer().getName() + "_TypeA").toString();
        this.writeHeatmapImage(this.heatmapTypeA, imageFilepathTypeA, 0);
        log.info("Finished writing blank 'Type B' heatmap image to disk after " + (System.nanoTime() - startTime) / 1000000L + " ms");
        String heatmapFilepathTypeA = Paths.get(this.HEATMAP_FILES_DIR, this.client.getLocalPlayer().getName()) + "_TypeA.heatmap";
        this.writeHeatmapFile(this.heatmapTypeA, heatmapFilepathTypeA);
    };
    protected final Runnable CLEAR_TYPE_B_HEATMAP = () -> {
        this.heatmapTypeB = new Heatmap(2752, 1664, -1152, -2496);
        log.info("Writing blank 'Type B' heatmap image to disk...");
        long startTime = System.nanoTime();
        String imageFilepathTypeB = Paths.get(this.HEATMAP_IMAGE_DIR, this.client.getLocalPlayer().getName() + "_TypeB").toString();
        this.writeHeatmapImage(this.heatmapTypeB, imageFilepathTypeB, 1);
        log.info("Finished writing blank 'Type B' heatmap image to disk after " + (System.nanoTime() - startTime) / 1000000L + " ms");
        String heatmapFilepathTypeB = Paths.get(this.HEATMAP_FILES_DIR, this.client.getLocalPlayer().getName()) + "_TypeB.heatmap";
        this.writeHeatmapFile(this.heatmapTypeB, heatmapFilepathTypeB);
    };
    private final Runnable WRITE_NEW_TYPE_A_BACKUP = () -> {
        String heatmapFilePathTypeA = Paths.get(this.HEATMAP_FILES_DIR, "Backups", this.client.getLocalPlayer().getName() + "-" + LocalDateTime.now() + "_TypeA.heatmap").toString();
        this.writeHeatmapFile(this.heatmapTypeA, heatmapFilePathTypeA);
        log.info("World Heatmap backup saved to " + heatmapFilePathTypeA);
    };
    private final Runnable WRITE_NEW_TYPE_B_BACKUP = () -> {
        String heatmapFilePathTypeB = Paths.get(this.HEATMAP_FILES_DIR, "Backups", this.client.getLocalPlayer().getName() + "-" + LocalDateTime.now() + "_TypeB.heatmap").toString();
        this.writeHeatmapFile(this.heatmapTypeB, heatmapFilePathTypeB);
        log.info("World Heatmap backup saved to " + heatmapFilePathTypeB);
    };
    @Inject
    protected ScheduledExecutorService executor;
    @Inject
    private WorldHeatmapConfig config;
    @Inject
    private ClientToolbar clientToolbar;

    @Provides
    WorldHeatmapConfig provideConfig(ConfigManager configManager) {
        return (WorldHeatmapConfig)configManager.getConfig(WorldHeatmapConfig.class);
    }

    protected void startUp() {
        this.shouldLoadHeatmaps = true;
        this.loadHeatmapsFuture = null;
        this.panel = new WorldHeatmapPanel(this);
        this.panel.rebuild();
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/WorldHeatmap.png");
        this.toolbarButton = NavigationButton.builder().tooltip("World Heatmap").icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.toolbarButton);
        this.panel.writeTypeAHeatmapImageButton.setEnabled(false);
        this.panel.writeTypeBHeatmapImageButton.setEnabled(false);
        this.panel.clearTypeAHeatmapButton.setEnabled(false);
        this.panel.clearTypeBHeatmapButton.setEnabled(false);
    }

    protected void shutDown() {
        if (this.loadHeatmapsFuture != null && this.loadHeatmapsFuture.isDone()) {
            this.executor.execute(this.SAVE_TYPE_A_HEATMAP);
            this.executor.execute(this.SAVE_TYPE_B_HEATMAP);
        }
        this.clientToolbar.removeNavigation(this.toolbarButton);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGING_IN) {
            this.shouldLoadHeatmaps = true;
            this.loadHeatmapsFuture = null;
        }
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN && this.loadHeatmapsFuture != null && this.loadHeatmapsFuture.isDone()) {
            this.executor.execute(this.SAVE_TYPE_A_HEATMAP);
            this.executor.execute(this.SAVE_TYPE_B_HEATMAP);
            this.loadHeatmapsFuture = null;
        }
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            this.panel.writeTypeAHeatmapImageButton.setEnabled(false);
            this.panel.writeTypeBHeatmapImageButton.setEnabled(false);
            this.panel.clearTypeAHeatmapButton.setEnabled(false);
            this.panel.clearTypeBHeatmapButton.setEnabled(false);
        }
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.panel.writeTypeAHeatmapImageButton.setEnabled(true);
            this.panel.writeTypeBHeatmapImageButton.setEnabled(true);
            this.panel.clearTypeAHeatmapButton.setEnabled(true);
            this.panel.clearTypeBHeatmapButton.setEnabled(true);
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        int currentY;
        int currentX;
        block20: {
            block19: {
                boolean largeStep;
                int diagDistance;
                if (this.shouldLoadHeatmaps && this.client.getGameState().equals((Object)GameState.LOGGED_IN) && !Strings.isNullOrEmpty((String)this.client.getLocalPlayer().getName())) {
                    this.shouldLoadHeatmaps = false;
                    this.loadHeatmapsFuture = this.executor.submit(this.LOAD_HEATMAP_FILES);
                }
                if (this.loadHeatmapsFuture != null && !this.loadHeatmapsFuture.isDone()) {
                    return;
                }
                WorldPoint currentCoords = this.client.getLocalPlayer().getWorldLocation();
                currentX = currentCoords.getX();
                currentY = currentCoords.getY();
                if (currentX < 3904 && currentY < 4160 && (currentX != this.lastX || currentY != this.lastY)) {
                    diagDistance = this.diagonalDistance(new int[]{this.lastX, this.lastY}, new int[]{currentX, currentY});
                    boolean bl = largeStep = diagDistance >= 5;
                    if (!largeStep) {
                        for (int[] tile : this.getPointsBetween(new int[]{this.lastX, this.lastY}, new int[]{currentX, currentY})) {
                            if (this.heatmapTypeA.isInBounds(tile[0], tile[1])) {
                                this.heatmapTypeA.increment(tile[0], tile[1]);
                                if (this.config.typeAImageAutosaveOnOff() && this.heatmapTypeA.getStepCount() % this.config.typeAImageAutosaveFrequency() == 0) {
                                    this.executor.execute(this.SAVE_TYPE_A_HEATMAP);
                                    this.executor.execute(this.WRITE_TYPE_A_IMAGE);
                                } else if (this.heatmapTypeA.getStepCount() % 100 == 0) {
                                    this.executor.execute(this.SAVE_TYPE_A_HEATMAP);
                                }
                                if (this.heatmapTypeA.getStepCount() % this.config.typeAHeatmapBackupFrequency() != 0) continue;
                                this.executor.execute(this.WRITE_NEW_TYPE_A_BACKUP);
                                continue;
                            }
                            log.error("World Heatmap: Coordinates out of bounds for heatmap matrix: (" + tile[0] + ", " + tile[1] + ")");
                        }
                    }
                }
                if (currentX < 3904 && currentY < 4160) {
                    diagDistance = this.diagonalDistance(new int[]{this.lastX, this.lastY}, new int[]{currentX, currentY});
                    boolean bl = largeStep = diagDistance >= 5;
                    if (!largeStep) {
                        for (int[] tile : this.getPointsBetween(new int[]{this.lastX, this.lastY}, new int[]{currentX, currentY})) {
                            if (this.heatmapTypeB.isInBounds(tile[0], tile[1])) {
                                this.heatmapTypeB.increment(tile[0], tile[1]);
                                if (this.config.typeBImageAutosaveOnOff() && this.heatmapTypeB.getStepCount() % this.config.typeBImageAutosaveFrequency() == 0) {
                                    this.executor.execute(this.SAVE_TYPE_B_HEATMAP);
                                    this.executor.execute(this.WRITE_TYPE_B_IMAGE);
                                } else if (this.heatmapTypeB.getStepCount() % 500 == 0) {
                                    this.executor.execute(this.SAVE_TYPE_B_HEATMAP);
                                }
                                if (this.heatmapTypeB.getStepCount() % this.config.typeBHeatmapBackupFrequency() != 0) continue;
                                this.executor.execute(this.WRITE_NEW_TYPE_B_BACKUP);
                                continue;
                            }
                            log.error("World Heatmap: Coordinates out of bounds for heatmap matrix: (" + tile[0] + ", " + tile[1] + ")");
                        }
                    }
                }
                if (this.heatmapTypeA.getStepCount() != this.lastStepCountA) break block19;
                if (this.heatmapTypeB.getStepCount() == this.lastStepCountB) break block20;
            }
            SwingUtilities.invokeLater(this.panel::updateCounts);
        }
        this.lastX = currentX;
        this.lastY = currentY;
        this.lastStepCountA = this.heatmapTypeA.getStepCount();
        this.lastStepCountB = this.heatmapTypeB.getStepCount();
        this.mostRecentLocalUserName = this.client.getLocalPlayer().getName();
    }

    private int[][] getPointsBetween(int[] p0, int[] p1) {
        if (Arrays.equals(p0, p1)) {
            return new int[][]{p1};
        }
        int N = this.diagonalDistance(p0, p1);
        int[][] points = new int[N][2];
        for (int step = 1; step <= N; ++step) {
            float t = (float)step / (float)N;
            points[step - 1] = this.roundPoint(this.lerp_point(p0, p1, t));
        }
        return points;
    }

    private int diagonalDistance(int[] p0, int[] p1) {
        int dx = Math.abs(p1[0] - p0[0]);
        int dy = Math.abs(p1[1] - p0[1]);
        return Math.max(dx, dy);
    }

    private int[] roundPoint(float[] point) {
        return new int[]{Math.round(point[0]), Math.round(point[1])};
    }

    private float[] lerp_point(int[] p0, int[] p1, float t) {
        return new float[]{this.lerp(p0[0], p1[0], t), this.lerp(p0[1], p1[1], t)};
    }

    private float lerp(int p0, int p1, float t) {
        return (float)p0 + (float)(p1 - p0) * t;
    }

    private Heatmap readHeatmapFile(String filepath) {
        log.info("Loading heatmap file '" + filepath + "'");
        File heatmapFile = new File(filepath);
        if (heatmapFile.exists()) {
            Heatmap heatmap;
            FileInputStream fis = new FileInputStream(filepath);
            try {
                InflaterInputStream inflaterIn = new InflaterInputStream(fis);
                ObjectInputStream ois = new ObjectInputStream(inflaterIn);
                heatmap = (Heatmap)ois.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info("World Heatmap was not able to load existing heatmap file, for some reason, so a new blank one was loaded");
                    return new Heatmap(2752, 1664, -1152, -2496);
                }
            }
            fis.close();
            return heatmap;
        }
        log.info("Worldheatmap file " + filepath + " did not exist when read. A new heatmap will be made.");
        return new Heatmap(2752, 1664, -1152, -2496);
    }

    protected void writeHeatmapFile(Heatmap heatmap, String filename) {
        File file = new File(filename);
        if (!Files.exists(Paths.get(file.getParent(), new String[0]), new LinkOption[0])) {
            new File(file.getParent()).mkdirs();
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            DeflaterOutputStream dos = new DeflaterOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(dos);
            oos.writeObject(heatmap);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("World Heatmap was not able to save heatmap file");
        }
    }

    private void writeHeatmapImage(Heatmap heatmap, String fileName, int heatmapType) {
        int[] maxValAndCoords = heatmap.getMaxVal();
        int maxVal = maxValAndCoords[0];
        int maxX = maxValAndCoords[1];
        int maxY = maxValAndCoords[2];
        log.debug("Maximum steps on a tile is: " + maxVal + " at (" + maxX + ", " + maxY + "), for " + fileName);
        int[] minValAndCoords = heatmap.getMinVal();
        int minVal = minValAndCoords[0];
        int minX = minValAndCoords[1];
        int minY = minValAndCoords[2];
        log.debug("Minimum steps on a tile is: " + minVal + " at (" + minX + ", " + minY + "), for " + fileName);
        maxVal = maxVal == minVal ? maxVal + 1 : maxVal;
        try {
            BufferedImage worldMapImage = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/osrs_world_map.png");
            BufferedImage heatmapOverlay = new BufferedImage(worldMapImage.getWidth(), worldMapImage.getHeight(), 2);
            if (worldMapImage.getWidth() != 8256 || worldMapImage.getHeight() != 4992) {
                log.error("The file 'osrs_world_map.png' must have dimensions 8256 x 4992");
                return;
            }
            int currRGB = 0;
            float currStepValue = 0.0f;
            float currHue = 0.0f;
            for (int y = 0; y < 1664; ++y) {
                for (int x = 0; x < 2752; ++x) {
                    int invertedY = 1664 - y - 1;
                    if (heatmap.heatmapCoordsGet(x, invertedY) == 0) continue;
                    if (heatmapType == 0) {
                        currStepValue = ((float)heatmap.heatmapCoordsGet(x, invertedY) - (float)minVal) / (float)(maxVal - minVal);
                        currHue = (float)(0.333 - (double)currStepValue * 0.333);
                    }
                    if (heatmapType == 1) {
                        int normalizedMin = 0;
                        int normalizedMax = 1;
                        currStepValue = (float)(Math.log(heatmap.heatmapCoordsGet(x, invertedY) + 1 - minVal) / Math.log(maxVal + 1 - minVal));
                        currStepValue = currStepValue > 1.0f ? 1.0f : currStepValue;
                        float normalized = currStepValue * (float)(normalizedMax - normalizedMin);
                        currHue = (float)(0.333 - (double)normalized * 0.333);
                    }
                    currRGB = Color.HSBtoRGB(currHue, 1.0f, 1.0f);
                    heatmapOverlay.setRGB(x * 3 + 0, y * 3 + 0, currRGB);
                    heatmapOverlay.setRGB(x * 3 + 0, y * 3 + 1, currRGB);
                    heatmapOverlay.setRGB(x * 3 + 0, y * 3 + 2, currRGB);
                    heatmapOverlay.setRGB(x * 3 + 1, y * 3 + 0, currRGB);
                    heatmapOverlay.setRGB(x * 3 + 1, y * 3 + 1, currRGB);
                    heatmapOverlay.setRGB(x * 3 + 1, y * 3 + 2, currRGB);
                    heatmapOverlay.setRGB(x * 3 + 2, y * 3 + 0, currRGB);
                    heatmapOverlay.setRGB(x * 3 + 2, y * 3 + 1, currRGB);
                    heatmapOverlay.setRGB(x * 3 + 2, y * 3 + 2, currRGB);
                }
            }
            File heatmapImageFile = new File(fileName);
            if (!Files.exists(Paths.get(heatmapImageFile.getParent(), new String[0]), new LinkOption[0])) {
                new File(heatmapImageFile.getParent()).mkdirs();
            }
            Graphics2D graphics = worldMapImage.createGraphics();
            AlphaComposite alphaChannel = AlphaComposite.getInstance(3, 0.65f);
            graphics.setComposite(alphaChannel);
            graphics.drawImage((Image)heatmapOverlay, 0, 0, null);
            graphics.dispose();
            ImageIO.write((RenderedImage)worldMapImage, "png", heatmapImageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Exception thrown whilst creating and/or writing image file.");
        }
    }
}

