/*
 * Decompiled with CFR 0.152.
 */
package com.worldheatmap;

import com.worldheatmap.WorldHeatmapPlugin;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;

public class WorldHeatmapPanel
extends PluginPanel {
    private final WorldHeatmapPlugin plugin;
    private JLabel typeACountLabel;
    private JLabel typeBCountLabel;
    protected JButton writeTypeAHeatmapImageButton;
    protected JButton writeTypeBHeatmapImageButton;
    protected JButton clearTypeAHeatmapButton;
    protected JButton clearTypeBHeatmapButton;

    public WorldHeatmapPanel(WorldHeatmapPlugin plugin) {
        this.plugin = plugin;
        this.rebuild();
    }

    protected void rebuild() {
        this.removeAll();
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        mainPanel.setBorder(new EmptyBorder(8, 0, 10, 0));
        JButton openHeatmapFolderButton = new JButton("Open Heatmaps Folder");
        openHeatmapFolderButton.setFont(new Font(openHeatmapFolderButton.getFont().getName(), 1, 18));
        openHeatmapFolderButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    WorldHeatmapPanel.this.openHeatmapsFolder();
                }
                catch (IOException heatmapsIOError) {
                    heatmapsIOError.printStackTrace();
                }
            }
        });
        mainPanel.add(openHeatmapFolderButton);
        this.add(mainPanel);
        JPanel typeAPanel = new JPanel();
        typeAPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        typeAPanel.setBorder(new EmptyBorder(8, 0, 76, 0));
        typeAPanel.add(new JLabel("Heatmap Type A"));
        this.writeTypeAHeatmapImageButton = new JButton("Write Heatmap Image");
        this.writeTypeAHeatmapImageButton.setFont(new Font(this.writeTypeAHeatmapImageButton.getFont().getName(), 1, 18));
        this.writeTypeAHeatmapImageButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                WorldHeatmapPanel.this.writeTypeAHeatmapImage();
            }
        });
        typeAPanel.add(this.writeTypeAHeatmapImageButton);
        this.clearTypeAHeatmapButton = new JButton("Restart Heatmap");
        this.clearTypeAHeatmapButton.setFont(new Font(openHeatmapFolderButton.getFont().getName(), 1, 18));
        this.clearTypeAHeatmapButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                WorldHeatmapPanel.this.clearTypeAHeatmap();
            }
        });
        typeAPanel.add(this.clearTypeAHeatmapButton);
        this.typeACountLabel = new JLabel();
        typeAPanel.add(this.typeACountLabel);
        this.add(typeAPanel);
        JPanel typeBPanel = new JPanel();
        typeBPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        typeBPanel.setBorder(new EmptyBorder(8, 0, 76, 0));
        typeBPanel.add(new JLabel("Heatmap Type B"));
        this.writeTypeBHeatmapImageButton = new JButton("Write Heatmap Image");
        this.writeTypeBHeatmapImageButton.setFont(new Font(this.writeTypeBHeatmapImageButton.getFont().getName(), 1, 18));
        this.writeTypeBHeatmapImageButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                WorldHeatmapPanel.this.writeTypeBHeatmapImage();
            }
        });
        typeBPanel.add(this.writeTypeBHeatmapImageButton);
        this.clearTypeBHeatmapButton = new JButton("Restart Heatmap");
        this.clearTypeBHeatmapButton.setFont(new Font(openHeatmapFolderButton.getFont().getName(), 1, 18));
        this.clearTypeBHeatmapButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                WorldHeatmapPanel.this.clearTypeBHeatmap();
            }
        });
        typeBPanel.add(this.clearTypeBHeatmapButton);
        this.typeBCountLabel = new JLabel();
        typeBPanel.add(this.typeBCountLabel);
        this.add(typeBPanel);
    }

    protected void updateCounts() {
        if (this.plugin.heatmapTypeA != null) {
            this.typeACountLabel.setText("Step count: " + this.plugin.heatmapTypeA.getStepCount());
        } else {
            this.typeACountLabel.setText("");
        }
        if (this.plugin.heatmapTypeB != null) {
            this.typeBCountLabel.setText("Step count: " + this.plugin.heatmapTypeB.getStepCount());
        } else {
            this.typeBCountLabel.setText("");
        }
        this.updateUI();
    }

    private void writeTypeAHeatmapImage() {
        this.plugin.executor.execute(this.plugin.WRITE_TYPE_A_IMAGE);
    }

    private void clearTypeAHeatmap() {
        this.plugin.executor.execute(this.plugin.CLEAR_TYPE_A_HEATMAP);
    }

    private void writeTypeBHeatmapImage() {
        this.plugin.executor.execute(this.plugin.WRITE_TYPE_B_IMAGE);
    }

    private void clearTypeBHeatmap() {
        this.plugin.executor.execute(this.plugin.CLEAR_TYPE_B_HEATMAP);
    }

    private void openHeatmapsFolder() throws IOException {
        if (!this.plugin.WORLDHEATMAP_DIR.exists()) {
            this.plugin.WORLDHEATMAP_DIR.mkdirs();
        }
        Desktop.getDesktop().open(this.plugin.WORLDHEATMAP_DIR);
    }
}

