/*
 * Decompiled with CFR 0.152.
 */
package com.worldheatmap;

import java.io.Serializable;

public class Heatmap
implements Serializable {
    private final int WIDTH;
    private final int HEIGHT;
    private final int HEATMAP_OFFSET_X;
    private final int HEATMAP_OFFSET_Y;
    protected static final int TYPE_A = 0;
    protected static final int TYPE_B = 1;
    private int[][] heatmap;
    private int stepCount;

    public Heatmap(int WIDTH, int HEIGHT, int HEATMAP_OFFSET_X, int HEATMAP_OFFSET_Y) {
        this.WIDTH = WIDTH;
        this.HEIGHT = HEIGHT;
        this.HEATMAP_OFFSET_Y = HEATMAP_OFFSET_Y;
        this.HEATMAP_OFFSET_X = HEATMAP_OFFSET_X;
        this.stepCount = 0;
        this.createHeatmap();
    }

    private void createHeatmap() {
        this.heatmap = new int[this.WIDTH][this.HEIGHT];
    }

    protected boolean isInBounds(int x, int y) {
        return x + this.HEATMAP_OFFSET_X < this.WIDTH && y + this.HEATMAP_OFFSET_Y < this.HEIGHT;
    }

    protected void set(int val, int x, int y) {
        int convertedX = x + this.HEATMAP_OFFSET_X;
        int convertedY = y + this.HEATMAP_OFFSET_Y;
        this.heatmap[convertedX][convertedY] = val;
    }

    protected int get(int x, int y) {
        int convertedX = x + this.HEATMAP_OFFSET_X;
        int convertedY = y + this.HEATMAP_OFFSET_Y;
        return this.heatmap[convertedX][convertedY];
    }

    protected int heatmapCoordsGet(int x, int y) {
        return this.heatmap[x][y];
    }

    protected void increment(int x, int y) {
        this.set(this.get(x, y) + 1, x, y);
        ++this.stepCount;
    }

    protected int getStepCount() {
        return this.stepCount;
    }

    protected int[] getMaxVal() {
        int maxVal = 0;
        int maxX = 0;
        int maxY = 0;
        for (int y = 0; y < this.HEIGHT; ++y) {
            for (int x = 0; x < this.WIDTH; ++x) {
                if (this.heatmapCoordsGet(x, y) <= maxVal) continue;
                maxVal = this.heatmapCoordsGet(x, y);
                maxX = x;
                maxY = y;
            }
        }
        return new int[]{maxVal, maxX, maxY};
    }

    protected int[] getMinVal() {
        int minVal = Integer.MAX_VALUE;
        int minX = 0;
        int minY = 0;
        for (int y = 0; y < this.HEIGHT; ++y) {
            for (int x = 0; x < this.WIDTH; ++x) {
                if (this.heatmapCoordsGet(x, y) == 0 || this.heatmapCoordsGet(x, y) >= minVal) continue;
                minVal = this.heatmapCoordsGet(x, y);
                minX = x;
                minY = y;
            }
        }
        if (minVal > 2147483547) {
            return new int[]{0, 0, 0};
        }
        return new int[]{minVal, minX, minY};
    }
}

