/*
 * Decompiled with CFR 0.152.
 */
package com.linemarkers;

import com.google.inject.Inject;
import com.linemarkers.Edge;
import com.linemarkers.Line;
import com.linemarkers.LineGroup;
import com.linemarkers.LineMarkerPlugin;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

class LineMarkerSceneOverlay
extends Overlay {
    private static final int LOCAL_TILE_SIZE = 128;
    private static final int MAX_DISTANCE = 26;
    private final Client client;
    private final LineMarkerPlugin plugin;

    @Inject
    private LineMarkerSceneOverlay(Client client, LineMarkerPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        for (LineGroup group : this.plugin.getMarkers()) {
            if (!group.isVisible()) continue;
            for (Line line : group.getLines()) {
                if (line.getLocation().getPlane() != this.client.getPlane()) continue;
                this.drawLine(graphics, line);
            }
        }
        return null;
    }

    private void drawLine(Graphics2D graphics, Line line) {
        if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getWorldLocation().distanceTo(line.getLocation()) > 26) {
            return;
        }
        Point start = this.worldToScene(Edge.start(line));
        Point end = this.worldToScene(Edge.end(line));
        if (start == null || end == null) {
            return;
        }
        graphics.setColor(line.getColour());
        graphics.setStroke(new BasicStroke((float)line.getWidth()));
        graphics.drawLine(start.getX(), start.getY(), end.getX(), end.getY());
    }

    private Point worldToScene(WorldPoint location) {
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)location);
        if (localPoint == null) {
            return null;
        }
        return Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() - 64), (int)location.getPlane());
    }
}

