/*
 * Decompiled with CFR 0.152.
 */
package com.linemarkers;

import com.linemarkers.Filter;
import com.linemarkers.LineGroup;
import com.linemarkers.LineMarkerConfig;
import com.linemarkers.LineMarkerPanel;
import com.linemarkers.LineMarkerPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Comparator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;

class LineMarkerPluginPanel
extends PluginPanel {
    private static final ImageIcon COPY_ICON;
    private static final ImageIcon COPY_HOVER_ICON;
    private static final ImageIcon PASTE_ICON;
    private static final ImageIcon PASTE_HOVER_ICON;
    private static final ImageIcon[] FILTER_ICONS;
    private static final String[] FILTER_TEXT;
    private static final String[] FILTER_DESCRIPTIONS;
    private final JLabel copyMarkers = new JLabel(COPY_ICON);
    private final JLabel pasteMarkers = new JLabel(PASTE_ICON);
    private final JLabel filterButton = new JLabel(FILTER_ICONS[0]);
    private final IconTextField searchBar = new IconTextField();
    private final PluginErrorPanel noMarkersPanel = new PluginErrorPanel();
    private final JPanel markerView = new JPanel();
    private final JPanel searchPanel = new JPanel(new BorderLayout());
    private final Client client;
    private final LineMarkerPlugin plugin;
    private final LineMarkerConfig config;
    private Filter filter = Filter.ALL;

    public LineMarkerPluginPanel(Client client, LineMarkerPlugin plugin, LineMarkerConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(1, 0, 10, 0));
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(new EmptyBorder(1, 3, 10, 7));
        JPanel markerButtons = new JPanel(new FlowLayout(2, 7, 3));
        this.searchPanel.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARKER_GRAY_HOVER_COLOR);
        this.searchBar.setPreferredSize(new Dimension(182 - this.filterButton.getWidth(), 24));
        this.searchBar.addActionListener(e -> this.rebuild());
        this.searchBar.addClearListener(this::rebuild);
        this.searchBar.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    LineMarkerPluginPanel.this.searchBar.setText("");
                    LineMarkerPluginPanel.this.rebuild();
                }
            }
        });
        this.filterButton.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.filterButton.setOpaque(true);
        this.filterButton.setPreferredSize(new Dimension(28, 24));
        this.filterButton.setText(FILTER_TEXT[0]);
        this.filterButton.setToolTipText(FILTER_DESCRIPTIONS[0]);
        this.filterButton.setHorizontalTextPosition(0);
        this.filterButton.setFont(FontManager.getRunescapeSmallFont());
        this.filterButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LineMarkerPluginPanel.this.filter = LineMarkerPluginPanel.this.filter.next();
                LineMarkerPluginPanel.this.filterButton.setText(FILTER_TEXT[LineMarkerPluginPanel.this.filter.ordinal()]);
                LineMarkerPluginPanel.this.filterButton.setIcon(FILTER_ICONS[LineMarkerPluginPanel.this.filter.ordinal()]);
                LineMarkerPluginPanel.this.filterButton.setToolTipText(FILTER_DESCRIPTIONS[LineMarkerPluginPanel.this.filter.ordinal()]);
                LineMarkerPluginPanel.this.rebuild();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LineMarkerPluginPanel.this.filterButton.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LineMarkerPluginPanel.this.filterButton.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }
        });
        JLabel title = new JLabel();
        title.setText("Line Markers");
        title.setForeground(Color.WHITE);
        titlePanel.add((Component)title, "West");
        titlePanel.add((Component)markerButtons, "East");
        this.searchPanel.add((Component)this.searchBar, "West");
        this.searchPanel.add((Component)this.filterButton, "East");
        northPanel.add((Component)titlePanel, "North");
        northPanel.add((Component)this.searchPanel, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.markerView.setLayout(new BoxLayout(this.markerView, 1));
        this.markerView.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.noMarkersPanel.setVisible(false);
        this.markerView.add((Component)this.noMarkersPanel);
        this.copyMarkers.setToolTipText("Export all searched or filtered markers to your clipboard");
        this.copyMarkers.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LineMarkerPluginPanel.this.copyMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LineMarkerPluginPanel.this.copyMarkers.setIcon(COPY_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LineMarkerPluginPanel.this.copyMarkers.setIcon(COPY_ICON);
            }
        });
        this.pasteMarkers.setToolTipText("Import markers from your clipboard");
        this.pasteMarkers.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LineMarkerPluginPanel.this.pasteMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LineMarkerPluginPanel.this.pasteMarkers.setIcon(PASTE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LineMarkerPluginPanel.this.pasteMarkers.setIcon(PASTE_ICON);
            }
        });
        markerButtons.add(this.pasteMarkers);
        markerButtons.add(this.copyMarkers);
        centerPanel.add((Component)this.markerView, "North");
        this.add(northPanel, "North");
        this.add(centerPanel, "Center");
    }

    public void rebuild() {
        this.markerView.removeAll();
        int regionId = this.client.getLocalPlayer() == null ? -1 : this.client.getLocalPlayer().getWorldLocation().getRegionID();
        this.plugin.getGroups().sort(Comparator.comparing(LineGroup::getName));
        for (LineGroup group : this.plugin.getGroups()) {
            if (!group.getName().toLowerCase().contains(this.getSearchText().toLowerCase()) || !(Filter.ALL.equals((Object)this.filter) || Filter.REGION.equals((Object)this.filter) && this.plugin.anyLineInRegion(group.getLines(), regionId) || Filter.VISIBLE.equals((Object)this.filter) && group.isVisible()) && (!Filter.INVISIBLE.equals((Object)this.filter) || group.isVisible())) continue;
            this.markerView.add(new LineMarkerPanel(this.plugin, this.config, group));
            this.markerView.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        boolean empty = this.markerView.getComponentCount() == 0;
        this.noMarkersPanel.setContent("Line Markers", "Shift right-click a tile to add a line marker.");
        this.noMarkersPanel.setVisible(empty);
        this.searchPanel.setVisible(!empty);
        if (empty && this.plugin.getGroups().size() > 0) {
            this.noMarkersPanel.setContent("Line Markers", "No line markers are available for the current search term and/or selected filter.");
            this.searchPanel.setVisible(true);
        }
        this.markerView.add((Component)this.noMarkersPanel);
        this.repaint();
        this.revalidate();
    }

    public String getSearchText() {
        return this.searchBar.getText();
    }

    private void copyMarkers() {
        if (this.plugin.copyMarkers() != null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.plugin.copyMarkers()), null);
        }
    }

    private void pasteMarkers() {
        String clipboardText;
        try {
            clipboardText = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException | IOException ignore) {
            return;
        }
        if (this.plugin.pasteMarkers(clipboardText)) {
            this.noMarkersPanel.setVisible(false);
            this.searchPanel.setVisible(true);
            this.rebuild();
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    static {
        FILTER_TEXT = new String[]{"ALL", "R", "", ""};
        BufferedImage copyIcon = ImageUtil.loadImageResource(LineMarkerPlugin.class, (String)"copy_icon.png");
        COPY_ICON = new ImageIcon(copyIcon);
        COPY_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)copyIcon, (float)0.53f));
        BufferedImage pasteIcon = ImageUtil.loadImageResource(LineMarkerPlugin.class, (String)"paste_icon.png");
        PASTE_ICON = new ImageIcon(pasteIcon);
        PASTE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)pasteIcon, (float)0.53f));
        BufferedImage visibleImg = ImageUtil.loadImageResource(LineMarkerPlugin.class, (String)"visible_icon.png");
        BufferedImage invisibleImg = ImageUtil.loadImageResource(LineMarkerPlugin.class, (String)"invisible_icon.png");
        BufferedImage regionIcon = ImageUtil.loadImageResource(LineMarkerPlugin.class, (String)"region_icon.png");
        FILTER_ICONS = new ImageIcon[]{new ImageIcon(ImageUtil.alphaOffset((Image)visibleImg, (float)0.0f)), new ImageIcon(regionIcon), new ImageIcon(visibleImg), new ImageIcon(invisibleImg)};
        FILTER_DESCRIPTIONS = new String[]{"<html>Filter:<br>Listing all markers</html>", "<html>Filter:<br>Listing only markers in the current region</html>", "<html>Filter:<br>Listing only visible markers</html>", "<html>Filter:<br>Listing only hidden markers</html>"};
    }
}

