/*
 * Decompiled with CFR 0.152.
 */
package com.linemarkers;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.linemarkers.Filter;
import com.linemarkers.Line;
import com.linemarkers.LineGroup;
import com.linemarkers.LineMarkerConfig;
import com.linemarkers.LineMarkerMapOverlay;
import com.linemarkers.LineMarkerMinimapOverlay;
import com.linemarkers.LineMarkerPluginPanel;
import com.linemarkers.LineMarkerSceneOverlay;
import java.awt.Component;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseManager;
import net.runelite.client.input.MouseWheelListener;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Line Markers", description="Draw lines on tiles", tags={"line", "tile", "edge", "ground", "marker"})
public class LineMarkerPlugin
extends Plugin {
    public static final String CONFIG_GROUP = "linemarkers";
    private static final String CONFIG_KEY = "markers";
    private static final String PLUGIN_NAME = "Line Markers";
    private static final String ICON_FILE = "panel_icon.png";
    private static final String DEFAULT_MARKER_NAME = "Marker";
    private static final String ADD_LINE = "Add line";
    private static final String REMOVE_LINE = "Remove line";
    private List<LineGroup> groups = new ArrayList<LineGroup>();
    private List<LineGroup> markers = new ArrayList<LineGroup>();
    @Inject
    private Client client;
    @Inject
    private LineMarkerConfig config;
    @Inject
    private LineMarkerMapOverlay mapOverlay;
    @Inject
    private LineMarkerSceneOverlay sceneOverlay;
    @Inject
    private LineMarkerMinimapOverlay minimapOverlay;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Gson gson;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private ColorPickerManager colourPickerManager;
    private LineMarkerPluginPanel pluginPanel;
    private NavigationButton navigationButton;
    private BufferedImage minimapSpriteFixed;
    private BufferedImage minimapSpriteResizeable;
    private Shape minimapClipFixed;
    private Shape minimapClipResizeable;
    private Rectangle minimapRectangle = new Rectangle();
    private LineGroup lastGroup = null;
    private Line lastLine = null;
    private boolean isHotkeyPressed = false;
    private KeyListener keyListener = new KeyListener(){

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 16) {
                LineMarkerPlugin.this.isHotkeyPressed = true;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 16) {
                LineMarkerPlugin.this.lastLine = null;
                LineMarkerPlugin.this.lastGroup = null;
                LineMarkerPlugin.this.isHotkeyPressed = false;
            }
        }
    };
    private MouseWheelListener mouseWheelListener = event -> {
        if (this.isHotkeyPressed && this.lastLine != null) {
            if (event.getWheelRotation() > 0) {
                this.lastLine.setEdge(this.lastLine.getEdge().next());
            } else {
                this.lastLine.setEdge(this.lastLine.getEdge().next().next().next());
            }
            event.consume();
            this.saveMarkers();
            this.revalidate();
        }
        return event;
    };

    @Provides
    LineMarkerConfig providesConfig(ConfigManager configManager) {
        return (LineMarkerConfig)configManager.getConfig(LineMarkerConfig.class);
    }

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener(this.keyListener);
        this.mouseManager.registerMouseWheelListener(this.mouseWheelListener);
        this.overlayManager.add((Overlay)this.mapOverlay);
        this.overlayManager.add((Overlay)this.sceneOverlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.loadMarkers();
        this.pluginPanel = new LineMarkerPluginPanel(this.client, this, this.config);
        this.pluginPanel.rebuild();
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)ICON_FILE);
        this.navigationButton = NavigationButton.builder().tooltip(PLUGIN_NAME).icon(icon).priority(5).panel((PluginPanel)this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener(this.keyListener);
        this.mouseManager.unregisterMouseWheelListener(this.mouseWheelListener);
        this.overlayManager.remove((Overlay)this.mapOverlay);
        this.overlayManager.remove((Overlay)this.sceneOverlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.groups.clear();
        this.markers.clear();
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.pluginPanel = null;
        this.navigationButton = null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (!GameState.LOGGED_IN.equals((Object)event.getGameState()) || !this.client.isInInstancedRegion()) {
            return;
        }
        this.mirrorMarkers();
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.isHotkeyPressed && MenuAction.WALK.getId() == event.getType()) {
            this.client.createMenuEntry(1).setOption(ADD_LINE).setTarget(event.getTarget()).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(this::addMarker);
            Line line = this.getLineOnTile();
            if (line != null) {
                this.client.createMenuEntry(1).setOption(REMOVE_LINE).setTarget(event.getTarget()).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(e -> this.removeMarker(line));
            }
        }
    }

    private void addMarker(MenuEntry entry) {
        Tile tile = this.client.getSelectedSceneTile();
        if (tile == null) {
            return;
        }
        this.lastLine = new Line(this.config, WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)tile.getLocalLocation()));
        if (this.lastGroup == null) {
            this.lastGroup = new LineGroup("Marker " + (this.groups.size() + 1), this.lastLine);
            this.groups.add(this.lastGroup);
        } else {
            this.lastGroup.getLines().add(this.lastLine);
        }
        this.saveMarkers();
        this.rebuild();
    }

    private void loadMarkers() {
        this.groups.clear();
        this.markers.clear();
        String json = this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY);
        if (Strings.isNullOrEmpty((String)json)) {
            return;
        }
        try {
            List loaded = (List)this.gson.fromJson(json, new TypeToken<ArrayList<LineGroup>>(){}.getType());
            loaded.removeIf(LineGroup::isInvalid);
            this.groups.addAll(loaded);
            this.mirrorMarkers();
        }
        catch (JsonSyntaxException | IllegalStateException ignore) {
            JOptionPane.showConfirmDialog((Component)((Object)this.pluginPanel), "The line markers you are trying to load from your config are malformed", "Warning", 2);
        }
    }

    public void saveMarkers() {
        if (this.groups == null || this.groups.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY);
            return;
        }
        String json = this.gson.toJson(this.groups);
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY, json);
        this.mirrorMarkers();
    }

    private void mirrorMarkers() {
        this.markers = LineGroup.instances(this.client, this.groups);
    }

    public String copyMarkers() {
        ArrayList<LineGroup> markersCopy = new ArrayList<LineGroup>();
        int regionId = this.client.getLocalPlayer() == null ? -1 : this.client.getLocalPlayer().getWorldLocation().getRegionID();
        String searchTerm = this.pluginPanel.getSearchText().toLowerCase();
        Filter filter = this.pluginPanel.getFilter();
        for (LineGroup group : this.groups) {
            if (!group.getName().toLowerCase().contains(searchTerm) || !(Filter.ALL.equals((Object)filter) || Filter.REGION.equals((Object)filter) && this.anyLineInRegion(group.getLines(), regionId) || Filter.VISIBLE.equals((Object)filter) && group.isVisible()) && (!Filter.INVISIBLE.equals((Object)filter) || group.isVisible())) continue;
            markersCopy.add(group);
        }
        if (markersCopy.isEmpty()) {
            return null;
        }
        return this.gson.toJson(markersCopy);
    }

    public boolean pasteMarkers(String json) {
        List markers;
        if (Strings.isNullOrEmpty((String)json)) {
            return false;
        }
        try {
            markers = (List)this.gson.fromJson(json, new TypeToken<ArrayList<LineGroup>>(){}.getType());
        }
        catch (JsonSyntaxException | IllegalStateException ignore) {
            JOptionPane.showConfirmDialog((Component)((Object)this.pluginPanel), "The line markers you are trying to import are malformed", "Warning", 2);
            return false;
        }
        markers.removeIf(group -> LineGroup.isInvalid(group) || this.groups.contains(group));
        this.groups.addAll(markers);
        this.saveMarkers();
        return true;
    }

    public boolean anyLineInRegion(List<Line> lines, int regionId) {
        for (Line line : lines) {
            if (line.getLocation().getRegionID() != regionId) continue;
            return true;
        }
        return false;
    }

    private Line getLineOnTile() {
        Tile tile = this.client.getSelectedSceneTile();
        if (tile == null) {
            return null;
        }
        for (LineGroup group : this.groups) {
            for (Line line : group.getLines()) {
                if (!line.getLocation().equals((Object)tile.getWorldLocation())) continue;
                return line;
            }
        }
        return null;
    }

    private Polygon bufferedImageToPolygon(BufferedImage image) {
        int outsideColour = -1;
        int width = image.getWidth();
        int height = image.getHeight();
        ArrayList<Point> points = new ArrayList<Point>();
        for (int y = 0; y < height; ++y) {
            int previousColour = outsideColour;
            for (int x = 0; x < width; ++x) {
                int colour = image.getRGB(x, y);
                if (x == 0 && y == 0) {
                    outsideColour = colour;
                    previousColour = colour;
                }
                if (colour != outsideColour && previousColour == outsideColour) {
                    points.add(new Point(x, y));
                }
                if ((colour == outsideColour || x == width - 1) && previousColour != outsideColour) {
                    points.add(0, new Point(x, y));
                }
                previousColour = colour;
            }
        }
        int offsetX = 0;
        int offsetY = 0;
        Widget minimapDrawWidget = this.getMinimapDrawWidget();
        if (minimapDrawWidget != null) {
            offsetX = minimapDrawWidget.getBounds().x;
            offsetY = minimapDrawWidget.getBounds().y;
        }
        Polygon polygon = new Polygon();
        for (Point point : points) {
            polygon.addPoint(point.x + offsetX, point.y + offsetY);
        }
        return polygon;
    }

    private Shape getMinimapClipAreaSimple() {
        Widget minimapDrawArea = this.getMinimapDrawWidget();
        if (minimapDrawArea == null || minimapDrawArea.isHidden()) {
            return null;
        }
        Rectangle bounds = minimapDrawArea.getBounds();
        return new Ellipse2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public void removeMarker(Line line) {
        for (LineGroup group : this.groups) {
            group.getLines().remove(line);
            if (!group.getLines().isEmpty()) continue;
            this.groups.remove(group);
            break;
        }
        this.saveMarkers();
        this.rebuild();
    }

    public void removeMarker(LineGroup group) {
        this.groups.remove(group);
        this.saveMarkers();
        this.rebuild();
    }

    public void rebuild() {
        SwingUtilities.invokeLater(() -> this.pluginPanel.rebuild());
    }

    public void revalidate() {
        SwingUtilities.invokeLater(() -> this.pluginPanel.revalidate());
    }

    public Shape getMinimapClipArea() {
        Widget minimapWidget = this.getMinimapDrawWidget();
        if (minimapWidget == null || minimapWidget.isHidden() || !(this.minimapRectangle = minimapWidget.getBounds()).equals(this.minimapRectangle)) {
            this.minimapClipFixed = null;
            this.minimapClipResizeable = null;
            this.minimapSpriteFixed = null;
            this.minimapSpriteResizeable = null;
        }
        if (this.client.isResized()) {
            if (this.minimapClipResizeable != null) {
                return this.minimapClipResizeable;
            }
            if (this.minimapSpriteResizeable == null) {
                this.minimapSpriteResizeable = this.spriteManager.getSprite(1178, 0);
            }
            if (this.minimapSpriteResizeable != null) {
                this.minimapClipResizeable = this.bufferedImageToPolygon(this.minimapSpriteResizeable);
                return this.minimapClipResizeable;
            }
            return this.getMinimapClipAreaSimple();
        }
        if (this.minimapClipFixed != null) {
            return this.minimapClipFixed;
        }
        if (this.minimapSpriteFixed == null) {
            this.minimapSpriteFixed = this.spriteManager.getSprite(1183, 0);
        }
        if (this.minimapSpriteFixed != null) {
            this.minimapClipFixed = this.bufferedImageToPolygon(this.minimapSpriteFixed);
            return this.minimapClipFixed;
        }
        return this.getMinimapClipAreaSimple();
    }

    public Widget getMinimapDrawWidget() {
        if (this.client.isResized()) {
            if (this.client.getVarbitValue(4607) == 1) {
                return this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA);
            }
            return this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA);
        }
        return this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
    }

    List<LineGroup> getGroups() {
        return this.groups;
    }

    List<LineGroup> getMarkers() {
        return this.markers;
    }

    public ColorPickerManager getColourPickerManager() {
        return this.colourPickerManager;
    }
}

