/*
 * Decompiled with CFR 0.152.
 */
package com.linemarkers;

import com.linemarkers.Line;
import com.linemarkers.LineGroup;
import com.linemarkers.LineMarkerConfig;
import com.linemarkers.LineMarkerPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.ComboBoxListRenderer;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

class LineMarkerPanel
extends JPanel {
    private static final Border NAME_BOTTOM_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR));
    private static final ImageIcon SETTINGS_ICON;
    private static final ImageIcon SETTINGS_HOVER_ICON;
    private static final ImageIcon NO_SETTINGS_ICON;
    private static final ImageIcon NO_SETTINGS_HOVER_ICON;
    private static final ImageIcon VISIBLE_ICON;
    private static final ImageIcon VISIBLE_HOVER_ICON;
    private static final ImageIcon INVISIBLE_ICON;
    private static final ImageIcon INVISIBLE_HOVER_ICON;
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;
    private static final ImageIcon COLLAPSE_ICON;
    private static final ImageIcon COLLAPSE_HOVER_ICON;
    private static final ImageIcon EXPAND_ICON;
    private static final ImageIcon EXPAND_HOVER_ICON;
    private final LineMarkerPlugin plugin;
    private final LineGroup marker;
    private final JLabel visibilityMarker = new JLabel();
    private final JLabel deleteMarker = new JLabel();
    private final JButton expandToggle;
    private final JPanel markerContainer = new JPanel();
    private final FlatTextField nameInput = new FlatTextField();
    private final JLabel save = new JLabel("Save");
    private final JLabel cancel = new JLabel("Cancel");
    private final JLabel rename = new JLabel("Rename");

    LineMarkerPanel(final LineMarkerPlugin plugin, final LineMarkerConfig config, final LineGroup marker) {
        this.plugin = plugin;
        this.marker = marker;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel nameWrapper = new JPanel(new BorderLayout());
        nameWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        nameWrapper.setBorder(NAME_BOTTOM_BORDER);
        JPanel nameActions = new JPanel(new FlowLayout(2, 3, 3));
        nameActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.save.setVisible(false);
        this.save.setFont(FontManager.getRunescapeSmallFont());
        this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.save.setBorder(new EmptyBorder(3, 0, 0, 3));
        this.save.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LineMarkerPanel.this.save();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LineMarkerPanel.this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LineMarkerPanel.this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
            }
        });
        this.cancel.setVisible(false);
        this.cancel.setFont(FontManager.getRunescapeSmallFont());
        this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.cancel.setBorder(new EmptyBorder(3, 0, 0, 3));
        this.cancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LineMarkerPanel.this.cancel();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LineMarkerPanel.this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LineMarkerPanel.this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            }
        });
        this.rename.setFont(FontManager.getRunescapeSmallFont());
        this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        this.rename.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LineMarkerPanel.this.nameInput.setEditable(true);
                LineMarkerPanel.this.updateNameActions(true);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LineMarkerPanel.this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker().darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LineMarkerPanel.this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            }
        });
        this.nameInput.setText(marker.getName());
        this.nameInput.setBorder(null);
        this.nameInput.setEditable(false);
        this.nameInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameInput.setPreferredSize(new Dimension(0, 24));
        this.nameInput.getTextField().setForeground(Color.WHITE);
        this.nameInput.getTextField().setBorder(new EmptyBorder(0, 5, 0, 0));
        this.nameInput.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LineMarkerPanel.this.save();
                } else if (e.getKeyCode() == 27) {
                    LineMarkerPanel.this.cancel();
                }
            }
        });
        this.nameInput.getTextField().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    marker.setCollapsed(!marker.isCollapsed());
                    LineMarkerPanel.this.updateCollapsed();
                    plugin.saveMarkers();
                }
            }
        });
        this.expandToggle = new JButton(marker.isCollapsed() ? COLLAPSE_ICON : EXPAND_ICON);
        this.expandToggle.setRolloverIcon(marker.isCollapsed() ? COLLAPSE_HOVER_ICON : EXPAND_HOVER_ICON);
        this.expandToggle.setPreferredSize(new Dimension(15, 0));
        this.expandToggle.setBorder(new EmptyBorder(0, 6, 1, 0));
        this.expandToggle.setToolTipText((marker.isCollapsed() ? "Expand" : "Collapse") + " marker");
        SwingUtil.removeButtonDecorations((AbstractButton)this.expandToggle);
        this.expandToggle.addActionListener(actionEvent -> {
            marker.setCollapsed(!marker.isCollapsed());
            this.updateCollapsed();
            plugin.saveMarkers();
        });
        this.visibilityMarker.setIcon(marker.isVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
        this.visibilityMarker.setToolTipText((marker.isVisible() ? "Hide" : "Show") + " marker");
        this.visibilityMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                marker.setVisible(!marker.isVisible());
                LineMarkerPanel.this.visibilityMarker.setIcon(marker.isVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
                plugin.saveMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LineMarkerPanel.this.visibilityMarker.setIcon(marker.isVisible() ? VISIBLE_HOVER_ICON : INVISIBLE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LineMarkerPanel.this.visibilityMarker.setIcon(marker.isVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
            }
        });
        this.deleteMarker.setIcon(DELETE_ICON);
        this.deleteMarker.setToolTipText("Delete marker");
        this.deleteMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int confirm = JOptionPane.showConfirmDialog(LineMarkerPanel.this, "Are you sure you want to permanently delete this line marker?", "Warning", 2);
                if (confirm == 0) {
                    plugin.removeMarker(marker);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LineMarkerPanel.this.deleteMarker.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LineMarkerPanel.this.deleteMarker.setIcon(DELETE_ICON);
            }
        });
        nameActions.add(this.rename);
        nameActions.add(this.cancel);
        nameActions.add(this.save);
        nameActions.add(this.visibilityMarker);
        nameActions.add(this.deleteMarker);
        nameWrapper.add((Component)this.expandToggle, "West");
        nameWrapper.add((Component)this.nameInput, "Center");
        nameWrapper.add((Component)nameActions, "East");
        this.markerContainer.setLayout(new BoxLayout(this.markerContainer, 1));
        this.markerContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.markerContainer.add(nameWrapper);
        for (final Line line : marker.getLines()) {
            JPanel container = new JPanel(new BorderLayout());
            container.setBorder(new EmptyBorder(5, 0, 5, 0));
            container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            JPanel leftActions = new JPanel(new FlowLayout(0, 8, 0));
            leftActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            JPanel rightActions = new JPanel(new FlowLayout(2, 8, 0));
            rightActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            final JLabel colour = new JLabel();
            colour.setToolTipText("Edit line colour");
            colour.setForeground(line.getColour() == null ? config.defaultColour() : line.getColour());
            colour.setBorder(line.getWidth() == 0.0 ? null : new MatteBorder(0, 0, 3, 0, line.getColour()));
            colour.setIcon(line.getWidth() == 0.0 ? NO_SETTINGS_ICON : SETTINGS_ICON);
            colour.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    RuneliteColorPicker colourPicker = LineMarkerPanel.this.getColourPicker(line.getColour() == null ? config.defaultColour() : line.getColour());
                    colourPicker.setOnColorChange(c -> {
                        line.setColour((Color)c);
                        colour.setBorder(line.getWidth() == 0.0 ? null : new MatteBorder(0, 0, 3, 0, line.getColour()));
                        colour.setIcon(line.getWidth() == 0.0 ? NO_SETTINGS_ICON : SETTINGS_ICON);
                    });
                    colourPicker.setVisible(true);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    colour.setIcon(line.getWidth() == 0.0 ? NO_SETTINGS_HOVER_ICON : SETTINGS_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    colour.setIcon(line.getWidth() == 0.0 ? NO_SETTINGS_ICON : SETTINGS_ICON);
                }
            });
            final JButton edge = new JButton();
            edge.setPreferredSize(new Dimension(50, 24));
            edge.setBorder(new EmptyBorder(0, 0, 0, 0));
            edge.setText(line.getEdge().toString());
            edge.setToolTipText("Line edge");
            edge.setFont(FontManager.getRunescapeSmallFont());
            edge.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    line.setEdge(line.getEdge().next());
                    edge.setText(line.getEdge().toString());
                    plugin.saveMarkers();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    edge.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    edge.setBackground(ColorScheme.DARK_GRAY_COLOR);
                }
            });
            final JSpinner width = new JSpinner(new SpinnerNumberModel(3.0, 0.0, 10.0, 0.1));
            width.setValue(line.getWidth());
            width.setToolTipText("Line width");
            width.setPreferredSize(new Dimension(53, 20));
            width.addChangeListener(ce -> {
                line.setWidth((Double)width.getValue());
                plugin.saveMarkers();
            });
            List<LineGroup> groups = plugin.getGroups();
            String[] names = new String[groups.size()];
            for (int i = 0; i < groups.size(); ++i) {
                names[i] = groups.get(i).getName();
            }
            final JLabel groupButton = new JLabel();
            final JLabel deleteLine = new JLabel();
            final JLabel groupText = new JLabel("Group:");
            final JComboBox<String> groupSelection = new JComboBox<String>(names);
            groupText.setFont(FontManager.getRunescapeSmallFont());
            groupText.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            groupText.setVisible(false);
            final JLabel groupCancel = new JLabel("Cancel");
            groupCancel.setVisible(false);
            groupCancel.setFont(FontManager.getRunescapeSmallFont());
            groupCancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            groupCancel.setBorder(new EmptyBorder(6, 0, 0, 1));
            groupCancel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    groupText.setVisible(false);
                    groupSelection.setVisible(false);
                    groupCancel.setVisible(false);
                    colour.setVisible(true);
                    edge.setVisible(true);
                    width.setVisible(true);
                    groupButton.setVisible(true);
                    deleteLine.setVisible(true);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    groupCancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    groupCancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
                }
            });
            groupSelection.setVisible(false);
            groupSelection.setRenderer((ListCellRenderer<String>)new ComboBoxListRenderer());
            groupSelection.setPreferredSize(new Dimension(115, 24));
            groupSelection.setSelectedIndex(groups.indexOf(marker));
            groupSelection.setToolTipText("Marker group");
            groupSelection.addActionListener(e -> {
                marker.getLines().remove(line);
                ((LineGroup)groups.get(groupSelection.getSelectedIndex())).getLines().add(line);
                if (marker.getLines().isEmpty()) {
                    groups.remove(marker);
                }
                groupText.setVisible(false);
                groupSelection.setVisible(false);
                groupCancel.setVisible(false);
                colour.setVisible(true);
                edge.setVisible(true);
                width.setVisible(true);
                groupButton.setVisible(true);
                deleteLine.setVisible(true);
                plugin.saveMarkers();
                plugin.rebuild();
            });
            groupButton.setIcon(SETTINGS_ICON);
            groupButton.setToolTipText("Edit group");
            groupButton.setBorder(new EmptyBorder(1, 0, 0, 0));
            groupButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    ActionListener actionListener = groupSelection.getActionListeners()[0];
                    groupSelection.removeActionListener(actionListener);
                    groupSelection.removeAllItems();
                    for (LineGroup group : plugin.getGroups()) {
                        groupSelection.addItem(group.getName());
                    }
                    groupSelection.setSelectedIndex(plugin.getGroups().indexOf(marker));
                    groupSelection.addActionListener(actionListener);
                    colour.setVisible(false);
                    edge.setVisible(false);
                    width.setVisible(false);
                    groupButton.setVisible(false);
                    deleteLine.setVisible(false);
                    groupText.setVisible(true);
                    groupSelection.setVisible(true);
                    groupCancel.setVisible(true);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    groupButton.setIcon(SETTINGS_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    groupButton.setIcon(SETTINGS_ICON);
                }
            });
            deleteLine.setIcon(DELETE_ICON);
            deleteLine.setToolTipText("Delete line segment");
            deleteLine.setBorder(new EmptyBorder(1, 0, 0, 0));
            deleteLine.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int confirm = JOptionPane.showConfirmDialog(LineMarkerPanel.this, "Are you sure you want to permanently delete this line segment?", "Warning", 2);
                    if (confirm == 0) {
                        plugin.removeMarker(line);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    deleteLine.setIcon(DELETE_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    deleteLine.setIcon(DELETE_ICON);
                }
            });
            leftActions.add(colour);
            leftActions.add(edge);
            leftActions.add(width);
            leftActions.add(groupText);
            leftActions.add(groupSelection);
            rightActions.add(groupButton);
            rightActions.add(groupCancel);
            rightActions.add(deleteLine);
            container.add((Component)leftActions, "West");
            container.add((Component)rightActions, "East");
            this.markerContainer.add(container);
        }
        this.add(this.markerContainer);
        this.updateCollapsed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void save() {
        String newName = this.nameInput.getText();
        if (newName.equals(this.marker.getName())) {
            this.cancel();
            return;
        }
        LineGroup newGroup = null;
        for (LineGroup group : this.plugin.getGroups()) {
            if (!newName.equals(group.getName()) || group.equals(this.marker)) continue;
            newGroup = group;
            break;
        }
        if (newGroup != null) {
            int confirm = JOptionPane.showConfirmDialog(this, "Are you sure you want to combine this line marker with the other line marker with the same name?", "Warning", 2);
            if (confirm != 0) return;
            for (Line line : this.marker.getLines()) {
                newGroup.getLines().add(line);
            }
            this.plugin.removeMarker(this.marker);
        } else {
            this.marker.setName(newName);
            this.plugin.saveMarkers();
        }
        this.nameInput.setEditable(false);
        this.updateNameActions(false);
        this.requestFocusInWindow();
    }

    private void cancel() {
        this.nameInput.setEditable(false);
        this.nameInput.setText(this.marker.getName());
        this.updateNameActions(false);
        this.requestFocusInWindow();
    }

    private void updateNameActions(boolean saveAndCancel) {
        this.save.setVisible(saveAndCancel);
        this.cancel.setVisible(saveAndCancel);
        this.rename.setVisible(!saveAndCancel);
        this.expandToggle.setVisible(!saveAndCancel);
        this.visibilityMarker.setVisible(!saveAndCancel);
        this.deleteMarker.setVisible(!saveAndCancel);
        if (saveAndCancel) {
            this.nameInput.getTextField().requestFocusInWindow();
            this.nameInput.getTextField().selectAll();
        }
    }

    private void updateCollapsed() {
        boolean open = !this.marker.isCollapsed();
        this.rename.setVisible(open);
        for (int i = 1; i < this.markerContainer.getComponentCount(); ++i) {
            this.markerContainer.getComponent(i).setVisible(open);
        }
        this.expandToggle.setIcon(open ? COLLAPSE_ICON : EXPAND_ICON);
        this.expandToggle.setRolloverIcon(open ? COLLAPSE_HOVER_ICON : EXPAND_HOVER_ICON);
        this.expandToggle.setToolTipText((open ? "Collapse" : "Expand") + " marker");
    }

    private RuneliteColorPicker getColourPicker(Color colour) {
        RuneliteColorPicker colourPicker = this.plugin.getColourPickerManager().create(SwingUtilities.windowForComponent(this), colour, this.marker.getName() + " line segment colour", false);
        colourPicker.setLocationRelativeTo((Component)this);
        colourPicker.setOnClose(c -> this.plugin.saveMarkers());
        return colourPicker;
    }

    static {
        BufferedImage borderImg = ImageUtil.loadImageResource(LineMarkerPlugin.class, (String)"settings_icon.png");
        BufferedImage borderImgHover = ImageUtil.luminanceOffset((Image)borderImg, (int)-150);
        SETTINGS_ICON = new ImageIcon(borderImg);
        SETTINGS_HOVER_ICON = new ImageIcon(borderImgHover);
        NO_SETTINGS_ICON = new ImageIcon(borderImgHover);
        NO_SETTINGS_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)borderImgHover, (int)-100));
        BufferedImage visibleImg = ImageUtil.loadImageResource(LineMarkerPlugin.class, (String)"visible_icon.png");
        VISIBLE_ICON = new ImageIcon(visibleImg);
        VISIBLE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)visibleImg, (int)-100));
        BufferedImage invisibleImg = ImageUtil.loadImageResource(LineMarkerPlugin.class, (String)"invisible_icon.png");
        INVISIBLE_ICON = new ImageIcon(invisibleImg);
        INVISIBLE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)invisibleImg, (int)-100));
        BufferedImage deleteImg = ImageUtil.loadImageResource(LineMarkerPlugin.class, (String)"delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteImg);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteImg, (int)-100));
        BufferedImage retractIcon = ImageUtil.loadImageResource(LineMarkerPlugin.class, (String)"arrow_right.png");
        retractIcon = ImageUtil.luminanceOffset((Image)retractIcon, (int)-121);
        EXPAND_ICON = new ImageIcon(retractIcon);
        EXPAND_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)retractIcon, (int)-100));
        BufferedImage expandIcon = ImageUtil.rotateImage((BufferedImage)retractIcon, (double)1.5707963267948966);
        COLLAPSE_ICON = new ImageIcon(expandIcon);
        COLLAPSE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)expandIcon, (int)-100));
    }
}

